<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="RECOVERY_WIZARD@recoveryBundle@servletRequest"/>
      <db:script src="/database/utils.js"/> <%-- lovField support --%>
    </uix:metaContainer>

    <uix:body>
    <db:form name="evaluateForm" destination="/console/database/rec/flashback" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>
	<uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="RECOVERY_EVALUATE_ROWS_PG@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>
	<%@ include file="/database/rec/trainMessages.jspf" %>
	<uix:labeledFieldLayout width="75%">
            <uix:styledText styleClass="OraInstructionText" textBinding="TABLE_NAME_LABEL@recoveryBundle@servletRequest" />
	    <uix:styledText styleClass="OraDataText" textBinding="evaluateTableName@defaultBean@servletRequest"/>
	</uix:labeledFieldLayout>

          <uix:contents>
<%-- FILTER ROWS AND COLUMNS LABEL --%>
            <%-- uix:header textBinding="FILTER_ROWS_AND_COLUMNS_LABEL@recoveryBundle@servletRequest" --%>
<%-- EVALUATE ROWS INTRODUCTION --%>
            <uix:styledText styleClass="OraInstructionText" textBinding="EVALUATE_ROWS_INTRO@recoveryBundle@servletRequest"/>
            <uix:header textBinding="COLUMNS_LABEL@recoveryBundle@servletRequest">
	     <uix:tableLayout cellSpacing="5" summary="tl">
<%-- EVALUATE COLUMNS SHUTTLE --%>
                <uix:rowLayout>
		<uix:spacer width="10"/>
		<uix:stackLayout>
                  <oem:shuttle name="tableColumns"
			       leadingHeaderBinding="AVAILABLE_COLUMNS@recoveryBundle@servletRequest"
                               trailingHeaderBinding="SELECTED_COLUMNS@recoveryBundle@servletRequest"
			       size="5" reorderable="true">
                    <uix:leading>
                      <oem:list name="nonSelectedEvaluateColumns" optionsBinding="nonSelectedEvaluateColumns@defaultBean@servletRequest" shortDescBinding="AVAILABLE_COLUMNS@recoveryBundle@servletRequest" multiple="true"/>
                    </uix:leading>
                    <uix:trailing>
                      <oem:list name="evaluateColumns" optionsBinding="evaluateColumns@defaultBean@servletRequest" shortDescBinding="SELECTED_COLUMNS@recoveryBundle@servletRequest" multiple="true"/>
                    </uix:trailing>
                  </oem:shuttle>
		<uix:messageText messageType="error" messageBinding="(COLUMNS_LABEL@recoveryBundle@servletRequest)@errors@servletRequest"/>
	      </uix:stackLayout>
              </uix:rowLayout>
            </uix:tableLayout>
	    </uix:header>
<%-- WHERE CLAUSE --%>
            <uix:header textBinding="WHERE_CLAUSE@recoveryBundle@servletRequest">
	    <uix:tableLayout cellSpacing="5" summary="tl">
	    <uix:rowLayout>
		<uix:messagePrompt promptBinding="WHERE_CLAUSE_INTRO@recoveryBundle@servletRequest"/>
	    </uix:rowLayout>
	    <uix:rowLayout>
		<uix:stackLayout>
		<uix:messageTextInput name="whereClause" rows="3" columns="88"
			textBinding="whereClause@defaultBean@servletRequest"
			tipBinding="WHERE_CLAUSE_TIP@recoveryBundle@servletRequest"/>
		<uix:messageText messageType="error" messageBinding="(WHERE_CLAUSE@recoveryBundle@servletRequest)@errors@servletRequest"/>
		</uix:stackLayout>
	    </uix:rowLayout>
	    </uix:tableLayout>
	    </uix:header>
            <uix:header textBinding="TIME_RANGE@recoveryBundle@servletRequest">
	    <uix:tableLayout cellSpacing="5" width="90%" summary="tl">
	    <uix:rowLayout>
		<uix:messagePrompt promptBinding="TIME_RANGE_INTRO@recoveryBundle@servletRequest"/>
	    </uix:rowLayout>
<%-- MIN AND MAX --%>
	    <uix:rowLayout>
		<oem:radioButton name="rowVersionsType" value="use_min_max"
			selectedValueBinding="rowVersionsType@defaultBean@pageContext"
			textBinding="SHOW_ALL_ROW_VERSIONS@recoveryBundle@servletRequest"
			styleClass="OraInstructionText" />
	    </uix:rowLayout>
<%-- TIMESTAMP --%>
	    <uix:rowLayout>
		<oem:radioButton name="rowVersionsType" value="use_Timestamp"
			selectedValueBinding="rowVersionsType@defaultBean@pageContext"
			textBinding="SPECIFY_TIMESTAMP@recoveryBundle@servletRequest"
      shortDescBinding="DATE_LABEL@recoveryBundle@servletRequest"
			styleClass="OraInstructionText" />
	    </uix:rowLayout>
	    <uix:rowLayout>
            <uix:labeledFieldLayout columns="2" labelWidth="15%" width="70%">
		<uix:messagePrompt promptBinding="START_DATE_LABEL@recoveryBundle@servletRequest" labeledNodeId="start_date_label"/>
		<uix:dateField name="rowVersionsStartDate" columns="10"
			valueBinding="rowVersionsStartDate@defaultBean@pageContext" id="start_date_label">
		<uix:onSubmitValidater>
                	<uix:date dateStyle="medium"/>
		</uix:onSubmitValidater>
                </uix:dateField>
		<uix:messagePrompt labeledNodeId="startTime" promptBinding="START_TIME@recoveryBundle@servletRequest"/>

		<uix:rowLayout>
		<oem:choice name="rowVersionsStartTimeHour" id="startTime"
			optionsBinding="flashbackTimeHours@defaultBean@pageContext"
			selectedValueBinding="rowVersionsStartTimeHour@defaultBean@pageContext"
      shortDescBinding="START_TIME@recoveryBundle@servletRequest"/>
	        <oem:choice name="rowVersionsStartTimeMinute"
			optionsBinding="flashbackTimeMinutes@defaultBean@pageContext"
			selectedValueBinding="rowVersionsStartTimeMinute@defaultBean@pageContext"
      shortDescBinding="START_TIME@recoveryBundle@servletRequest"/>
	        <oem:radioButton name="rowVersionsStartTimeAmPm" value="AM"
        	        selectedValueBinding="rowVersionsStartTimeAmPm@defaultBean@pageContext"
                	textBinding="AM_LABEL@recoveryBundle@servletRequest"
                       	styleClass="OraInstructionText" />
	        <oem:radioButton name="rowVersionsStartTimeAmPm" value="PM"
        	        selectedValueBinding="rowVersionsStartTimeAmPm@defaultBean@pageContext"
                	textBinding="PM_LABEL@recoveryBundle@servletRequest"
                        styleClass="OraInstructionText" />
		</uix:rowLayout>
		<uix:messagePrompt promptBinding="END_DATE_LABEL@recoveryBundle@servletRequest" labeledNodeId="end_date_label"/>
		<uix:dateField name="rowVersionsEndDate" columns="10"
			valueBinding="rowVersionsEndDate@defaultBean@pageContext" id="end_date_label">
		<uix:onSubmitValidater>
                	<uix:date dateStyle="medium"/>
		</uix:onSubmitValidater>
                </uix:dateField>
		<uix:messagePrompt labeledNodeId="view_choice2" promptBinding="END_TIME@recoveryBundle@servletRequest"/>
		<uix:rowLayout>
		<oem:choice name="rowVersionsEndTimeHour" id="view_choice2"
			optionsBinding="flashbackTimeHours@defaultBean@pageContext"
			selectedValueBinding="rowVersionsEndTimeHour@defaultBean@pageContext"
      shortDescBinding="END_TIME@recoveryBundle@servletRequest"/>
	        <oem:choice name="rowVersionsEndTimeMinute"
			optionsBinding="flashbackTimeMinutes@defaultBean@pageContext"
			selectedValueBinding="rowVersionsEndTimeMinute@defaultBean@pageContext"
      shortDescBinding="END_TIME@recoveryBundle@servletRequest"/>
	        <oem:radioButton name="rowVersionsEndTimeAmPm" value="AM"
        	        selectedValueBinding="rowVersionsEndTimeAmPm@defaultBean@pageContext"
                	textBinding="AM_LABEL@recoveryBundle@servletRequest"
                       	styleClass="OraInstructionText" />
	        <oem:radioButton name="rowVersionsEndTimeAmPm" value="PM"
        	        selectedValueBinding="rowVersionsEndTimeAmPm@defaultBean@pageContext"
                	textBinding="PM_LABEL@recoveryBundle@servletRequest"
                        styleClass="OraInstructionText" />
		</uix:rowLayout>
		</uix:labeledFieldLayout>
	    </uix:rowLayout>
<%-- SCN --%>
	    <uix:rowLayout>
		<oem:radioButton name="rowVersionsType" value="use_SCN"
			selectedValueBinding="rowVersionsType@defaultBean@pageContext"
			textBinding="SPECIFY_SCN@recoveryBundle@servletRequest"
      shortDesc="SCN_LABEL@recoveryBundle@servletRequest"
			styleClass="OraInstructionText" />
	    </uix:rowLayout>
	    <uix:rowLayout>
	    <uix:labeledFieldLayout columns="1" labelWidth="10%">
	      <uix:messagePrompt labeledNodeId="startScn" promptBinding="START_SCN@recoveryBundle@servletRequest"/>
	      <uix:stackLayout>
		<uix:textInput name="rowVersionsStartSCN" id="startScn"  textBinding="rowVersionsStartSCN@defaultBean@pageContext"/>
	        <uix:messageText messageType="error" messageBinding="(START_SCN@recoveryBundle@servletRequest)@errors@servletRequest"/>
	      </uix:stackLayout>
	      <uix:messagePrompt labeledNodeId="endScn" promptBinding="END_SCN@recoveryBundle@servletRequest"/>
	      <uix:stackLayout>
		<uix:textInput name="rowVersionsEndSCN" id="endScn" textBinding="rowVersionsEndSCN@defaultBean@pageContext"/>
	        <uix:messageText messageType="error" messageBinding="(END_SCN@recoveryBundle@servletRequest)@errors@servletRequest"/>
	      </uix:stackLayout>
	    </uix:labeledFieldLayout>
	    </uix:rowLayout>
	    </uix:tableLayout>
	    </uix:header>
	    <%-- /uix:header --%>

<%-- ROWS RESULTS --%>
            <%-- uix:header textBinding="RESULT_LABEL@recoveryBundle@servletRequest" --%>
<%-- ROWS RESULTS INTRODUCTION --%>
            <%-- uix:styledText styleClass="OraInstructionText" textBinding="ROWS_RESULTS_INTRO@recoveryBundle@servletRequest"/>
	    <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" --%>
<%-- RESULTS TABLE --%>
		<%-- oem:table width = "100%" name="matchedRowsUIDataSource"
		    blockSize="10"
                    dataSourceProp="matchedRowsUIDataSource"
                    beanKey="matchedRowsDataSourceBean"
                    formSubmitted="true"
		    alternateTextBinding="NO_ROWS_FOUND@recoveryBundle@servletRequest"
		    copyParams="target,type">
		<uix:tableSelection>
		  <uix:singleSelection
		    shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
		    selectedIndexBinding="selectedIndex@matchedRowsDataSourceBean@servletRequest">
	          </uix:singleSelection>
		</uix:tableSelection>
                </oem:table>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
	    </uix:header --%>
      </uix:contents>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <%-- uix:submitButton formName="evaluateForm" textBinding="BACK_TO_OBJECT@recoveryBundle@servletRequest" name="event" value="restart"/ --%>
                <uix:submitButton textBinding="CANCEL@recoveryBundle@servletRequest" formName="evaluateForm" name="event" value="cancel" shortDescBinding="CANCEL@recoveryBundle@servletRequest"/>
                <uix:submitButton textBinding="SHOW_ROW_HISTORY_SQL@recoveryBundle@servletRequest" name="event" value="showRowHistorySQL" shortDescBinding="SHOW_ROW_HISTORY_SQL@recoveryBundle@servletRequest"/>
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="evaluateForm"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
