<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="RECOVERY_WIZARD@recoveryBundle@servletRequest"/>
	<db:script src="/database/LOV.js"/> <%-- lovField support --%>
        <script>
          function lovCallBack(data)
          {
            destField = callBackLovField();
            if(data.indexOf('"')!=-1 || data.charCodeAt(0)>96)
            {
              document.forms[0].evaluateTableName.value=data;
              return;
            }
            var schema = checkForSpecialChars(data.substring(0,data.indexOf('.')));
            var table = checkForSpecialChars(data.substring(data.indexOf('.')+1,data.length));
            document.forms[0].evaluateTableName.value=schema+"."+table;
          }
         
          function checkForSpecialChars(object)
          {
            var tableObj = "";
            if(object!=null)
            {
              for(var i=0;i<object.length;i++)
              {
                var specialChar=object.charCodeAt(i);
                if( specialChar==33 )
                {
                  tableObj = '"'+object.substring(0,object.length)+'"';
                  break;
                }
                else if( specialChar>36 && specialChar<46 )
                {
                  tableObj = '"'+object.substring(0,object.length)+'"';
                  break;
                }
                else if( specialChar>57 && specialChar<65 )
                {
                  tableObj = '"'+object.substring(0,object.length)+'"';
                  break;
                }
                else if( specialChar>90 && specialChar<95 )
                {
                  tableObj = '"'+object.substring(0,object.length)+'"';
                  break;
                }
                else if( specialChar==96 || specialChar==47 )
                {
                  tableObj = '"'+object.substring(0,object.length)+'"';
                  break;
                }
                else if( specialChar>122 && specialChar<256 )
                {
                  tableObj = '"'+object.substring(0,object.length)+'"';
                  break;
                }
                else
                {
                  tableObj = object;
                }
              }
            } 
            return tableObj;
          }    
        </script>
      <uix:styleSheet/>
    </uix:metaContainer>

    <uix:body>

    <db:form name="flashbackSCNTimeForm" destination="/console/database/rec/flashback" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value" valueBinding="pageSequence@defaultBean@servletRequest"/>
	<uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="RECOVERY_SCN_TIME_OPTIONS_PG@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>
	<%@ include file="/database/rec/trainMessages.jspf" %>
          <uix:contents>
<%-- INSTRUCTION --%>
            <uix:styledText styleClass="OraInstructionText" textBinding="POINT_IN_TIME_INST@recoveryBundle@servletRequest" />
            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
<%-- EVALUATE_ROW_CHANGES --%>
                   <oem:radioButton name="flashbackType" value="unknown_scn"
                                     selectedValueBinding="flashbackType@defaultBean@pageContext"
                                     textBinding="EVALUATE_ROW_CHANGES@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />
                </uix:cellFormat>
              </uix:rowLayout>
<%-- TABLE LABEL --%>
              <uix:rowLayout>
		<uix:rowLayout>
                <uix:spacer width="20"/>
                <uix:labeledFieldLayout labelWidth="10%">
		  <uix:messagePrompt promptBinding="TABLE_LABEL@recoveryBundle@servletRequest"
				     required="yes" labeledNodeId="table_tag_id"/>
		  <uix:stackLayout>
<%-- TABLE INPUT LOV FIELD --%>
		  <uix:messageLovField name="evaluateTableName"
				textBinding="evaluateTableName@defaultBean@servletRequest"
				onClick="useCallBack(); startLov('evaluateTableName','ListTable')"
				tipBinding="TABLE_INPUT_HINT@recoveryBundle@servletRequest"
        id="table_tag_id"
        searchDescBinding="TABLE_INPUT_HINT@recoveryBundle@servletRequest"/>
		  <uix:messageText messageType="error" messageBinding="(TABLE_LABEL@recoveryBundle@servletRequest)@errors@servletRequest"/>
		  </uix:stackLayout>
		</uix:labeledFieldLayout>
	        </uix:rowLayout>
	      </uix:rowLayout>
<%-- USE_TIMESTAMP --%>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                   <oem:radioButton name="flashbackType" value="use_Timestamp"
                                     selectedValueBinding="flashbackType@defaultBean@pageContext"
                                     textBinding="KNOWN_TIMESTAMP@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />
		</uix:cellFormat>
	      </uix:rowLayout>
 	      <uix:rowLayout>
		<uix:cellFormat headers="">
		<uix:rowLayout>
                   <uix:spacer width="20"/>
		   <uix:messageDateField name="flashbackDate" columns="10" promptBinding="DATE_LABEL@recoveryBundle@servletRequest" valueBinding="flashbackDate@defaultBean@pageContext" tipBinding="DATE_INPUT_TIP@recoveryBundle@servletRequest">
		   <uix:onSubmitValidater>
                   <uix:date dateStyle="medium"/>
		   </uix:onSubmitValidater>
                   </uix:messageDateField>
		   <uix:messageText messageType="error" messageBinding="(KNOWN_TIMESTAMP@recoveryBundle@servletRequest)@errors@servletRequest"/>
                   <uix:spacer width="10"/>
		   <uix:messagePrompt promptBinding="TIME_LABEL@recoveryBundle@servletRequest"/>
                   <uix:spacer width="5"/>
		   <oem:choice name="flashbackTimeHour"
			optionsBinding="flashbackTimeHours@defaultBean@pageContext"
			selectedValueBinding="flashbackTimeHour@defaultBean@pageContext"
      shortDescBinding="TIME_LABEL@recoveryBundle@servletRequest"/>
	           <oem:choice name="flashbackTimeMinute"
			optionsBinding="flashbackTimeMinutes@defaultBean@pageContext"
			selectedValueBinding="flashbackTimeMinute@defaultBean@pageContext"
      shortDescBinding="TIME_LABEL@recoveryBundle@servletRequest"/>
	           <oem:radioButton name="flashbackTimeAmPm" value="AM"
        	        selectedValueBinding="flashbackTimeAmPm@defaultBean@pageContext"
                	textBinding="AM_LABEL@recoveryBundle@servletRequest"
                        styleClass="OraInstructionText" />
	           <oem:radioButton name="flashbackTimeAmPm" value="PM"
        	        selectedValueBinding="flashbackTimeAmPm@defaultBean@pageContext"
                	textBinding="PM_LABEL@recoveryBundle@servletRequest"
                        styleClass="OraInstructionText" />
		</uix:rowLayout>
		</uix:cellFormat>
              </uix:rowLayout>
<%-- USE_RESTORE_POINT --%>
           <uix:switcher childNameBinding="DB102orHigher@defaultBean@servletRequest">
           <uix:case name="true">
             <uix:rowLayout>
               <uix:cellFormat hAlign="left" headers="">
                 <oem:radioButton name="flashbackType" value="use_RestorePoint" selectedValueBinding="flashbackType@defaultBean@pageContext" textBinding="KNOWN_RESTOREPOINT@recoveryBundle@servletRequest" styleClass="OraInstructionText"/>
               </uix:cellFormat>
             </uix:rowLayout>
           </uix:case>
           </uix:switcher>
           <uix:switcher childNameBinding="DB102orHigher@defaultBean@servletRequest">
           <uix:case name="true">
             <uix:rowLayout>
             <uix:cellFormat  headers="">
             <uix:rowLayout>
               <uix:spacer width="20"/>
               <uix:messagePrompt labeledNodeId="restorePoint_id" promptBinding="RESTORE_POINT@recoveryBundle@servletRequest"/>
               <uix:spacer width="5"/>
               <uix:stackLayout>
                 <uix:messageLovField name="flashbackRestorePoint" textBinding="flashbackRestorePoint@defaultBean@servletRequest" onClick="preserveCase();startLov('flashbackRestorePoint', 'ListRestorePoint')" searchDescBinding="RESTORE_POINT@recoveryBundle@servletRequest" id="restorePoint_id"/>
               </uix:stackLayout>
             </uix:rowLayout>
             </uix:cellFormat>
             </uix:rowLayout>
           </uix:case>
           </uix:switcher>
<%-- USE_SCN --%>
	      <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                   <oem:radioButton name="flashbackType" value="use_SCN"
                      selectedValueBinding="flashbackType@defaultBean@pageContext"
		      textBinding="KNOWN_SCN@recoveryBundle@servletRequest"
		      styleClass="OraInstructionText" />
                </uix:cellFormat>
              </uix:rowLayout>
	      <uix:rowLayout>
		<uix:rowLayout>
                   <uix:spacer width="20"/>
 		   <uix:messagePrompt labeledNodeId="scnLabel" promptBinding="SCN_LABEL@recoveryBundle@servletRequest"/>
                   <uix:spacer width="5"/>
		   <uix:stackLayout>
		     <uix:textInput name="flashbackSCN" id="scnLabel" textBinding="flashbackSCN@defaultBean@pageContext"/>
		     <uix:messageText messageType="error" messageBinding="(KNOWN_SCN@recoveryBundle@servletRequest)@errors@servletRequest"/>
		   </uix:stackLayout>
		 </uix:rowLayout>
	      </uix:rowLayout>
<%-- OLD STUFF
              <uix:rowLayout>
                <uix:cellFormat hAlign="left">
                   <oem:radioButton name="scnStatus" value="known_scn"
                                     selectedValueBinding="scnStatus@defaultBean@pageContext"
                                     textBinding="KNOWN_SCN_OR_TIME@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />
		     <uix:tableLayout cellSpacing="5">
		       <uix:rowLayout>
			<uix:flowLayout>
		           <oem:radioButton name="scnOrTime" value="use_SCN"
        		   	            selectedValueBinding="scnOrTime@defaultBean@pageContext"
                        	            styleClass="OraInstructionText" />
 			   <uix:messagePrompt labeledNodeId="knownScn" promptBinding="KNOWN_SCN@recoveryBundle@servletRequest" />
			<uix:stackLayout>
			   <uix:textInput name="flashbackSCN" id="knownScn" textBinding="flashbackSCN@defaultBean@pageContext"/>
			  <uix:messageText messageType="error" messageBinding="(KNOWN_SCN@recoveryBundle@servletRequest)@errors@servletRequest"/>
			</uix:stackLayout>
			</uix:flowLayout>
		       </uix:rowLayout>
		       <uix:rowLayout>
                         <uix:cellFormat hAlign="left">
	                   <oem:radioButton name="scnOrTime" value="use_Timestamp"
        	                            selectedValueBinding="scnOrTime@defaultBean@pageContext"
                	                    textBinding="KNOWN_TIMESTAMP@recoveryBundle@servletRequest"
                        	            styleClass="OraInstructionText" />
			   <uix:dateField name="flashbackDate" columns="10" valueBinding="flashbackDate@defaultBean@pageContext">
			   <uix:onSubmitValidater>
                      	   <uix:date dateStyle="medium"/>
			   </uix:onSubmitValidater>
                  	   </uix:dateField>
		 	   <uix:messageText messageType="error" messageBinding="(KNOWN_TIMESTAMP@recoveryBundle@servletRequest)@errors@servletRequest"/>
			   <oem:choice name="flashbackTimeHour"
				optionsBinding="flashbackTimeHours@defaultBean@pageContext"
				selectedValueBinding="flashbackTimeHour@defaultBean@pageContext"/>
	                   <oem:choice name="flashbackTimeMinute"
				optionsBinding="flashbackTimeMinutes@defaultBean@pageContext"
				selectedValueBinding="flashbackTimeMinute@defaultBean@pageContext"/>
	                   <oem:radioButton name="flashbackTimeAmPm" value="AM"
        	                            selectedValueBinding="flashbackTimeAmPm@defaultBean@pageContext"
                	                    textBinding="AM_LABEL@recoveryBundle@servletRequest"
                        	            styleClass="OraInstructionText" />
	                   <oem:radioButton name="flashbackTimeAmPm" value="PM"
        	                            selectedValueBinding="flashbackTimeAmPm@defaultBean@pageContext"
                	                    textBinding="PM_LABEL@recoveryBundle@servletRequest"
                        	            styleClass="OraInstructionText" />
                         </uix:cellFormat>
                       </uix:rowLayout>
                     </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>
--%>
            </uix:tableLayout>
      </uix:contents>

          <uix:pageButtons>
              <uix:pageButtonBar>
 <%-- uix:submitButton formName="flashbackSCNTimeForm" textBinding="BACK_TO_OBJECT@recoveryBundle@servletRequest" name="event" value="restart"/ --%>
                <uix:submitButton textBinding="CANCEL@recoveryBundle@servletRequest" formName="flashbackSCNTimeForm" name="event" value="cancel" shortDescBinding="CANCEL@recoveryBundle@servletRequest"/>
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="flashbackSCNTimeForm"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
