<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<uix:bundle name="recoveryMsg"
	    class="oracle.sysman.db.rsc.rec.RecoveryMsg"/>
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="RECOVERY_WIZARD@recoveryMsg"/>
      <uix:styleSheet/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/flashback" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>
	<uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="RECOVERY_REVIEW@recoveryMsg">
        <%@ include file="/database/global.jspf" %>
	<%@ include file="/database/rec/trainMessages.jspf" %>
          <uix:contents>
	    <uix:tableLayout summary="tl">
	    <uix:rowLayout>
            <uix:styledText styleClass="OraInstructionText" textBinding="SUMMARY_INTRO1@recoveryMsg"/>
	    </uix:rowLayout>
	    </uix:tableLayout>
            <%-- uix:header textBinding="IMPACT_ANALYSIS@recoveryMsg">
	      <uix:textInput rows="15" columns="100"
	        shortDescBinding="summaryReport@defaultBean@pageContext"
	        textBinding="summaryReport@defaultBean@pageContext" readOnly="true"/>
	    </uix:header --%>
            <uix:switcher childNameBinding="scnOrTime@defaultBean@servletRequest">
              <uix:case name="use_RestorePoint">
                <uix:labeledFieldLayout width="75%">
	          <uix:messagePrompt promptBinding="FLASHBACK_RESTOREPOINT@recoveryBundle@servletRequest"/>
		  <uix:textInput name="selectedFlashbackRestorePoint" id="flashbackRestorePoint" textBinding="flashbackRestorePoint@defaultBean@servletRequest" columns="50" readOnly="true" styleClass="OraDataText"/>
	          <uix:messagePrompt promptBinding="SUMMARY_TABLES@recoveryMsg"/>
		  <uix:styledText styleClass="OraDataText" textBinding="flashbackTableNamesSummary@defaultBean@servletRequest"/>
		</uix:labeledFieldLayout>
	     </uix:case>
	   </uix:switcher>
           <uix:switcher childNameBinding="scnStatus@defaultBean@servletRequest">
 	     <uix:case name="known_scn">
	      <uix:labeledFieldLayout width="75%">
	 	<uix:messagePrompt promptBinding="SUMMARY_SCN_LABEL@recoveryMsg"/>
		<uix:styledText styleClass="OraDataText" textBinding="flashbackSCN@defaultBean@servletRequest"/>
		<uix:messagePrompt promptBinding="SUMMARY_TIMESTAMP_LABEL@recoveryMsg"/>
		<uix:styledText styleClass="OraDataText" textBinding="flashbackTimeStr@defaultBean@servletRequest"/>
		<uix:messagePrompt promptBinding="SUMMARY_TABLES@recoveryMsg"/>
		<uix:styledText styleClass="OraDataText" textBinding="flashbackTableNamesSummary@defaultBean@servletRequest"/>
	     </uix:labeledFieldLayout>
             </uix:case>
             <uix:case name="unknown_scn">
	       <uix:labeledFieldLayout width="75%">
		<uix:messagePrompt promptBinding="SUMMARY_SCN_LABEL@recoveryMsg"/>
		<uix:styledText styleClass="OraDataText" textBinding="flashbackSCN@defaultBean@servletRequest"/>
		<uix:messagePrompt promptBinding="SUMMARY_TIMESTAMP_LABEL@recoveryMsg"/>
		<uix:styledText styleClass="OraDataText" textBinding="flashbackTimeStr@defaultBean@servletRequest"/>
		<uix:messagePrompt promptBinding="SUMMARY_TABLES@recoveryMsg"/>
		<uix:styledText styleClass="OraDataText" textBinding="flashbackTableNamesSummary@defaultBean@servletRequest"/>
	      </uix:labeledFieldLayout>
	    </uix:case>
	  </uix:switcher>
	      <uix:switcher childNameBinding="dependOption@defaultBean@servletRequest">
		<uix:case name="cascade">
	        <uix:labeledFieldLayout width="75%">
		  <uix:messagePrompt promptBinding="SUMMARY_DEPENDENT_TABLES@recoveryMsg"/>
		  <uix:styledText styleClass="OraDataText" textBinding="flashbackDependentTableNamesSummary@defaultBean@servletRequest"/>
	     </uix:labeledFieldLayout>
		</uix:case>
		<uix:case name="customize">
	     <uix:labeledFieldLayout width="75%">
		<uix:messagePrompt promptBinding="SUMMARY_DEPENDENT_TABLES@recoveryMsg"/>
		<uix:styledText styleClass="OraDataText" textBinding="flashbackDependentTableNamesSummary@defaultBean@servletRequest"/>
	     </uix:labeledFieldLayout>
		</uix:case>
	     </uix:switcher>

      </uix:contents>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <%-- uix:submitButton formName="foo" textBinding="BACK_TO_OBJECT@recoveryMsg" name="event" value="restart"/ --%>
                <uix:submitButton textBinding="CANCEL@recoveryMsg" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@recoveryMsg"/>
                <uix:submitButton textBinding="SHOW_ROW_CHANGES@recoveryMsg" name="event" value="summaryShowRowChanges" shortDescBinding="SHOW_ROW_CHANGES@recoveryMsg"/>
                <uix:submitButton textBinding="SHOW_SQL@recoveryMsg" name="event" value="summaryShowSQL" shortDescBinding="SHOW_SQL@recoveryMsg"/>
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
                <uix:submitButton formName="foo" textBinding="SUBMIT@recoveryMsg" name="event" value="submit" shortDescBinding="SUBMIT@recoveryMsg"/>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>

    </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>
