<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="recoveryBundle"  class="oracle.sysman.db.rsc.rec.RecoveryMsg"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="RECOVERY_WIZARD@recoveryBundle@servletRequest"/>
      <uix:styleSheet/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/flashback" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value" valueBinding="pageSequence@defaultBean@servletRequest"/>
	<uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="RECOVERY_FLASHBACK_TABLES_PG@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>
	<%@ include file="/database/rec/trainMessages.jspf" %>
          <uix:contents>

	<uix:tableLayout cellSpacing="5" summary="tl">
	<uix:switcher childNameBinding="scnStatus@defaultBean@servletRequest">
	  <uix:case name="known_scn">
	    <uix:rowLayout>
              <uix:styledText styleClass="OraInstructionText" textBinding="WHICH_TABLES_TO_FLASHBACK@recoveryBundle@servletRequest" />
	    </uix:rowLayout>
	  </uix:case>
	  <uix:case name="unknown_scn">
	    <uix:rowLayout>
              <uix:styledText styleClass="OraInstructionText" textBinding="FLASHBACK_TABLES_INTRO@recoveryBundle@servletRequest" />
	    </uix:rowLayout>
	  </uix:case>
	</uix:switcher>
	</uix:tableLayout>

	<uix:switcher childNameBinding="scnStatus@defaultBean@servletRequest">
	  <uix:case name="unknown_scn">
	    <uix:labeledFieldLayout labelWidth="25%" width="75%">
		  <uix:messagePrompt promptBinding="EVALUATE_TABLE_NAME@recoveryBundle@servletRequest"/>
		  <uix:textInput name="selectedTableName" id="evaTableName" textBinding="evaluateTableName@defaultBean@servletRequest" columns="50" readOnly="true" styleClass="OraDataText"/>
	    </uix:labeledFieldLayout>
	  </uix:case>
	</uix:switcher>
        <uix:tableLayout cellSpacing="5" summary="tl">
         <uix:switcher childNameBinding="scnOrTime@defaultBean@servletRequest">
           <uix:case name="use_RestorePoint">
             <uix:rowLayout>
               <uix:styledText styleClass="OraInstructionText" textBinding="WHICH_TABLES_TO_FLASHBACK@recoveryBundle@servletRequest" />
             </uix:rowLayout>
           </uix:case>
         </uix:switcher>
       </uix:tableLayout>

       <uix:switcher childNameBinding="scnOrTime@defaultBean@servletRequest">
         <uix:case name="use_RestorePoint">
           <uix:labeledFieldLayout labelWidth="25%" width="75%">
             <uix:messagePrompt promptBinding="FLASHBACK_RESTOREPOINT@recoveryBundle@servletRequest"/>
             <uix:textInput name="selectedFlashbackRestorePoint" id="flashbackRestorePoint" textBinding="flashbackRestorePoint@defaultBean@servletRequest" columns="50" readOnly="true" styleClass="OraDataText"/>
           </uix:labeledFieldLayout>
         </uix:case>
       </uix:switcher>
       
       <uix:switcher childNameBinding="scnStatus@defaultBean@servletRequest">
         <uix:case name="known_scn">
	    <uix:labeledFieldLayout labelWidth="25%" width="75%">
		<uix:messagePrompt promptBinding="FLASHBACK_TIME@recoveryBundle@servletRequest"/>
		<uix:textInput name="selectedFlashbackTime" id="flashbackTime" textBinding="flashbackTimeStr@defaultBean@servletRequest" columns="50" readOnly="true" styleClass="OraDataText"/>
		<uix:messagePrompt promptBinding="FLASHBACK_SCN@recoveryBundle@servletRequest"/>
		<uix:textInput name="selectedFlashbackSCN" id="flashbackScn" textBinding="flashbackSCN@defaultBean@servletRequest" columns="50" readOnly="true" styleClass="OraDataText"/>
	    </uix:labeledFieldLayout>
         </uix:case>
         <uix:case name="unknown_scn">
           <uix:labeledFieldLayout labelWidth="25%" width="75%">
           <uix:messagePrompt promptBinding="FLASHBACK_TIME@recoveryBundle@servletRequest"/>
           <uix:textInput name="selectedFlashbackTime" id="flashbackTime" textBinding="flashbackTimeStr@defaultBean@servletRequest" columns="50" readOnly="true" styleClass="OraDataText"/>
           <uix:messagePrompt promptBinding="FLASHBACK_SCN@recoveryBundle@servletRequest"/>
           <uix:textInput name="selectedFlashbackSCN" id="flashbackScn" textBinding="flashbackSCN@defaultBean@servletRequest" columns="50" readOnly="true" styleClass="OraDataText"/>
           </uix:labeledFieldLayout>
         </uix:case>
       </uix:switcher>
	      <%-- uix:tableLayout cellSpacing="5">
		  <uix:rowLayout hAlign="left">
		  <uix:stackLayout>
		   <uix:messageTextInput name="flashbackTablesStr"
			promptBinding="TABLES_LABEL@recoveryBundle@servletRequest"
			rows="5" columns="50" tipBinding="TABLES_INPUT_HINT@recoveryBundle@servletRequest"
			textBinding="flashbackTablesStr@defaultBean@pageContext"/>
		   <uix:messageText messageType="error" messageBinding="(TABLES_LABEL@recoveryBundle@servletRequest)@errors@servletRequest"/>
		  </uix:stackLayout>
		   </uix:rowLayout>
		  <uix:rowLayout hAlign="right">
                   <uix:submitButton formName="foo" textBinding="SELECT_TABLES_LABEL@recoveryBundle@servletRequest" name="event" value="selectTables"/>
		  </uix:rowLayout>
		  </uix:tableLayout --%>
	    <uix:labeledFieldLayout labelWidth="25%" width="75%">
		<uix:rowLayout>
		<uix:messagePrompt promptBinding="TABLES_LABEL@recoveryBundle@servletRequest"/>
		</uix:rowLayout>
		<uix:rowLayout>
		<uix:stackLayout>
		<uix:messageTextInput name="flashbackTablesStr"
		rows="5" columns="50" tipBinding="TABLES_INPUT_HINT@recoveryBundle@servletRequest"
		textBinding="flashbackTablesStr@defaultBean@pageContext"/>
		<uix:messageText messageType="error" messageBinding="(TABLES_LABEL@recoveryBundle@servletRequest)@errors@servletRequest"/>
		</uix:stackLayout>
		<uix:spacer width="5"/>
                <uix:submitButton formName="foo" textBinding="SELECT_TABLES_LABEL@recoveryBundle@servletRequest" name="event" value="selectTables" shortDescBinding="SELECT_TABLES_LABEL@recoveryBundle@servletRequest"/>
		</uix:rowLayout>
	    </uix:labeledFieldLayout>
         
         <uix:switcher childNameBinding="rowMovementEnabled@defaultBean@servletRequest">
         <uix:case name="false">
          <uix:tableLayout summary="tl">
	    <uix:rowLayout>
                <uix:link textBinding="ENABLE_ROW_MOVEMENT_LINK@recoveryBundle" destinationBinding="enableRowMovementLink@defaultBean@servletRequest" />
	    </uix:rowLayout>
          </uix:tableLayout>
         </uix:case>
         </uix:switcher>

      </uix:contents>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <%-- uix:submitButton formName="foo" textBinding="BACK_TO_OBJECT@recoveryBundle@servletRequest" name="event" value="restart"/ --%>
                <uix:submitButton textBinding="CANCEL@recoveryBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@recoveryBundle@servletRequest"/>
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>

    </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>
