<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="RECYCLE_BIN@recoveryBundle@servletRequest"/>
      <db:script src="/database/LOV.js"/> <%-- lovField support --%>
      <uix:styleSheet/>
    </uix:metaContainer>

    <uix:body>
        <db:form name="undropObjSelection" destination="/em/console/database/rec/flashback" copyParams="target,type">

      <uix:pageLayout titleBinding="RECYCLE_BIN@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>
          <uix:messages>
          <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
          </uix:messages>
		<uix:spacer height="10"/>
	<uix:contents>
	  <uix:styledText styleClass="OraInstructionText"
                          textBinding="RECYCLE_BIN_TEXT@recoveryBundle@servletRequest" />
	<%--
	  <uix:tableLayout>
	  <uix:switcher childNameBinding="isDBA@defaultBean@servletRequest">
	    <uix:case name="true">
	      <uix:spacer height="10"/>
	      <uix:rowLayout>
	        <uix:tableLayout>
		 <uix:rowLayout>
		  <uix:cellFormat hAlign="right">
		    <uix:messagePrompt labeledNodeId="view_choice1" promptBinding="VIEW_OPTION_LABEL@recoveryBundle@servletRequest"/>
		  </uix:cellFormat>
	          <uix:spacer width="10"/>
		  <uix:cellFormat hAlign = "left">
		    <uix:choice name="viewOption" id="view_choice1" onChange="submitForm('undropObjSelection', true, {'event':'changeViewOption'})" selectedValueBinding="viewOption@recycleBinBean@servletRequest">
		      <uix:option textBinding="VIEW_YOUR_RECYCLEBIN@recoveryBundle@servletRequest" value="viewUserRecycleBin"/>
		      <uix:option textBinding="VIEW_ALL_RECYCLEBIN@recoveryBundle@servletRequest" value="viewDBARecycleBin"/>
		    </uix:choice>
		  </uix:cellFormat>
	         </uix:rowLayout>
		</uix:tableLayout>
	      </uix:rowLayout>
	    </uix:case>
	  </uix:switcher>
	  </uix:tableLayout>
	--%>
	    <uix:header textBinding="SEARCH_LABEL@recoveryBundle@servletRequest">
	    <uix:tableLayout cellSpacing="5" summary="tl">
	      <uix:rowLayout vAlign="bottom">
	      <uix:switcher childNameBinding="viewOption@recycleBinBean@servletRequest">
	        <uix:case name="viewDBARecycleBin">
		<uix:stackLayout>
		  <uix:messagePrompt promptBinding="SCHEMA_NAME_LABEL@recoveryBundle@servletRequest"/>
		  <uix:lovField name="tempSchemaName"
				textBinding="tempSchemaName@defaultBean@servletRequest"
        onClick="startLov('tempSchemaName','ListSchema')"/>
	        </uix:stackLayout>
   	        </uix:case>
              </uix:switcher>
	      <uix:stackLayout>
		  <uix:messagePrompt labeledNodeId="tableLabel" promptBinding="TABLE_LABEL@recoveryBundle@servletRequest"/>
		  <uix:textInput name="tempTableName" id="tableLabel"
				textBinding="tempTableName@defaultBean@servletRequest" />
	      </uix:stackLayout>
	      <uix:stackLayout>
		  <uix:submitButton textBinding="GO@recoveryBundle@servletRequest"
				  name="event" value="searchAvailableTables" shortDescBinding="GO@recoveryBundle@servletRequest"/>
	      </uix:stackLayout>
	      </uix:rowLayout>
	    </uix:tableLayout>
	    </uix:header>
	    <uix:header textBinding="RB_RESULT_LABEL@recoveryBundle@servletRequest">
            <uix:tableLayout cellSpacing="5" summary="tl">
  	    <uix:rowLayout>
	      <uix:stackLayout>
              <uix:hGrid id="recycleBin"
                           width="100%"
                           alternateTextBinding="NO_OBJ_FOUND@recoveryBundle@servletRequest"
                           destination="/em/console/database/rec/flashback"
                           formSubmitted="true"
			   columnFormatsBinding="columnFormats@recycleBinBean@servletRequest"
                           columnHeaderDataBinding="columnHeaderData@recycleBinBean@servletRequest"
                           treeDataBinding="treeData@recycleBinBean@servletRequest"
			   proxyBinding="proxy@servletRequest">
                  <uix:nodeStamp>
                    <uix:column>
                      <uix:columnHeader>
			<uix:styledText textBinding="OBJ_NAME_COL@recoveryBundle@servletRequest"/>
                      </uix:columnHeader>
		  	<uix:styledText textBinding="originalName"/>
                    </uix:column>
                  </uix:nodeStamp>

                  <uix:columnHeaderStamp>
		    <uix:text textBinding="headerName"/>
                  </uix:columnHeaderStamp>

	  	<uix:styledText textBinding="owner"/>
		<uix:styledText textBinding="objectType"/>
		<uix:styledText textBinding="tablespace"/>
		<uix:styledText textBinding="dropTime"/>
		<uix:styledText textBinding="createTime"/>
		<uix:styledText textBinding="size"/>
		<uix:submitButton textBinding="VIEW_CONTENT_BTN@recoveryBundle@servletRequest"
		name="event" valueBinding="viewContentEvent" disabledBinding="buttonDisabled" renderedBinding="buttonRendered" shortDescBinding="VIEW_CONTENT_BTN@recoveryBundle@servletRequest"/>

		<uix:formValue name="displayedItem" valueBinding="uniqueID"/>

		<uix:tableSelection>
		  <uix:multipleSelection disabledBinding="selectionDisabled"
					 shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" selectedBinding="selected">
		    <uix:submitButton textBinding="PURGE_BTN@recoveryBundle@servletRequest"
			name="event" value="purge"  shortDescBinding="PURGE_BTN@recoveryBundle@servletRequest"/>
		    <uix:submitButton textBinding="UNDROP_BTN@recoveryBundle@servletRequest"
			name="event" value="undrop"  shortDescBinding="UNDROP_BTN@recoveryBundle@servletRequest"/>
		  </uix:multipleSelection>
		</uix:tableSelection>
            </uix:hGrid>
	    <uix:messageText messageType="error" messageBinding="(RECYCLE_BIN@recoveryBundle@servletRequest)@errors@servletRequest"/>
	    </uix:stackLayout>
	  </uix:rowLayout>
	  </uix:tableLayout>
	  </uix:header>
	</uix:contents>
	<%--
	<uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton formName="undropObjSelection" textBinding="OK@recoveryBundle@servletRequest" name="event" value="backToTablesListPage"/>
              </uix:pageButtonBar>
	</uix:pageButtons>
	--%>
      </uix:pageLayout>
        </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
