<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>

<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

<uix:document>

<uix:metaContainer>
	<uix:head titleBinding="RECOVERY_WIZARD@recoveryBundle@servletRequest"/>
	<db:script src="/database/utils.js"/>
	<db:script src="/cabo/jsLibs/TableProxy.js"/>
</uix:metaContainer>
<head>
  <script>
    function lovSelect(lovField)
    {
      var proxy = new TableProxy('schemaUIDataSource');
      var selectedIndex = proxy.getSelectedRow();
      if (selectedIndex >= 0)
      {
        var selectedElement = proxy.getFormElement('Schema', selectedIndex);
        lovField.value = selectedElement.value;
        window.close();
      }
    }
  </script>
</head>

<uix:body>
    <db:form name="foo" destination="/console/database/rec/flashback" copyParams="target,type">
    <uix:formValue name="pageName" value="/database/rec/flashback/selectSchemaPage"/>
    <uix:formValue name="selectSchemaDestination" valueBinding="selectSchemaDestination@defaultBean@servletRequest"/>

  <uix:pageLayout titleBinding="SELECT_SCHEMA_TITLE@recoveryBundle@servletRequest">
    <%-- %@ include file="/database/global.jspf" % --%>
	<uix:contents>
          <uix:tableLayout cellSpacing="2" summary="tl">
	    <uix:rowLayout>
    	      <uix:cellFormat>
                <uix:spacer width="20"/>
              </uix:cellFormat>
              <uix:cellFormat>
	            <uix:stackLayout>
	              <uix:header textBinding="SEARCH_LABEL@recoveryBundle@servletRequest">
	                <uix:styledText textBinding="SELECT_SCHEMA_INTRO@recoveryBundle@servletRequest"/>
	                <uix:rowLayout>
	                  <uix:messagePrompt labeledNodeId="schemaNameLabel" promptBinding="SCHEMA_NAME_LABEL@recoveryBundle@servletRequest"/>
	                  <uix:spacer width="10"/>
	                  <uix:textInput name="schemaSearchCriteria" id="schemaNameLabel"
				textBinding="schemaSearchCriteria@defaultBean@servletRequest"/>
			</uix:rowLayout>
		        <uix:rowLayout>
	                  <uix:messagePrompt prompt="  "/>
	                  <uix:spacer width="10"/>
	                  <uix:submitButton textBinding="SEARCH_BTN@recoveryBundle@servletRequest" name="event" value="changeSchemaSearchCriteria" shortDescBinding="SEARCH_BTN@recoveryBundle@servletRequest"/>
	                </uix:rowLayout>
	              </uix:header>
	            </uix:stackLayout>
	          </uix:cellFormat>
	        </uix:rowLayout>
	        <uix:rowLayout>
	          <uix:cellFormat>
                <uix:spacer width="20"/>
              </uix:cellFormat>
              <uix:cellFormat>
                <uix:stackLayout>
	              <uix:header textBinding="AVAILABLE_SCHEMAS@recoveryBundle@servletRequest">
                    <oem:table name="schemaUIDataSource" blockSize="10"
                        destination="destination"
			formSubmitted="true"
			beanKey="defaultBean"
                        dataSourceProp="schemaUIDataSource" width="90%"
			alternateTextBinding="NO_ROWS_FOUND@recoveryBundle@servletRequest"
		     	copyParams="target,type">
		      <uix:tableSelection>
		      <uix:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" selectedIndex="0">
                      </uix:singleSelection>
		      </uix:tableSelection>
                    </oem:table>
	              </uix:header>
	            </uix:stackLayout>
		  </uix:cellFormat>
	        </uix:rowLayout>
	      </uix:tableLayout>

	</uix:contents>
	<uix:pageButtons>
	      <uix:pageButtonBar>
            <uix:button textBinding="CANCEL@recoveryBundle@servletRequest" destination="javascript:self.close()" shortDescBinding="CANCEL@recoveryBundle@servletRequest"/>
	    <uix:button textBinding="OK_BTN@recoveryBundle@servletRequest" destinationBinding="selectSchemaDestination@defaultBean@servletRequest" shortDescBinding="OK_BTN@recoveryBundle@servletRequest"/>
	      </uix:pageButtonBar>
	</uix:pageButtons>
      </uix:pageLayout>
    </db:form>
</uix:body>
</uix:document>
</uix:renderingContext>
