<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="RECOVERY_WIZARD@recoveryBundle@servletRequest"/>
      <db:script src="/database/utils.js"/> <%-- lovField support --%>
      <db:script src="/cabo/jsLibs/TableProxy.js"/>
    </uix:metaContainer>

    <head>
      <script>
      function lovSelect(lovField)
      {
        var proxy = new TableProxy('selectTableUIDataSource');
        var selectedIndex = proxy.getSelectedRow();
        if (selectedIndex >= 0)
        {
          var selectedTable = proxy.getFormElement('SelectedTable', selectedIndex);
          lovField.value = selectedTable.value;
          window.close();
        }
      }
      </script>
    </head>

    <uix:body>
        <db:form name="selectTBForm" destination="/console/database/rec/flashback" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>
	<uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="SELECT_TABLE_TITLE@recoveryBundle@servletRequest">
	<%-- %@ include file="/database/global.jspf" % --%>

        <uix:contents>
        <uix:header textBinding="SEARCH_LABEL@recoveryBundle@servletRequest">
<%-- searching criteria section --%>
	  <uix:styledText textBinding="SELECT_TABLE_INTRO@recoveryBundle@servletRequest"/>
          <uix:tableLayout cellSpacing="5" summary="tl">
	    <uix:rowLayout>
		  <uix:cellFormat hAlign="right" headers="">
		  <uix:messagePrompt labeledNodeId="schemaNameLabel" promptBinding="SCHEMA_NAME_LABEL@recoveryBundle@servletRequest"/>
		  </uix:cellFormat>
                  <uix:cellFormat hAlign="left" headers="">
		  <uix:textInput name="tempSchemaName" id="schemaNameLabel"
				textBinding="tempSchemaName@defaultBean@servletRequest"/>
		  </uix:cellFormat>
	    </uix:rowLayout>
	    <uix:rowLayout>
                  <uix:cellFormat hAlign="right" headers="">
		  <uix:messagePrompt labeledNodeId="tableLabel" promptBinding="TABLE_LABEL@recoveryBundle@servletRequest"/>
		  </uix:cellFormat>
		  <uix:cellFormat hAlign="left" headers="">
		  <uix:textInput name="tempTableName" id="tableLabel"
				textBinding="tempTableName@defaultBean@servletRequest" />
                  </uix:cellFormat>
	    </uix:rowLayout>
	    <uix:rowLayout>
		  <uix:cellFormat headers="">
		  <uix:messagePrompt prompt="  "/>
		  </uix:cellFormat>
		  <uix:cellFormat hAlign="left" headers="">
		  <uix:submitButton textBinding="SEARCH_BTN@recoveryBundle@servletRequest"
				  name="event" value="searchAvailableTables" shortDescBinding="SEARCH_BTN@recoveryBundle@servletRequest"/>
                  </uix:cellFormat>
	    </uix:rowLayout>
	    </uix:tableLayout>
<%-- end searching criteria section --%>
	    </uix:header>

            <uix:header textBinding="AVAILABLE_TABLES@recoveryBundle@servletRequest">
<%-- search result section --%>
  	    <uix:tableLayout cellSpacing="5" summary="tl">
            <uix:rowLayout>
              <uix:cellFormat headers="">
	        <oem:table width = "100%" name="selectTableUIDataSource"
		   blockSize="10"
                   dataSourceProp="selectTablesUIDataSource"
                   beanKey="selectTablesDataSourceBean"
                   destination="destination"
                   formSubmitted="true"
	    	   alternateTextBinding="NO_ROWS_FOUND@recoveryBundle@servletRequest"
		   copyParams="target,type">
	        <uix:tableSelection>
	        <uix:singleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
	            selectedIndex="0">
	        </uix:singleSelection>
	        </uix:tableSelection>
                </oem:table>
              </uix:cellFormat>
            </uix:rowLayout>
	    </uix:tableLayout>
<%-- end search result section --%>
	</uix:header>
	</uix:contents>
          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@recoveryBundle@servletRequest" destination="javascript:self.close()" shortDescBinding="CANCEL@recoveryBundle@servletRequest"/>
	        <uix:button textBinding="OK_BTN@recoveryBundle@servletRequest" destination="javascript:lovSelect(window.opener.document.flashbackSCNTimeForm.evaluateTableName)"  shortDescBinding="OK_BTN@recoveryBundle@servletRequest"/>
<%-- destinationBinding="selectTableDestination@defaultBean@servletRequest"/ --%>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
        </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
