<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="RECOVERY_WIZARD@recoveryBundle@servletRequest"/>
      <db:script src="/database/LOV.js"/> <%-- lovField support --%>
    </uix:metaContainer>

    <uix:body>
    <db:form name="selectTBForm" destination="/console/database/rec/flashback" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>
	<uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="SELECT_TABLES_TITLE@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>

	<uix:location>
            <uix:train selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
              <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
                <uix:link textBinding="." disabled="true"/>
              </uix:contents>
            </uix:train>
	</uix:location>
        <uix:messages>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        </uix:messages>
          <uix:contents>
            <uix:header textBinding="SEARCH_LABEL@recoveryBundle@servletRequest">
	    <uix:tableLayout cellSpacing="5" summary="tl">
	       <uix:rowLayout>
		<uix:cellFormat hAlign="right" headers="">
		  <uix:messagePrompt promptBinding="SCHEMA_NAME_LABEL@recoveryBundle@servletRequest"/>
		</uix:cellFormat>
		<uix:cellFormat hAlign = "left" headers="">
		  <uix:lovField name="tempSchemaName"
				textBinding="tempSchemaName@defaultBean@servletRequest"
        onClick="startLov('tempSchemaName','ListSchema')"/>
		</uix:cellFormat>
	       </uix:rowLayout>
	       <uix:rowLayout>
		<uix:cellFormat hAlign="right" headers="">
		  <uix:messagePrompt labeledNodeId="tableLabel" promptBinding="TABLE_LABEL@recoveryBundle@servletRequest"/>
		</uix:cellFormat>
		<uix:cellFormat hAlign = "left" headers="">
		  <uix:textInput name="tempTableName" id="tableLabel"
				textBinding="tempTableName@defaultBean@servletRequest" />
		</uix:cellFormat>
	       </uix:rowLayout>
	       <uix:rowLayout>
		<uix:cellFormat headers="">
		  <uix:messagePrompt prompt="  "/>
		</uix:cellFormat>
		<uix:cellFormat hAlign = "left" headers="">
		<uix:submitButton textBinding="SEARCH_BTN@recoveryBundle@servletRequest"
				  name="event" value="searchAvailableTables"/>
		</uix:cellFormat>
	       </uix:rowLayout>
	     </uix:tableLayout>
	    </uix:header>

            <uix:header textBinding="AVAILABLE_TABLES@recoveryBundle@servletRequest">
	    <uix:tableLayout cellSpacing="5"  summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
		<oem:table width = "100%" name="selectTablesUIDataSource"
		    blockSize="10"
                    dataSourceProp="selectTablesUIDataSource"
                    beanKey="selectTablesDataSourceBean"
                    destination="destination"
                    formSubmitted="true"
		    alternateTextBinding="NO_ROWS_FOUND@recoveryBundle@servletRequest"
		    copyParams="target,type">
		<uix:tableSelection>
		  <uix:multipleSelection shortDescBinding="SELECT@uixDBObjectBundle@servletRequest"
		        selectionBinding="selection@selectTablesDataSourceBean@servletRequest">
	          </uix:multipleSelection>
		</uix:tableSelection>
                </oem:table>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
	    </uix:header>
      </uix:contents>

	    <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@recoveryBundle@servletRequest" formName="selectTBForm" name="event" value="cancelFromSelectTables"/>
                <uix:submitButton formName="selectTBForm" textBinding="OK_BTN@recoveryBundle@servletRequest" name="event" value="okFromSelectTables"/>
              </uix:pageButtonBar>
	    </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
