<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="RECOVERY_WIZARD@recoveryBundle@servletRequest"/>
      <uix:styleSheet/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/flashback" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>
	<uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="SHOW_DEPEND_TITLE@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>
	<uix:location>
            <uix:train selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
              <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
                <uix:link textBinding="." disabled = "true"/>
              </uix:contents>
            </uix:train>
	</uix:location>
        <uix:messages>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        </uix:messages>

          <uix:contents>

            <uix:tableLayout cellSpacing="5" summary="tl"> 
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
		<%-- oem:table width = "100%" name="showAllDependUIDataSource"
                    dataSourceProp="showAllDependUIDataSource"
                    beanKey="showAllDependDataSourceBean"
                    destination="destination"
                    formSubmitted="true">
                </oem:table --%>
		<uix:hGrid id="dependHGrid"
                           width="80%"
                           alternateTextBinding="NO_OBJ_FOUND@recoveryBundle@servletRequest"
                           destination="/em/console/database/rec/flashback"
                           formSubmitted="true"
			   columnFormatsBinding="columnFormats@dependBean@servletRequest"
                           columnHeaderDataBinding="columnHeaderData@dependBean@servletRequest"
                           treeDataBinding="treeData@dependBean@servletRequest"
			   proxyBinding="proxy@servletRequest"
         summaryBinding="TABLE_DEPEND_COL@recoveryBundle@servletRequest">
                  <uix:nodeStamp>
                    <uix:column>
                      <uix:columnHeader>
		  	<uix:styledText textBinding="OWNER_COL@recoveryBundle@servletRequest"/>
                      </uix:columnHeader>
		  	<uix:styledText textBinding="owner"/>
                    </uix:column>
                  </uix:nodeStamp>

                  <uix:columnHeaderStamp>
		    <uix:text textBinding="headerName"/>
                  </uix:columnHeaderStamp>

	  	<uix:styledText textBinding="tableName"/>
		<uix:formValue name="displayedItem" valueBinding="uniqueID"/>
		</uix:hGrid>
                </uix:cellFormat>
              </uix:rowLayout>

            </uix:tableLayout>
      </uix:contents>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton formName="foo" textBinding="OK_BTN@recoveryBundle@servletRequest" name="event" value="okFromShowDepend" shortDescBinding="OK_BTN@recoveryBundle@servletRequest"/>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>

    </db:form>	
    </uix:body>
  </uix:document>
</uix:renderingContext>
