<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="RECOVERY_WIZARD@recoveryBundle@servletRequest"/>
      <db:script src="/database/utils.js"/> <%-- lovField support --%>
    </uix:metaContainer>

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/flashback" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>
	<uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="SHOW_ROW_CHANGES_PG@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>
	<uix:location>
            <uix:train selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
              <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
                <uix:link textBinding="." disabled="true"/>
              </uix:contents>
            </uix:train>
	</uix:location>
        <uix:messages>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        </uix:messages>
        <uix:spacer height="10"/>

          <uix:contents>
	    <uix:tableLayout cellSpacing="5" summary="tl">
	      <uix:rowLayout>
		<uix:cellFormat hAlign="right" headers="">
		  <uix:messagePrompt labeledNodeId="tableLabel" promptBinding="TABLE_LABEL@recoveryBundle@servletRequest"/>
		</uix:cellFormat>
		<uix:cellFormat hAlign = "left" headers="">
		  <oem:choice name="analyzeTableName" id="tableLabel"
		              optionsBinding="flashbackTableNames@defaultBean@pageContext"
		              selectedValueBinding="analyzeTableName@defaultBean@pageContext"
			      onChange="submitForm('foo', true, {'event':'changeAnalyzeTab'})" />
		</uix:cellFormat>
	      </uix:rowLayout>
	    </uix:tableLayout>
            <uix:styledText styleClass="OraInstructionText" textBinding="SHOW_ROW_CHANGES_DESC@recoveryBundle@servletRequest"/>
	    <uix:tableLayout summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
		<oem:table width = "100%" name="rowChangesUIDataSource"
		    blockSize="10"
                    dataSourceProp="rowChangesUIDataSource"
                    beanKey="rowChangesDataSourceBean"
		    alternateTextBinding="NO_ROWS_FOUND@recoveryBundle@servletRequest"
		    copyParams="target,type"
        summaryBinding="SHOW_ROW_CHANGES_PG@recoveryBundle@servletRequest">
                </oem:table>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
      </uix:contents>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton formName="foo" textBinding="OK_BTN@recoveryBundle@servletRequest" name="event" value="ok" shortDescBinding="OK_BTN@recoveryBundle@servletRequest"/>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>

    </db:form>
    </uix:body>

  </uix:document>
</uix:renderingContext>
