<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="RECOVERY_WIZARD@recoveryBundle@servletRequest"/>
      <uix:styleSheet/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/flashback" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>
	<uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="TXN_INFO_TITLE@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>

	<uix:location>
            <uix:train selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
              <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
                <uix:link textBinding="." disabled="true"/>
              </uix:contents>
            </uix:train>
	</uix:location>
        <uix:messages>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        </uix:messages>

          <uix:contents>
	    <uix:labeledFieldLayout labelWidth="25%">
		<uix:messagePrompt promptBinding="TXN_ID_LABEL@recoveryBundle@servletRequest"/>
		<uix:styledText styleClass="OraDataText" textBinding="selectedTxnID@defaultBean@servletRequest"/>		
		<uix:messagePrompt promptBinding="USER_LABEL@recoveryBundle@servletRequest"/>
		<uix:styledText styleClass="OraDataText" textBinding="selectedTxnUser@defaultBean@servletRequest"/>		
		<uix:messagePrompt promptBinding="COMMIT_SCN_LABEL@recoveryBundle@servletRequest"/>
		<uix:styledText styleClass="OraDataText" textBinding="selectedTxnCommitSCN@defaultBean@servletRequest"/>		
		<uix:messagePrompt promptBinding="COMMIT_TIME_LABEL@recoveryBundle@servletRequest"/>
		<uix:styledText styleClass="OraDataText" textBinding="selectedTxnCommitTime@defaultBean@servletRequest"/>		
	    </uix:labeledFieldLayout>

            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
		<oem:table width = "100%" name="txnInfoUIDataSource"
		    blockSize="10" 
                    dataSourceProp="txnInfoUIDataSource"
                    beanKey="txnInfoDataSourceBean"
                    formSubmitted="false"
		    alternateTextBinding="NO_ROWS_FOUND@recoveryBundle@servletRequest"
		    copyParams="target,type"
        summaryBinding="TXN_INFO_TITLE@recoveryBundle@servletRequest">
		</oem:table>
                </uix:cellFormat>
              </uix:rowLayout>
	    <%-- uix:rowLayout>
	    <uix:cellFormat hAlign="right">
                <uix:submitButton formName="foo" textBinding="SAVE_UNDO_SQL_BTN@recoveryBundle@servletRequest" name="event" value="clickOnSaveUndoSQLBtn" shortDesc="image"/>
	    </uix:cellFormat>
 	    </uix:rowLayout --%>
	    </uix:tableLayout>

      </uix:contents>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton formName="foo" textBinding="OK_BTN@recoveryBundle@servletRequest" name="event" value="ok" shortDescBinding="OK_BTN@recoveryBundle@servletRequest"/>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>	
    </uix:body>
  </uix:document>
</uix:renderingContext>
