<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="RECOVERY_WIZARD@recoveryBundle@servletRequest"/>
      <db:script src="/database/LOV.js"/> <%-- lovField support --%>
      <uix:styleSheet/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="undropObjSelection" destination="/console/database/rec/flashback" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>
	<uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="RECOVERY_UNDROP_OBJ_SELECTION_PG@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>
	<%@ include file="/database/rec/trainMessages.jspf" %>
          <uix:contents>
            <uix:styledText styleClass="OraInstructionText"
                            textBinding="UNDROP_OBJ_SEL_INTRO@recoveryBundle@servletRequest" />
	    <uix:header textBinding="SEARCH_LABEL@recoveryBundle@servletRequest">
	    <uix:tableLayout cellSpacing="5" summary="tl">
	      <uix:rowLayout vAlign="bottom">
	      <uix:switcher childNameBinding="isDBA@defaultBean@servletRequest">
	        <uix:case name="true">
		<uix:stackLayout>
		  <uix:messagePrompt labeledNodeId="schemaLabel" promptBinding="SCHEMA_NAME_LABEL@recoveryBundle@servletRequest"/>
		  <uix:lovField name="tempSchemaName"
				textBinding="tempSchemaName@defaultBean@servletRequest"
				onClick="startLov('tempSchemaName','ListSchemaWithTable')" id="schemaLabel"
        searchDescBinding="SCHEMA_NAME_LABEL@recoveryBundle@servletRequest"/>
	        </uix:stackLayout>
   	        </uix:case>
              </uix:switcher>
	      <uix:stackLayout>
		  <uix:messagePrompt labeledNodeId="tableLabel" promptBinding="TABLE_LABEL@recoveryBundle@servletRequest"/>
		  <uix:textInput name="tempTableName" id="tableLabel"
				textBinding="tempTableName@defaultBean@servletRequest" />
	      </uix:stackLayout>
	      <uix:stackLayout>
		  <uix:submitButton textBinding="GO@recoveryBundle@servletRequest"
				  name="event" value="searchAvailableTables" shortDescBinding="GO@recoveryBundle@servletRequest"/>
	      </uix:stackLayout>
	      </uix:rowLayout>
	    </uix:tableLayout>
	    </uix:header>
	    <uix:header textBinding="RB_RESULT_LABEL@recoveryBundle@servletRequest">
            <uix:tableLayout cellSpacing="5" summary="tl">
	      <uix:rowLayout>
		<uix:stackLayout>
                <uix:hGrid id="recycleBin"
                           width="100%"
                           alternateTextBinding="NO_OBJ_FOUND@recoveryBundle@servletRequest"
                           destination="/em/console/database/rec/flashback"
                           formSubmitted="true"
                  			   columnFormatsBinding="columnFormats@recycleBinBean@servletRequest"
                           columnHeaderDataBinding="columnHeaderData@recycleBinBean@servletRequest"
                           treeDataBinding="treeData@recycleBinBean@servletRequest"
                  			   proxyBinding="proxy@servletRequest"
                           summaryBinding="UNDROP_TABLES@recoveryBundle@servletRequest">
                  <uix:nodeStamp>
                    <uix:column>
                      <uix:columnHeader>
		  	<uix:styledText textBinding="OBJ_NAME_COL@recoveryBundle@servletRequest"/>
                      </uix:columnHeader>
		  	<uix:styledText textBinding="originalName"/>
                    </uix:column>
                  </uix:nodeStamp>

                  <uix:columnHeaderStamp>
		    <uix:text textBinding="headerName"/>
                  </uix:columnHeaderStamp>

	  	  <uix:styledText textBinding="owner"/>
		  <uix:styledText textBinding="objectType"/>
		  <uix:styledText textBinding="tablespace"/>
		  <uix:styledText textBinding="dropTime"/>
		  <uix:styledText textBinding="createTime"/>
		  <uix:styledText textBinding="size"/>
		  <uix:submitButton textBinding="VIEW_CONTENT_BTN@recoveryBundle@servletRequest"
		  name="event" valueBinding="viewContentEvent" disabledBinding="buttonDisabled" shortDescBinding="VIEW_CONTENT_BTN@recoveryBundle@servletRequest"/>

		  <uix:formValue name="displayedItem" valueBinding="uniqueID"/>

		  <uix:tableSelection>
		    <uix:multipleSelection disabledBinding="selectionDisabled"
			  		   selectedBinding="selected">
		    </uix:multipleSelection>
		  </uix:tableSelection>
                </uix:hGrid>
		<uix:messageText messageType="error" messageBinding="(UNDROP_OBJ_SELECTION_PG@recoveryBundle@servletRequest)@errors@servletRequest"/>
		</uix:stackLayout>
	      </uix:rowLayout>
            </uix:tableLayout>
	    </uix:header>
      </uix:contents>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <%-- uix:submitButton formName="undropObjSelection" textBinding="BACK_TO_OBJECT@recoveryBundle@servletRequest" name="event" value="restart"/ --%>
                <uix:submitButton textBinding="CANCEL@recoveryBundle@servletRequest" formName="undropObjSelection" name="event" value="cancel" shortDescBinding="CANCEL@recoveryBundle@servletRequest"/>
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="undropObjSelection"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>
      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
