<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="RECOVERY_WIZARD@recoveryBundle@servletRequest"/>
      <uix:styleSheet/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/flashback" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>
	<uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>
      <uix:pageLayout titleBinding="RECOVERY_UNDROP_RENAME_PG@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>
	<%@ include file="/database/rec/trainMessages.jspf" %>
          <uix:contents>
            <uix:tableLayout cellSpacing="5" summary="tl"> 
	      <uix:rowLayout>
                <uix:styledText styleClass="OraInstructionText" textBinding="UNDROP_RENAME_INTRO@recoveryBundle@servletRequest"/>
	      </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
		<oem:table width = "100%" name="undropRenameUIDataSource"
		    blockSize="10"
                    dataSourceProp="undropRenameUIDataSource"
                    beanKey="undropRenameDataSourceBean"
                    formSubmitted="true"
		    copyParams="target,type"
        summaryBinding="UNDROP_TABLES@recoveryBundle@servletRequest">
                </oem:table>
                </uix:cellFormat>
              </uix:rowLayout>

            </uix:tableLayout>
      </uix:contents>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <%-- uix:submitButton formName="foo" textBinding="BACK_TO_OBJECT@recoveryBundle@servletRequest" name="event" value="restart"/ --%>
                <uix:submitButton textBinding="CANCEL@recoveryBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@recoveryBundle@servletRequest"/>
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>

    </db:form>	
    </uix:body>
  </uix:document>
</uix:renderingContext>
