<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="recoveryBundle" class="oracle.sysman.db.rsc.rec.RecoveryMsg"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="pageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/ftx" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>
	<uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="FTX_HDR_DEPENDENCIES_DETAILS@recoveryBundle">
        <%@ include file="/database/global.jspf" %>

	<uix:location>
            <uix:train selectedIndexBinding="selectedIndex@defaultBean@servletRequest">
              <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
                <uix:link textBinding="." disabled="true"/>
              </uix:contents>
            </uix:train>
	</uix:location>
        <uix:messages>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        </uix:messages>
       
        <uix:contents>
        
	    <uix:labeledFieldLayout labelWidth="25%">
            <uix:messagePrompt promptBinding="FTX_XID@recoveryBundle"/>
            <uix:styledText styleClass="OraDataText" textBinding="xid@dTxDetailsBean@servletRequest"/>		
            <uix:messagePrompt promptBinding="FTX_DEPEND_TX_COUNT@recoveryBundle"/>
            <uix:styledText styleClass="OraDataText" textBinding="dependTxCount@dTxDetailsBean@servletRequest"/>		    
<%--
        </uix:labeledFieldLayout>
        
        <uix:header textBinding="FTX_CHARACTERISTICS@recoveryBundle">
        
	    <uix:labeledFieldLayout labelWidth="25%">
            <uix:messagePrompt promptBinding="FTX_DISTRIBUTED_TX_BRANCH@recoveryBundle"/>
            <uix:styledText styleClass="OraDataText" textBinding="dtBranch@dTxDetailsBean@servletRequest"/>		

            <uix:messagePrompt promptBinding="FTX_PDML_PARENT@recoveryBundle"/>
            <uix:styledText styleClass="OraDataText" textBinding="pdmlParent@dTxDetailsBean@servletRequest"/>		

            <uix:messagePrompt promptBinding="FTX_PDML_CHILD@recoveryBundle"/>
            <uix:styledText styleClass="OraDataText" textBinding="pdmlChild@dTxDetailsBean@servletRequest"/>		
            <uix:messagePrompt promptBinding="FTX_UPDATE_AQ_TABLE@recoveryBundle"/>
            <uix:styledText styleClass="OraDataText" textBinding="updatedAqTables@dTxDetailsBean@servletRequest"/>		
--%>
            <uix:messagePrompt promptBinding="FTX_TRANSACTION_PROPERTY@recoveryBundle"/>
            <uix:styledText styleClass="OraDataText" textBinding="compensating@dTxDetailsBean@servletRequest"/>		
	    </uix:labeledFieldLayout>

        
        <uix:spacer height="10"/>
        
        <uix:header textBinding="FTX_UNDO_SQL@recoveryBundle">
        
        <uix:tableLayout cellSpacing="5" summary="tl">
          <uix:rowLayout>
          <%--
          <uix:stackLayout>
            <db:sqlDisplay  sqlListBinding="undoSqls@defaultBean@servletRequest"/>
          </uix:stackLayout>
--%>
          <uix:cellFormat hAlign="left" width="150" headers="">
          <uix:messageTextInput name="undoSqlStr"
               shortDescBinding="FTX_UNDO_SQL@recoveryBundle"
               textBinding="undoSqlStr@servletRequest" 
               columns="100" rows="10" wrap="hard" readOnly="true"/>
          </uix:cellFormat>
          <%--
          <uix:cellFormat hAlign="left">
		  <oem:table width = "100%" 
                    name="tableUI"
                    blockSize="10" 
                    dataSourceProp="tableUI"
                    beanKey="undoSQLTableData"
                    formSubmitted="false"
                    alternateTextBinding="NO_ROWS_FOUND@recoveryBundle"
                    copyParams="target,type"
                    summaryBinding="TXN_INFO_TITLE@recoveryBundle">
		  </oem:table>
          </uix:cellFormat>
          --%>
          </uix:rowLayout>
	    </uix:tableLayout>

          <uix:tip>
            <uix:text textBinding="FTX_TIP_DEPEND_TX_DETAILS@recoveryBundle"/>
          </uix:tip>
      
        </uix:header>
        
      </uix:contents>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton formName="foo" textBinding="OK_BTN@recoveryBundle" name="event" value="ok" shortDescBinding="OK_BTN@recoveryBundle"/>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>	
    </uix:body>
  </uix:document>
</uix:renderingContext>
