<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="recoveryBundle" class="oracle.sysman.db.rsc.rec.RecoveryMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="pageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
      <db:form name="foo" destination="/console/database/rec/ftx" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>
	    <uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

        <uix:pageLayout titleBinding="FTX_HDR_DEPENDENCIES@recoveryBundle">
        <%@ include file="/database/global.jspf" %>
	    <%@ include file="/database/rec/trainMessages.jspf" %>
    
        <uix:contents>

        <uix:styledText styleClass="OraInstructionText" textBinding="dependInst@defaultBean@servletRequest" />
        
<%--	    <uix:header textBinding="FTX_TRANSACTION_DEPENDENCIES@recoveryBundle"> --%>
            
             <uix:tableLayout cellSpacing="10" width="85%" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" headers="">
                  <uix:contents>
                    <uix:submitButton textBinding="FTX_BUTTON_CHANGE@recoveryBundle" name="event" value="change" formName="foo"  shortDescBinding="FTX_BUTTON_CHANGE@recoveryBundle"/>
                  </uix:contents>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
                       
          <uix:tableLayout cellSpacing="10" width="85%" summary="tl">
            <uix:rowLayout>
            <uix:hGrid id="dependTableData"
                       width="100%"
                       alternateTextBinding="NO_OBJ_FOUND@recoveryBundle"
                       destination="/em/console/database/rec/ftx"
                       formSubmitted="true"
                       columnFormatsBinding="columnFormats@dependTableData@servletRequest"
                       columnHeaderDataBinding="columnHeaderData@dependTableData@servletRequest"
                       treeDataBinding="treeData@dependTableData@servletRequest"
                       proxyBinding="proxy@servletRequest"
                       summaryBinding="TABLE_DEPEND_COL@recoveryBundle">
                      
                  <uix:nodeStamp>
                      <uix:column>
                          <uix:columnHeader>
                              <uix:styledText textBinding="TXN_ID_COL@recoveryBundle"/>
                          </uix:columnHeader>
                          <uix:styledText textBinding="xid" destinationBinding="xidLink"/>
                      </uix:column>
                  </uix:nodeStamp>
        
                  <uix:columnHeaderStamp>
                      <uix:text textBinding="headerName"/>
                  </uix:columnHeaderStamp>

<%--        
                  <uix:styledText textBinding="conflict"/>
                  <uix:styledText textBinding="dtbranch"/>
                  <uix:styledText textBinding="pdparent"/>
                  <uix:styledText textBinding="pdchild"/>
                  <uix:styledText textBinding="aqtable"/>
--%>                  
                  <uix:styledText textBinding="comptx"/>
<%-- remove select column 
                <uix:tableSelection>
                  <uix:singleSelection disabled="true"
                                       shortDescBinding="SELECT@uixDBObjectBundle@servletRequest" 
                                       selectedIndex="0"/>
                </uix:tableSelection>
--%>
            </uix:hGrid>
            </uix:rowLayout>
          </uix:tableLayout>

          <uix:tip>
            <uix:text textBinding="FTX_TIP_DEPENDENCIES@recoveryBundle"/>
          </uix:tip>
          
<%--        </uix:header> --%>
        
        </uix:contents>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@recoveryBundle" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@recoveryBundle"/>
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
