<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext">
  <uix:bundle name="recBundle" class="oracle.sysman.db.rsc.rec.RecoveryMsg"/>
  <oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/ftx" method="post" copyParams="target,type">

      <uix:pageLayout>
      <%@ include file="/database/global.jspf" %> 
      <%--
      <%@ include file="/database/rec/trainMessages.jspf" %>
      --%>
      
      <uix:contents>
      <uix:tableLayout width="100%" summary="tl">
        <uix:rowLayout>
        <oem:messageBox messageType="error"
                        titleTextKey="titleText" 
                        mainTextKey="mainText"
                        errorTableBinding="msgBox@servletRequest"
                        destTableBinding="msgUrls@servletRequest">
        </oem:messageBox>
        </uix:rowLayout>
      </uix:tableLayout>
      </uix:contents>
     
      <uix:spacer height="10"/>
      
      <uix:header textBinding="FTX_ERROR_DETAILS@recBundle">
      <uix:stackLayout>
          <uix:styledText styleClass="OraInstructionText" textBinding="instruction@servletRequest" />
          <uix:messageTextInput name="errorMsg" 
                         shortDescBinding="FTX_ERROR_DETAILS@recBundle" 
                         textBinding="details@servletRequest" 
                         readOnly="true" 
                         columns="120" 
                         rows="15"/>
      </uix:stackLayout>
      </uix:header>

      <uix:pageButtons>
	    <uix:pageButtonBar>
          <uix:contents>
              <uix:button textBinding="OK@recBundle" 
                          destinationBinding="okUrl@servletRequest" shortDescBinding="OK@recBundle"/>
    	    </uix:contents>
      </uix:pageButtonBar>
      </uix:pageButtons>

      </uix:pageLayout>

    </db:form>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
