<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ page import="oracle.cabo.ui.partial.PartialPageUtils"%>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); 
%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="recoveryBundle" class="oracle.sysman.db.rsc.rec.RecoveryMsg"/>
  <uix:bundle name="LogMinerBundle" class="oracle.sysman.db.rsc.lm.LogMinerMsg"/>
 <%
  String dest = (String)request.getSession().getAttribute("processingDoneDestination");
  if (dest != null)  {
    PartialPageUtils.forceRedirectURL(renderingContext, dest);
    request.getSession().removeAttribute("processingDoneDestination");
  }
  %>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <db:script src="/database/LOV.js"/> 
    <script>
      function popWindow() 
      {
          window.open('http://download-west.oracle.com/docs/cd/B19306_01/server.102/b14237/dynviews_1154.htm', 'LogMiner', 'width=700, height=500, resizeable=yes, scrollbars=yes', true )
      }    
      function lovCallBack(data)
      {
        destField = callBackLovField();
        if(data.indexOf('"')!=-1 || data.charCodeAt(0)>96)
        {
          document.forms[0].selectTableName.value=data;
          return;
        }
        var schema = checkForSpecialChars(data.substring(0,data.indexOf('.')));
        var table = checkForSpecialChars(data.substring(data.indexOf('.')+1,data.length));
        document.forms[0].selectTableName.value=schema+"."+table;
      }     
      function checkForSpecialChars(object)
      {
        var tableObj = "";
        if(object!=null)
        {
          for(var i=0;i<object.length;i++)
          {
            var specialChar=object.charCodeAt(i);
            if( specialChar==33 )
            {
              tableObj = '"'+object.substring(0,object.length)+'"';
              break;
            }
            else if( specialChar>36 && specialChar<46 )
            {
              tableObj = '"'+object.substring(0,object.length)+'"';
              break;
            }
            else if( specialChar>57 && specialChar<65 )
            {
              tableObj = '"'+object.substring(0,object.length)+'"';
              break;
            }
            else if( specialChar>90 && specialChar<95 )
            {
              tableObj = '"'+object.substring(0,object.length)+'"';
              break;
            }
            else if( specialChar==96 || specialChar==47 )
            {
              tableObj = '"'+object.substring(0,object.length)+'"';
              break;
            }
            else if( specialChar>122 && specialChar<256 )
            {
              tableObj = '"'+object.substring(0,object.length)+'"';
              break;
            }
            else
            {
              tableObj = object;
            }
          }
        } 
        return tableObj;
      }    
  </script>

    <uix:metaContainer>
      <uix:head titleBinding="pageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="queryForm" destination="/console/database/rec/ftx" copyParams="target,type" method="post">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>
	<uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

    <uix:pageLayout titleBinding="FTX_HDR_PERFORM_QUERY@recoveryBundle">
      <%@ include file="/enablePPR.jspf" %>
      <%@ include file="/database/global.jspf" %>
	  <%@ include file="/database/rec/trainMessages.jspf" %>

    <uix:contents>

    <uix:switcher childNameBinding="useLogminer@defaultBean@servletRequest" defaultCase="false">
    <uix:case name="true">
      <uix:stackLayout>
        <uix:styledText styleClass="OraInstructionText" textBinding="queryInst@defaultBean@servletRequest" />
        <%@ include file="lmquery.jspf" %>
      </uix:stackLayout>
    </uix:case>
    <uix:case name="false">
         <%@ include file="ftxquery.jspf" %>
    </uix:case>
    </uix:switcher>
    
    </uix:contents>


<%-- page buttons --%>
          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@recoveryBundle" formName="queryForm" name="event" value="cancel" shortDescBinding="CANCEL@recoveryBundle"/>
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="queryForm"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
