<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="recoveryBundle" class="oracle.sysman.db.rsc.rec.RecoveryMsg"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="pageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/ftx" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>
	<uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="FTX_HDR_REC_OPTION@recoveryBundle">
        <%@ include file="/database/global.jspf" %>

	<uix:location>
            <uix:train selectedIndex="2">
              <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
                <uix:link textBinding="." disabled="true"/>
              </uix:contents>
            </uix:train>
	</uix:location>
        <uix:messages>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        </uix:messages>
       
        <uix:stackLayout>
        <uix:contents>
        
<%--        <uix:styledText styleClass="OraInstructionText" textBinding="FTX_INST_CHANGE_OPTION@recoveryBundle" /> --%>
        

	      <uix:tableLayout cellSpacing="10" width="100%" borderWidth="0" summary="tl">
              
	        <uix:rowLayout>
                    <uix:messageRadioButton name="recoveryOption" 
                                            value="nonconflict"
			                    selectedValueBinding="recoveryOption@defaultBean@pageContext"
			                    textBinding="FTX_NON_CONFLICT_ONLY@recoveryBundle"
			                    shortDescBinding="FTX_NON_CONFLICT_ONLY@recoveryBundle"
                                            tipBinding="FTX_TIP_OPTION_NONCONFLICT@recoveryBundle"
			                    styleClass="OraInstructionText" />                                            		                
	        </uix:rowLayout>
                <uix:rowLayout>
		    <uix:messageRadioButton name="recoveryOption" 
                                            value="nocascadeforce"
			                    selectedValueBinding="recoveryOption@defaultBean@pageContext"
			                    textBinding="FTX_NOCASCADE_FORCE@recoveryBundle"
			                    shortDescBinding="FTX_NOCASCADE_FORCE@recoveryBundle"
                                            tipBinding="FTX_TIP_OPTION_NOCASCADEFORCE@recoveryBundle"
			                    styleClass="OraInstructionText" />
	        </uix:rowLayout>
                <uix:rowLayout>
		    <uix:messageRadioButton name="recoveryOption" 
                                            value="cascade"
			                    selectedValueBinding="recoveryOption@defaultBean@pageContext"
			                    textBinding="FTX_CASCADE@recoveryBundle"
			                    shortDescBinding="FTX_CASCADE@recoveryBundle"
                                            tipBinding="FTX_TIP_OPTION_CASCADE@recoveryBundle"
			                    styleClass="OraInstructionText" />
	        </uix:rowLayout>
          </uix:tableLayout>


        
      </uix:contents>
      </uix:stackLayout>
      
          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton formName="foo" textBinding="OK_BTN@recoveryBundle" name="event" value="applyChange" shortDescBinding="OK_BTN@recoveryBundle"/>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>	
    </uix:body>
  </uix:document>
</uix:renderingContext>
