<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="recoveryBundle" class="oracle.sysman.db.rsc.rec.RecoveryMsg"/>
  <uix:bundle name="LogMinerBundle" class="oracle.sysman.db.rsc.lm.LogMinerMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:metaContainer>
      <uix:head titleBinding="pageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/ftx" copyParams="target,type">
      <uix:formValue name="source"/>
      <uix:formValue name="value"/>
	  <uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="FTX_HDR_REVIEW@recoveryBundle">
        <%@ include file="/database/global.jspf" %>
	    <%@ include file="/database/rec/trainMessages.jspf" %>

	    <uix:contents>
          <%--
          <uix:styledText styleClass="OraInstructionText" textBinding="FTX_INST_REVIEW@recoveryBundle@servletRequest" />
          --%>
	      <uix:header textBinding="FTX_TRANSACTION_INFO@recoveryBundle">
            <uix:stackLayout>

    <uix:switcher childNameBinding="useLogminer@defaultBean@servletRequest" defaultCase="false">
    <uix:case name="false">

            <uix:labeledFieldLayout labelWidth="25%">
                <uix:messagePrompt promptBinding="FTX_XID@recoveryBundle"/>
                <uix:styledText styleClass="OraDataText" textBinding="xid@defaultBean@servletRequest"/>		
                <uix:messagePrompt promptBinding="USER_LABEL@recoveryBundle"/>
                <uix:styledText styleClass="OraDataText" textBinding="user@txDetails@defaultBean@servletRequest"/>		
                <uix:messagePrompt promptBinding="COMMIT_SCN_LABEL@recoveryBundle"/>
                <uix:styledText styleClass="OraDataText" textBinding="commitScn@txDetails@defaultBean@servletRequest"/>		
                <uix:messagePrompt promptBinding="COMMIT_TIME_LABEL@recoveryBundle"/>
                <uix:styledText styleClass="OraDataText" textBinding="commitTime@txDetails@defaultBean@servletRequest"/>		
                <uix:messagePrompt promptBinding="FTX_RECOVERY_OPTIONS@recoveryBundle"/>
                <uix:styledText styleClass="OraDataText" textBinding="nlsRecoveryOption@defaultBean@servletRequest"/>
            </uix:labeledFieldLayout>
    </uix:case>
    <uix:case name="true">   
    
            <uix:labeledFieldLayout labelWidth="25%">
                <uix:messagePrompt promptBinding="TRANSACTION_ID@LogMinerBundle"/>
                <uix:styledText styleClass="OraDataText" textBinding="XIDStr@selectedTxDetails@defaultBean@servletRequest"/>		
                <uix:messagePrompt promptBinding="START_SCN@LogMinerBundle"/>
                <uix:styledText styleClass="OraDataText" textBinding="startSCN@selectedTxDetails@defaultBean@servletRequest"/>		
                <uix:messagePrompt promptBinding="START_TIME@LogMinerBundle"/>
                <uix:styledText styleClass="OraDataText" textBinding="selectedTxnStartTime@defaultBean@servletRequest"/>		
                <uix:messagePrompt promptBinding="USER@LogMinerBundle"/>
                <uix:styledText styleClass="OraDataText" textBinding="user@selectedTxDetails@defaultBean@servletRequest"/>		
                <uix:messagePrompt promptBinding="COMMIT_SCN@LogMinerBundle"/>
                <uix:styledText styleClass="OraDataText" textBinding="commitSCN@selectedTxDetails@defaultBean@servletRequest"/>		
                <uix:messagePrompt promptBinding="COMMIT_TIME@LogMinerBundle"/>
                <uix:styledText styleClass="OraDataText" textBinding="selectedTxnCommitTime@defaultBean@servletRequest"/>		
                <uix:messagePrompt promptBinding="OS_USER@LogMinerBundle"/>
                <uix:styledText styleClass="OraDataText" textBinding="sessionOSUser@selectedTxDetails@defaultBean@servletRequest"/>		
                <uix:messagePrompt promptBinding="MACHINE_NAME@LogMinerBundle"/>
                <uix:styledText styleClass="OraDataText" textBinding="sessionMachineName@selectedTxDetails@defaultBean@servletRequest"/>		
                <uix:messagePrompt promptBinding="FTX_RECOVERY_OPTIONS@recoveryBundle"/>
                <uix:styledText styleClass="OraDataText" textBinding="nlsRecoveryOption@defaultBean@servletRequest"/>
            </uix:labeledFieldLayout>

    </uix:case>
    </uix:switcher>

            </uix:stackLayout>
          </uix:header>
          
	      <uix:header textBinding="FTX_EXECUTE_SQL@recoveryBundle">
            <uix:tableLayout cellSpacing="5" summary="tl">

              <uix:rowLayout>
                <uix:stackLayout>
                  <uix:messageTextInput name="executeSql" rows="5" columns="88"
                                        id="exec_tag_id"
                                        textBinding="executeSql@defaultBean@servletRequest"
                                        shortDescBinding="executeSql@defaultBean@servletRequest"
                                        tipBinding="FTX_INST_EXECUTE_SQL@recoveryBundle"/>
                  <uix:messageText messageType="error" messageBinding="(FTX_EXECUTE_SQL@recoveryBundle)@errors@servletRequest"/>
                </uix:stackLayout>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:submitButton textBinding="FTX_EXECUTE_SQL@recoveryBundle" formName="foo" name="event" value="executeSQL" shortDescBinding="FTX_EXECUTE_SQL@recoveryBundle"/>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>

          <uix:spacer height="10"/>
          <%--
          <uix:tip>
            <uix:text textBinding="FTX_FINISH_TIP@recoveryBundle"/>
          </uix:tip>
          --%>
        </uix:contents>

        <uix:pageButtons>
          <uix:pageButtonBar>
            <uix:submitButton textBinding="FTX_SHOW_UNDO_SQL_SCRIPT@recoveryBundle" formName="foo" name="event" value="showUndoSQL" shortDescBinding="FTX_SHOW_UNDO_SQL_SCRIPT@recoveryBundle"/>
            <uix:submitButton textBinding="CANCEL@recoveryBundle" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@recoveryBundle"/>
            <uix:contents>
              <uix:navigationBar
                name="tableNav"
                blockSize="-1"
                formSubmitted="true"
                formName="foo"
                maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                minValue="1"
                valueBinding="pageSequence@defaultBean@servletRequest"/>
            </uix:contents>
            <uix:submitButton textBinding="FINISH@recoveryBundle" formName="foo" name="event" value="finish" shortDescBinding="FINISH@recoveryBundle"/>
          </uix:pageButtonBar>
        </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
