<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<%@ page import="oracle.cabo.ui.partial.PartialPageUtils"%>
<% oracle.cabo.share.util.CaboHttpUtils.setNoCacheHeaders(response); %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
<%
  String dest = (String)request.getSession().getAttribute("processingDoneDestination");
  if (dest != null)
  {
    PartialPageUtils.forceRedirectURL(renderingContext, dest);
    request.getSession().removeAttribute("processingDoneDestination");
  }
  %>
  <uix:bundle name="recoveryBundle" class="oracle.sysman.db.rsc.rec.RecoveryMsg"/>
  <uix:bundle name="LogMinerBundle" class="oracle.sysman.db.rsc.lm.LogMinerMsg"/>
  <uix:bundle name="DBMsgBundle" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:metaContainer>
      <uix:head titleBinding="pageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/ftx" copyParams="target,type" method="get">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>
	<uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="FTX_HDR_SELECT_TX@recoveryBundle">
        <%@ include file="/database/global.jspf" %>
	<%@ include file="/database/rec/trainMessages.jspf" %>
    
	<uix:contents>
        <uix:styledText styleClass="OraInstructionText" textBinding="FTX_INST_SELECT_TX@recoveryBundle" />

	<uix:header textBinding="FTX_QUERY_RESULT@recoveryBundle">
    

    <uix:switcher childNameBinding="useLogminer@defaultBean@servletRequest" defaultCase="false">
    <uix:case name="false">
        <uix:stackLayout>
        <uix:tableLayout cellSpacing="5" width="100%" summary="tl">
          <uix:rowLayout>
		 <oem:table name="tableUI" id="tableUI" width = "100%" blockSize="25"
                    beanKey="txTableBean" dataSourceProp="tableUI"
                    copyParams="target,type" formSubmitted="true"
		            alternateTextBinding="NO_ROWS_FOUND@recoveryBundle"
                    summaryBinding="RECOVERY_CHOOSE_PG@recoveryBundle">
		  <uix:tableSelection>
		    <oem:singleSelection shortDescBinding="SELECT@DBMsgBundle"
                                 selectedIndexBinding="selectedIndex@txTableBean@servletRequest">
                    </oem:singleSelection>
          </uix:tableSelection>
		 </oem:table>

		 <uix:messageText messageType="error" messageBinding="(ROW_VERSIONS_RESULT@recoveryBundle)@errors@servletRequest"/>
         </uix:rowLayout>
       </uix:tableLayout>
                
<%--          <uix:tip><uix:text textBinding="FTX_TIP_VIEW_UNDOSQL@recoveryBundle"/></uix:tip> --%>
          
        </uix:stackLayout>
    </uix:case>
    <uix:case name="true">       
        <uix:stackLayout>
        <uix:tableLayout cellSpacing="5" width="100%" summary="tl">
          <uix:rowLayout>
              <uix:cellFormat hAlign="left" headers="">        
                    <uix:checkBox name="showAllTxn" 
                          textBinding="FTX_CHECKBOX_SHOW_ALL_TXN@recoveryBundle"
                          checkedBinding="showAllTxnOn@defaultBean@servletRequest" />
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="right" headers="">
                    <uix:submitButton textBinding="FTX_BUTTON_REFRESH@recoveryBundle" name="event" value="refreshTx" formName="foo" shortDescBinding="FTX_BUTTON_REFRESH@recoveryBundle" />
                </uix:cellFormat>
         </uix:rowLayout>
         <uix:rowLayout>
           <uix:cellFormat columnSpan="2" headers="">
            <oem:table name="logMinerTxnUI" width="100%" 
                       beanKey="logMinerTxnDataSourceBean" blockSize="50" formSubmitted="true"
                       dataSourceProp="logMinerTxnUI" 
                       copyParams="target,type"
                       destination="/console/database/lm/logminer" alternateTextBinding="NO_TRANSACTIONS@LogMinerBundle" >
            <uix:tableSelection> 
             <uix:singleSelection shortDescBinding="SELECT@DBMsgBundle@servletRequest" selectedIndexBinding="selectedIndex@logMinerTxnDataSource@defaultBean@servletRequest">
             </uix:singleSelection>
            </uix:tableSelection>
           </oem:table>
           </uix:cellFormat>
         </uix:rowLayout>
       </uix:tableLayout>
          
             <uix:tip> 
               <uix:styledText textBinding="SUMMARY_TIP@LogMinerBundle"/>
             </uix:tip>  
        </uix:stackLayout>
    </uix:case>
    </uix:switcher>
    
      </uix:header>     
      </uix:contents>

          <uix:pageButtons>
              <uix:pageButtonBar>

         <uix:switcher childNameBinding="needsMoreMining@defaultBean@servletRequest" defaultCase="false">
          <uix:case name="true">
            <uix:submitButton  textBinding="CONTINUE_MINING@LogMinerBundle" name="event" value="continueMining"  shortDescBinding="CONTINUE_MINING@LogMinerBundle" />
           </uix:case>
          </uix:switcher>
              
                <uix:submitButton textBinding="CANCEL@recoveryBundle" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@recoveryBundle" />
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
