<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="recoveryBundle" class="oracle.sysman.db.rsc.rec.RecoveryMsg"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="pageTitle@defaultBean@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="foo" destination="/console/database/rec/ftx" copyParams="target,type" method="post">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>
	<uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="FTX_HDR_SELECT_TX_DETAILS@recoveryBundle">
        <%@ include file="/database/global.jspf" %>

	<uix:location>
            <uix:train selectedIndex="1">
              <uix:contents childDataBinding="trainLinks@defaultBean@servletRequest">
                <uix:link textBinding="." disabled="true"/>
              </uix:contents>
            </uix:train>
	</uix:location>
        <uix:messages>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        </uix:messages>

    <uix:contents>
    <uix:switcher childNameBinding="useLogminer@defaultBean@servletRequest" defaultCase="false">
    <uix:case name="false">
    <uix:stackLayout>        
	    <uix:labeledFieldLayout labelWidth="25%">
            <uix:messagePrompt promptBinding="FTX_XID@recoveryBundle"/>
            <uix:styledText styleClass="OraDataText" textBinding="xid@txDetails@defaultBean@servletRequest"/>
            <%--
            <uix:messagePrompt promptBinding="FTX_DATABASE_NAME@recoveryBundle"/>
            <uix:styledText styleClass="OraDataText" textBinding="dbName@defaultBean@servletRequest"/>	
            --%>
            <uix:messagePrompt promptBinding="USER_LABEL@recoveryBundle"/>
            <uix:styledText styleClass="OraDataText" textBinding="user@txDetails@defaultBean@servletRequest"/>		
            <uix:messagePrompt promptBinding="START_SCN_LABEL@recoveryBundle"/>
            <uix:styledText styleClass="OraDataText" textBinding="startScn@txDetails@defaultBean@servletRequest"/>		
            <uix:messagePrompt promptBinding="COMMIT_SCN_LABEL@recoveryBundle"/>
            <uix:styledText styleClass="OraDataText" textBinding="commitScn@txDetails@defaultBean@servletRequest"/>		
            <uix:messagePrompt promptBinding="START_TIME_LABEL@recoveryBundle"/>
            <uix:styledText styleClass="OraDataText" textBinding="startTime@txDetails@defaultBean@servletRequest"/>		
            <uix:messagePrompt promptBinding="COMMIT_TIME_LABEL@recoveryBundle"/>
            <uix:styledText styleClass="OraDataText" textBinding="commitTime@txDetails@defaultBean@servletRequest"/>		
	    </uix:labeledFieldLayout>

            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
		 <oem:table width = "100%" 
                    name="txDetailsTableUI"
                    dataSourceProp="tableUI"
                    beanKey="txDetailsTableBean"
                    formSubmitted="false"
                    blockSize="25"
                    alternateTextBinding="NO_ROWS_FOUND@recoveryBundle"
                    copyParams="target,type"
                    summaryBinding="TXN_INFO_TITLE@recoveryBundle">
		</oem:table>
                </uix:cellFormat>
              </uix:rowLayout>
	    </uix:tableLayout>
    </uix:stackLayout>
    </uix:case>
    <uix:case name="true">   
     <uix:stackLayout>
<%--------- start logminer ------------------------%>
    <%@include file="lmdetails.jspf"%>
<%--------- end logminer --------------------------%>
     </uix:stackLayout>
    </uix:case>
    </uix:switcher>
    
    </uix:contents>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton formName="foo" textBinding="OK_BTN@recoveryBundle" name="event" value="ok" shortDescBinding="OK_BTN@recoveryBundle"/>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>	
    </uix:body>
  </uix:document>
</uix:renderingContext>
