<%@ include file="/sdk/oemTop.jspf" %>
<%-- Tag Libraries --%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="recoveryBundle" class="oracle.sysman.db.rsc.rec.RecoveryMsg"/>
<uix:document>
  
<%-- HTML Page Title --%>
<uix:metaContainer>
      <uix:head titleBinding="pageTitle@defaultBean@servletRequest"/>
</uix:metaContainer>

<uix:body>
<db:form name="foo" method="post" destinationBinding="okUrl@servletRequest">

<uix:pageLayout titleBinding="FTX_HDR_REVIEW_UNDOSQL@recoveryBundle">

<%@ include file="/database/global.jspf" %>
<%@ include file="/database/rec/trainMessages.jspf" %>

  <uix:contents>

      <uix:tableLayout cellSpacing="5" summary="tl">
        <uix:rowLayout>
          <uix:cellFormat hAlign="left" width="150" headers="">
          <uix:messageTextInput name="undoSqlStr"
               shortDescBinding="FTX_UNDO_SQL@recoveryBundle"
               textBinding="undoSqlStr@servletRequest" 
               columns="100" rows="15" wrap="hard" readOnly="true"/>
          </uix:cellFormat>
        </uix:rowLayout>
      </uix:tableLayout>

      <uix:tip>
        <uix:text textBinding="FTX_TIP_FINAL_UNDOSQL@recoveryBundle"/>
      </uix:tip>
 
  </uix:contents>

  <uix:pageButtons>
    <uix:pageButtonBar>
      <uix:submitButton name="ok" textBinding="OK_BTN@recoveryBundle" destinationBinding="okUrl@servletRequest" shortDescBinding="OK_BTN@recoveryBundle"/>
    </uix:pageButtonBar>
  </uix:pageButtons>

</uix:pageLayout>

</db:form>
</uix:body>
</uix:document>
</uix:renderingContext>
