<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
                                                                                
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="bkpMgmtBundle" class="oracle.sysman.db.rsc.rec.BkpMgmtMsg"/>
                                                                                
<uix:document>
  <%@ include file="/oemTitle.jspf" %>
                                                                                
  <uix:body>
    <db:form name="foo" method="POST" destination="/console/database/rec/grpBkp" copyParams="type,target">
      <uix:pageLayout titleBinding="VIEW_BACKUP_REPORT@bkpMgmtBundle">
       <%@ include file="/database/global.jspf" %>

<%--
          <oem:pageRefreshed  useRefreshButton="true"/>
--%>
          <uix:tableLayout width="100%" summary="tl">
            <uix:rowLayout hAlign="right">
              <uix:cellFormat headers="">
                <uix:rowLayout>
                  <oem:pageRefreshed/>
                  <uix:spacer width="5"/>
                  <uix:button textBinding="REFRESH@bkpMgmtBundle"
                    destinationBinding="refreshDest@servletRequest"  shortDescBinding="REFRESH@bkpMgmtBundle"/>
                </uix:rowLayout>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>

          <uix:spacer height="5"/>
          <uix:stackLayout>
            <uix:styledText styleClass="OraInstructionText"
                            textBinding="LATEST_BACKUP_INTRO@bkpMgmtBundle" />
          </uix:stackLayout>

          <uix:spacer height="5"/>
          <uix:header textBinding="SEARCH@bkpMgmtBundle">
            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" headers="">
                  <uix:styledText styleClass="OraPromptText" textBinding="DATABASE@bkpMgmtBundle"/>
                </uix:cellFormat>

                <uix:cellFormat hAlign="left" headers="">
                  <uix:textInput name="dbName"
                                 shortDescBinding="DATABASE@bkpMgmtBundle"
                                 textBinding="dbName@defaultBean@servletRequest"
                                 columns="40" />

                </uix:cellFormat>
                <uix:spacer width="10"/>
                <uix:cellFormat hAlign="right" headers="">
                  <uix:styledText styleClass="OraPromptText" textBinding="STATUS@bkpMgmtBundle"/>
                </uix:cellFormat>

                <uix:cellFormat hAlign="left" headers="">
                  <uix:choice name="filterStatus" 
                              shortDescBinding="STATUS@bkpMgmtBundle"
                              selectedValueBinding="filterStatus@defaultBean@servletRequest" >
                    <uix:option textBinding="OPT_ALL@bkpMgmtBundle" value="all"/>
                    <uix:option text="COMPLETED" value="COMPLETED"/>
                    <uix:option text="COMPLETED WITH ERRORS" value="COMPLETED WITH ERRORS"/>
                    <uix:option text="COMPLETED WITH WARNINGS" value="COMPLETED WITH WARNINGS"/>
                    <uix:option text="FAILED" value="FAILED"/>
                    <uix:option text="NOT BACKED UP" value="NOT BACKED UP"/>
                    <uix:option text="RUNNING" value="RUNNING"/>
                    <uix:option text="RUNNING WITH ERRORS" value="RUNNING WITH ERRORS"/>
                    <uix:option text="RUNNING WITH WARNINGS" value="RUNNING WITH WARNINGS"/>
                  </uix:choice>
                </uix:cellFormat>

                <uix:cellFormat headers="">
                  <uix:submitButton textBinding="GO@bkpMgmtBundle" name="event" value="filter" shortDescBinding="GO@bkpMgmtBundle"/>
                </uix:cellFormat>

              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>

        <uix:header textBinding="RESULT@bkpMgmtBundle">
          <uix:stackLayout>

            <uix:tableLayout renderedBinding="hasTotal@defaultBean@servletRequest" summary="tl">
              <uix:rowLayout hAlign="left">
              <uix:cellFormat renderedBinding="hasTotal@defaultBean@servletRequest" headers="">
                    <uix:styledText styleClass="OraPromptText" textBinding="TOTAL_N@bkpMgmtBundle"/>
                    <uix:spacer width="5"/>
                    <uix:styledText styleClass="OraDataText" textBinding="totalC@defaultBean@servletRequest"/>
                    <uix:spacer width="5"/>
                    <uix:styledText styleClass="OraDataText" text="("/>
                    <uix:spacer width="5"/>
              </uix:cellFormat>
              <uix:cellFormat renderedBinding="hasComp@defaultBean@servletRequest" headers="">
                    <uix:styledText styleClass="OraPromptText" textBinding="COMPLETED_N@bkpMgmtBundle"/>
                    <uix:spacer width="3"/>
                    <uix:image source="/em/images/okind_status.gif"/>
                    <uix:spacer width="3"/>
                    <uix:styledText styleClass="OraDataText" textBinding="compC@defaultBean@servletRequest"/>
                    <uix:spacer width="8"/>
              </uix:cellFormat>
              <uix:cellFormat renderedBinding="hasCompE@defaultBean@servletRequest" headers="">
                    <uix:styledText styleClass="OraPromptText" textBinding="COMPLETED_WITH_ERRORS@bkpMgmtBundle"/>
                    <uix:spacer width="3"/>
                    <uix:image source="/em/images/critical.gif"/>
                    <uix:spacer width="3"/>
                    <uix:styledText styleClass="OraDataText" textBinding="compEC@defaultBean@servletRequest"/>
                    <uix:spacer width="8"/>
              </uix:cellFormat>
              <uix:cellFormat renderedBinding="hasCompW@defaultBean@servletRequest" headers="">
                    <uix:styledText styleClass="OraPromptText" textBinding="COMPLETED_WITH_WARNINGS@bkpMgmtBundle"/>
                    <uix:spacer width="3"/>
                    <uix:image source="/em/images/warning.gif"/>
                    <uix:spacer width="3"/>
                    <uix:styledText styleClass="OraDataText" textBinding="compWC@defaultBean@servletRequest"/>
                    <uix:spacer width="8"/>
              </uix:cellFormat>
              <uix:cellFormat renderedBinding="hasFail@defaultBean@servletRequest" headers="">
                    <uix:styledText styleClass="OraPromptText" textBinding="FAILED@bkpMgmtBundle"/>
                    <uix:spacer width="3"/>
                    <uix:image source="/em/images/critical.gif"/>
                    <uix:spacer width="3"/>
                    <uix:styledText styleClass="OraDataText" textBinding="failC@defaultBean@servletRequest"/>
                    <uix:spacer width="8"/>
              </uix:cellFormat>
              <uix:cellFormat renderedBinding="hasNobkp@defaultBean@servletRequest" headers="">
                    <uix:styledText styleClass="OraPromptText" textBinding="NOT_BACKED_UP@bkpMgmtBundle"/>
                    <uix:spacer width="3"/>
                    <uix:image source="/em/images/critical.gif"/>
                    <uix:spacer width="3"/>
                    <uix:styledText styleClass="OraDataText" textBinding="nobkpC@defaultBean@servletRequest"/>
                    <uix:spacer width="8"/>
              </uix:cellFormat>
              <uix:cellFormat renderedBinding="hasRun@defaultBean@servletRequest" headers="">
                    <uix:styledText styleClass="OraPromptText" textBinding="RUNNING@bkpMgmtBundle"/>
                    <uix:spacer width="3"/>
                    <uix:image source="/em/images/okind_status.gif"/>
                    <uix:spacer width="3"/>
                    <uix:styledText styleClass="OraDataText" textBinding="runC@defaultBean@servletRequest"/>
                    <uix:spacer width="8"/>
              </uix:cellFormat>
              <uix:cellFormat renderedBinding="hasRunE@defaultBean@servletRequest" headers="">
                    <uix:styledText styleClass="OraPromptText" textBinding="RUNNING_WITH_ERRORS@bkpMgmtBundle"/>
                    <uix:spacer width="3"/>
                    <uix:image source="/em/images/critical.gif"/>
                    <uix:spacer width="3"/>
                    <uix:styledText styleClass="OraDataText" textBinding="runEC@defaultBean@servletRequest"/>
                    <uix:spacer width="8"/>
              </uix:cellFormat>
              <uix:cellFormat renderedBinding="hasRunW@defaultBean@servletRequest" headers="">
                    <uix:styledText styleClass="OraPromptText" textBinding="RUNNING_WITH_WARNINGS@bkpMgmtBundle"/>
                    <uix:spacer width="3"/>
                    <uix:image source="/em/images/warning.gif"/>
                    <uix:spacer width="3"/>
                    <uix:styledText styleClass="OraDataText" textBinding="runWC@defaultBean@servletRequest"/>
                    <uix:spacer width="8"/>
              </uix:cellFormat>
              <uix:cellFormat renderedBinding="hasUnknown@defaultBean@servletRequest" headers="">
                    <uix:styledText styleClass="OraPromptText" textBinding="UNKNOWN@bkpMgmtBundle"/>
                    <uix:spacer width="3"/>
                    <uix:image source="/em/images/critical.gif"/>
                    <uix:spacer width="3"/>
                    <uix:styledText styleClass="OraDataText" textBinding="unknownC@defaultBean@servletRequest"/>
              </uix:cellFormat>
              <uix:cellFormat headers="">
                <uix:styledText styleClass="OraDataText" text=" )"/>
              </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <oem:table name="grpBkpDataSource"
                       summaryBinding="RESULT@bkpMgmtBundle"
                       width="100%" blockSize="25"
                       dataSourceBinding="grpBkpDataSource@defaultBean@servletRequest"
                       alternateTextBinding="NO_JOB_FOUND@bkpMgmtBundle"
                       formSubmitted="true"/>               
            <uix:spacer height = "10"/>
            <uix:tip textBinding="VERSION_TIP@bkpMgmtBundle"/>
          </uix:stackLayout>
        </uix:header>

        <uix:stackLayout>
          <uix:header textBinding="RELATED_LINKS@bkpMgmtBundle">
            <uix:tableLayout width="80%" cellSpacing="2" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                <db:link textBinding="RECOVERY_CATALOGS@bkpMgmtBundle"
                         destination="/console/database/rec/catalogList?event=start"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left">
                  <db:link textBinding="ORACLE_BACKUP@bkpMgmtBundle"
                           destination="/console/database/ob"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>
        </uix:stackLayout>

      </uix:pageLayout>
    </db:form>
  </uix:body>
</uix:document>

</uix:renderingContext>

