<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.rec.idr.IdrConstants" %>
<%@ page import="oracle.sysman.db.rsc.rec.IdrMsgID" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 

  <uix:bundle name="DBObjectMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="IdrMsgs" class="oracle.sysman.db.rsc.rec.IdrMsg"/>

  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>
        <db:form name="idrForm" destination="/console/database/rec/idr/idr" method="post"
            copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/rec/idr/idrCheckList"/>    

          <uix:pageLayout titleBinding="MANUAL_CHECK_TITLE@IdrMsgs">
            <%@ include file="/database/global.jspf" %>

            <uix:messages>
              <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                   errorTableBinding="errors@servletRequest"
                                   titleTextKey="<%= IdrConstants.IDR_TITLE_TEXT %>"
                                   mainTextKey="<%= IdrConstants.IDR_MAIN_TEXT %>"/>
            </uix:messages>

            <uix:switcher childNameBinding="displayMmaManualChecks@idrUIBean@servletRequest">
              <uix:case name="true">
                <uix:stackLayout>
                  <uix:contents>

                    <uix:header textBinding="IDR_MMA_HEADER@IdrMsgs">
                      <uix:stackLayout>
                        <uix:contents>

                          <uix:styledText styleClass="OraInstructionText" textBinding="IDR_MMA_TEXT@IdrMsgs"/>
                          <uix:spacer height="10"/>

                          <uix:tableLayout summary="tl">
                            <uix:rowLayout>
                              <oem:table name="mmaCheckListTableUI"
                                       beanKey="idrUIBean"
                                       destination="/console/database/rec/idr/idr"
                                       formSubmitted="true"
                                       dataSourceProp="mmaCheckListTableUI"
                                       summaryBinding="IDR_MMA_CHECK_LIST@IdrMsgs"
                                       alternateTextBinding="NO_ITEMS_FOUND@DBObjectMsgs">
                              </oem:table>
                            </uix:rowLayout>
                          </uix:tableLayout>

                          <uix:spacer height="10"/>

                          <uix:header textBinding="IDR_MMA_FAILURES_HEADER@IdrMsgs" size="1">
                            <uix:stackLayout>
                              <uix:contents>

                                <uix:hGrid id="<%= IdrConstants.IDR_TREE_FAILURES_MMA %>"
                                    width="100%"
                                    alternateTextBinding="IDR_NO_FAILURES_FOUND@IdrMsgs"
                                    summaryBinding="IDR_FAILURES_MMA_TABLE@IdrMsgs"
                                    columnFormatsBinding="fixedColumnFormats@hgrid@idrUIBean@servletRequest"
                                    columnHeaderDataBinding="fixedColumnHeaderData@hgrid@idrUIBean@servletRequest"
                                    treeDataBinding="mmaTreeData@hgrid@idrUIBean@servletRequest"
                                    formSubmitted="true"
                                    proxyBinding="idrProxyMma@servletRequest">

                                  <uix:nodeStamp>
                                    <uix:column>
                                      <uix:columnHeader>
                                        <uix:styledText textBinding="IDR_FAILURE_DESCRIPTION@IdrMsgs"/>
                                      </uix:columnHeader>

                                      <uix:styledText textBinding="<%= IdrMsgID.IDR_FAILURE_DESCRIPTION %>"
                                                      destinationBinding="destination"/>
                                    </uix:column> 
                                  </uix:nodeStamp>

                                  <uix:columnHeaderStamp>
                                    <uix:text textBinding="text"/>
                                  </uix:columnHeaderStamp>
  
                                  <uix:styledText textBinding="<%= IdrMsgID.IDR_IMPACT %>"/>
                                  <uix:styledText textBinding="<%= IdrMsgID.IDR_PRIORITY %>"/>

                                </uix:hGrid>
                              </uix:contents>
                            </uix:stackLayout>
                          </uix:header>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:header>
                    <uix:spacer height="10"/>

                    <uix:switcher childNameBinding="displayManualChecks@idrUIBean@servletRequest">
                      <uix:case name="true">
                        <uix:header textBinding="IDR_OMA_HEADER@IdrMsgs">
                          <uix:stackLayout>
                            <uix:contents>

                              <uix:styledText styleClass="OraInstructionText" textBinding="IDR_OMA_TEXT@IdrMsgs"/>
                              <uix:spacer height="10"/>

                              <uix:tableLayout summary="tl">
                                <uix:rowLayout>
                                  <oem:table name="checkListTableUI"
                                           beanKey="idrUIBean"
                                           destination="/console/database/rec/idr/idr"
                                           formSubmitted="true"
                                           dataSourceProp="checkListTableUI"
                                           summaryBinding="IDR_OMA_CHECK_LIST@IdrMsgs"
                                           alternateTextBinding="NO_ITEMS_FOUND@DBObjectMsgs">
                                  </oem:table>
                                </uix:rowLayout>
                              </uix:tableLayout>
                            </uix:contents>
                          </uix:stackLayout>
                        </uix:header>
                      </uix:case>
                    </uix:switcher>

                  </uix:contents>
                </uix:stackLayout>

              </uix:case>
              <uix:case name="false">

                <uix:stackLayout>
                  <uix:contents>
                    <uix:spacer height="10"/>
                    <uix:styledText styleClass="OraInstructionText" textBinding="IDR_MANUAL_CHECK_TEXT@IdrMsgs"/>
                    <uix:spacer height="10"/>

                    <uix:tableLayout summary="tl">
                      <uix:rowLayout>
                        <oem:table name="checkListTableUI"
                                 beanKey="idrUIBean"
                                 destination="/console/database/rec/idr/idr"
                                 formSubmitted="true"
                                 dataSourceProp="checkListTableUI"
                                 summaryBinding="IDR_CHECK_LIST@IdrMsgs"
                                 alternateTextBinding="NO_ITEMS_FOUND@DBObjectMsgs">
                        </oem:table>
                      </uix:rowLayout>
                    </uix:tableLayout>
                  </uix:contents>
                </uix:stackLayout>

              </uix:case>
            </uix:switcher>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:contents>
                  <uix:button
                      textBinding="CANCEL@DBObjectMsgs"
                      destinationBinding="cancelURL@servletRequest"
                      shortDescBinding="CANCEL@DBObjectMsgs"/>
                  <uix:submitButton
                      textBinding="IDR_REASSESS_FAILURES_BUTTON@IdrMsgs"
                      shortDescBinding="IDR_REASSESS_FAILURES_BUTTON@IdrMsgs"
                      formName="idrForm"
                      name="event"
                      value="<%= IdrConstants.IDR_CHECK_LIST_REEVALUATE_EVENT %>"/>
                  <uix:submitButton
                      textBinding="IDR_CONTINUE_ADVISE_BUTTON@IdrMsgs"
                      shortDescBinding="IDR_CONTINUE_ADVISE_BUTTON@IdrMsgs"
                      renderedBinding="displayManualChecks@idrUIBean@servletRequest"
                      formName="idrForm"
                      name="event"
                      value="<%= IdrConstants.IDR_CHECK_LIST_CONTINUE_EVENT %>"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>       
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
