<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.rec.idr.IdrConstants" %>
<%@ page import="oracle.sysman.db.rsc.rec.IdrMsgID" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 

  <uix:bundle name="DBObjectMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="DBMsgs" class="oracle.sysman.db.rsc.inst.DBMsg"/>
  <uix:bundle name="IdrMsgs" class="oracle.sysman.db.rsc.rec.IdrMsg"/>
  <uix:bundle name="RecoveryMsgs" class="oracle.sysman.db.rsc.rec.RecoveryMsg"/>
  <uix:bundle name="CommonResourceBundle" class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="HMMsg" class="oracle.sysman.eml.swb.console.hm.HMMsg"/>

  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>
        <db:form name="idrForm" destination="/console/database/rec/idr/idr" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/rec/idr/idrFailures"/>    

          <uix:pageLayout titleBinding="IDR_TITLE@IdrMsgs">
            <%@ include file="/database/global.jspf" %>

            <uix:messages>
              <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                   errorTableBinding="errors@servletRequest"
                                   destTableBinding="errorUrls@servletRequest"
                                   titleTextKey="<%= IdrConstants.IDR_TITLE_TEXT %>"
                                   mainTextKey="<%= IdrConstants.IDR_MAIN_TEXT %>"/>
            </uix:messages>

            <uix:tableLayout width="100%" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat vAlign="top" hAlign="right" headers="">
                  <%-- need tableLayout for Netscape --%>
                  <uix:tableLayout summary="tl">
                    <uix:rowLayout hAlign="right">
                      <uix:cellFormat wrappingDisabled="true" headers="">
                        <uix:styledText styleClass="OraTipText"
                                        textBinding="LAST_REFRESH@DBObjectMsgs"/>
                      </uix:cellFormat>
                      <uix:spacer width="4"/>
                      <uix:cellFormat wrappingDisabled="true" headers="">
                        <uix:styledText styleClass="OraTipLabel"
                                        textBinding="timestamp@idrUIBean@servletRequest"/>
                      </uix:cellFormat>
                      <uix:spacer width="4"/>
                      <uix:image sourceBinding="refreshIcon@idrUIBean@servletRequest"
                                 destinationBinding="refreshDestination@idrUIBean@servletRequest" 
                                 shortDescBinding="REFRESH_DATA@CommonResourceBundle"/>
                    </uix:rowLayout>
                  </uix:tableLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <%-- uix:header textBinding="IDR_DATA_FAILURES@IdrMsgs" size="1" --%>
              <uix:switcher childNameBinding="showFailures@idrUIBean@servletRequest">
                <uix:case name="false">
                  <uix:styledText styleClass="OraInstructionText" textBinding="NO_FAILURES_DETECTED@RecoveryMsgs"/>
                  <uix:spacer height="10"/>
                </uix:case>
              </uix:switcher>
              <uix:stackLayout>
                <uix:contents>
                  <uix:switcher childNameBinding="showIntro@idrUIBean@servletRequest">
                    <uix:case name="true">
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:spacer height="5"/>
                          <uix:styledText styleClass="OraInstructionText" textBinding="IDR_INTRO@IdrMsgs"/>
                          <uix:spacer height="5"/>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:case>
                  </uix:switcher>

                  <uix:spacer height="5"/>
                  <uix:styledText styleClass="OraInstructionText" textBinding="IDR_FAILURE_FILTER_TIP@IdrMsgs"/>
                  <uix:spacer height="5"/>
                  <uix:rowLayout>
                    <uix:contents>
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:styledText styleClass="OraInstructionText" labeledNodeId="failureDescriptionFilter" textBinding="IDR_FAILURE_DESCRIPTION@IdrMsgs"/>
                          <uix:textInput 
                             name="failureDescriptionFilter"
                             id="failureDescriptionFilter"
                             textBinding="failureDescriptionFilter@hgrid@idrUIBean@servletRequest"
                             columns="16"/>
                        </uix:contents>
                      </uix:stackLayout>
                      <uix:spacer width="5"/>
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:styledText styleClass="OraInstructionText" labeledNodeId="impactFilter" textBinding="IDR_IMPACT@IdrMsgs"/>
                          <uix:textInput 
                              name="impactFilter"
                              id="impactFilter"
                              textBinding="impactFilter@hgrid@idrUIBean@servletRequest"
                              columns="16"/>
                        </uix:contents>
                      </uix:stackLayout>
                      <uix:spacer width="5"/>
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:styledText styleClass="OraInstructionText" labeledNodeId="prioritySearchType" textBinding="IDR_PRIORITY@IdrMsgs"/>
                          <uix:choice name="prioritySearchType" id="prioritySearchType"
                                  selectedValueBinding="prioritySearchType@hgrid@idrUIBean@servletRequest">
                            <uix:contents>
                              <uix:option
                                  textBinding="ALL@DBObjectMsgs"
                                  value="<%= IdrConstants.IDR_PRIORITY_CHOICE_ALL %>"/>
                              <uix:option
                                  textBinding="IDR_PRIORITY_CRITICAL_OR_HIGH@IdrMsgs"
                                  value="<%= IdrConstants.IDR_PRIORITY_CHOICE_CRITICAL_OR_HIGH %>"/>
                              <uix:option text="CRITICAL" value="<%= IdrConstants.IDR_PRIORITY_CHOICE_CRITICAL %>"/>
                              <uix:option text="HIGH" value="<%= IdrConstants.IDR_PRIORITY_CHOICE_HIGH %>"/>
                              <uix:option text="LOW" value="<%= IdrConstants.IDR_PRIORITY_CHOICE_LOW %>"/>
                            </uix:contents>
                          </uix:choice>
                        </uix:contents>
                      </uix:stackLayout>
                      <uix:spacer width="5"/>
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:styledText styleClass="OraInstructionText" labeledNodeId="statusSearchType" textBinding="IDR_STATUS@IdrMsgs"/>
                          <uix:choice name="statusSearchType" id="statusSearchType"
                                  selectedValueBinding="statusSearchType@hgrid@idrUIBean@servletRequest">
                            <uix:contents>
                              <uix:option
                                  textBinding="ALL@DBObjectMsgs"
                                  value="<%= IdrConstants.IDR_STATUS_CHOICE_ALL %>"/>
<%--
                              <uix:option
                                  textBinding="IDR_OPEN_OR_UNDER_REPAIR_CHOICE@IdrMsgs"
                                  value="<%= IdrConstants.IDR_STATUS_CHOICE_OPEN_OR_UNDER_REPAIR %>"/>
--%>
                              <uix:option text="OPEN" value="<%= IdrConstants.IDR_STATUS_CHOICE_OPEN %>"/>
<%--
                              <uix:option text="UNDER-REPAIR" value="<%= IdrConstants.IDR_STATUS_CHOICE_UNDER_REPAIR %>"/>
--%>
                              <uix:option text="CLOSED" value="<%= IdrConstants.IDR_STATUS_CHOICE_CLOSED %>"/>
                            </uix:contents>
                          </uix:choice>
                        </uix:contents>
                      </uix:stackLayout>
                      <uix:spacer width="5"/>
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:styledText styleClass="OraInstructionText" labeledNodeId="timestampSearchType" textBinding="IDR_DETECTION_TIMESTAMP@IdrMsgs"/>
                          <uix:choice name="timestampSearchType" id="timestampSearchType"
                                  selectedValueBinding="timestampSearchType@hgrid@idrUIBean@servletRequest">
                            <uix:contents>
                              <uix:option
                                  textBinding="ALL@DBObjectMsgs"
                                  value="<%= IdrConstants.IDR_TIMESTAMP_CHOICE_ALL %>"/>
                              <uix:option
                                  textBinding="IDR_TIMESTAMP_FILTER_DAY@IdrMsgs"
                                  value="<%= IdrConstants.IDR_TIMESTAMP_CHOICE_DAY %>"/>
                              <uix:option
                                  textBinding="IDR_TIMESTAMP_FILTER_WEEK@IdrMsgs"
                                  value="<%= IdrConstants.IDR_TIMESTAMP_CHOICE_WEEK %>"/>
                              <uix:option
                                  textBinding="IDR_TIMESTAMP_FILTER_MONTH@IdrMsgs"
                                  value="<%= IdrConstants.IDR_TIMESTAMP_CHOICE_MONTH %>"/>
                            </uix:contents>
                          </uix:choice>
                        </uix:contents>
                      </uix:stackLayout>
                      <uix:spacer width="5"/>
                      <uix:stackLayout>
                        <uix:contents>
                          <uix:styledText textBinding="GO@DBObjectMsgs" rendered="false"/>
                          <uix:spacer height="15"/>
                          <uix:submitButton
                              shortDescBinding="GO@DBObjectMsgs"
                              textBinding="GO@DBObjectMsgs"
                              name="event" value="<%= IdrConstants.IDR_SEARCH_EVENT %>"/>
                        </uix:contents>
                      </uix:stackLayout>
                    </uix:contents>
                  </uix:rowLayout>

                  <uix:spacer height="15"/>

                  <uix:hGrid id="<%= IdrConstants.IDR_TREE_FAILURES %>"
                       width="100%"
                       alternateTextBinding="IDR_NO_FAILURES_FOUND@IdrMsgs"
                       summaryBinding="IDR_FAILURES_TABLE@IdrMsgs"
                       columnFormatsBinding="columnFormats@hgrid@idrUIBean@servletRequest"
                       columnHeaderDataBinding="columnHeaderData@hgrid@idrUIBean@servletRequest"
                       treeDataBinding="failureTreeData@hgrid@idrUIBean@servletRequest"
                       formSubmitted="true"
                       proxyBinding="idrProxyFailures@servletRequest">

                    <uix:nodeStamp>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:styledText textBinding="IDR_FAILURE_DESCRIPTION@IdrMsgs"/>
                        </uix:columnHeader>

                        <uix:styledText textBinding="<%= IdrMsgID.IDR_FAILURE_DESCRIPTION %>"
                                        destinationBinding="destination"/>
                      </uix:column>
                    </uix:nodeStamp>

                    <uix:columnHeaderStamp>
                      <uix:text textBinding="text"/>
                    </uix:columnHeaderStamp>

                    <uix:styledText textBinding="<%= IdrMsgID.IDR_IMPACT %>"/>
                    <uix:styledText textBinding="<%= IdrMsgID.IDR_PRIORITY %>"/>
                    <uix:styledText textBinding="<%= IdrMsgID.IDR_STATUS %>"/>
                    <uix:styledText textBinding="<%= IdrMsgID.IDR_DETECTION_TIMESTAMP %>"/>

                    <uix:tableSelection>
                      <uix:multipleSelection
                          selectionBinding="selection@hgrid@idrUIBean@servletRequest"
                          shortDescBinding="SELECT@DBObjectMsgs"
                          disabledBinding="disabled"
                          onClick="submitForm(document.forms[0], true,
                              {'event':'failureSelectRow', 'source':'idrFailures'})"
                          selectedBinding="<%= IdrConstants.IDR_TABLE_SELECTED %>">
                        <uix:rowLayout>
                          <uix:contents>
                            <uix:cellFormat wrappingDisabled="true" headers="">
                              <uix:styledText
                                  styleClass="OraDataText"
                                  textBinding="IDR_TABLE_SELECT_TEXT@IdrMsgs"/>
                              <uix:spacer width="5"/>
                              <uix:submitButton
                                  shortDescBinding="IDR_ADVISE_REPAIR@IdrMsgs"
                                  textBinding="IDR_ADVISE_REPAIR@IdrMsgs"
                                  name="event" value="<%= IdrConstants.IDR_ADVISE_REPAIR_EVENT %>"/>
                              <uix:spacer width="5"/>
                              <uix:submitButton
                                  shortDescBinding="IDR_CLOSE@IdrMsgs"
                                  textBinding="IDR_CLOSE@IdrMsgs"
                                  name="event" value="<%= IdrConstants.IDR_CLOSE_FAILURES_EVENT %>"/>
<%--
                              <uix:spacer width="10"/>
                              <uix:styledText
                                  styleClass="OraInstructionText"
                                  labeledNodeId="changePriority"
                                  textBinding="IDR_TABLE_CHANGE_PRIORITY_TEXT@IdrMsgs"/>
                              <uix:spacer width="2"/>
                              <uix:choice name="changePriority" id="changePriority"
                                      selectedValueBinding="changePriority@hgrid@idrUIBean@servletRequest">
                                <uix:contents>
                                  <uix:option text="HIGH" value="<%= IdrConstants.IDR_PRIORITY_CHOICE_HIGH %>"/>
                                  <uix:option text="LOW" value="<%= IdrConstants.IDR_PRIORITY_CHOICE_LOW %>"/>
                                </uix:contents>
                              </uix:choice>
                              <uix:spacer width="2"/>
                              <uix:submitButton
                                  shortDescBinding="GO@DBObjectMsgs"
                                  textBinding="GO@DBObjectMsgs"
                                  name="event" value="<%= IdrConstants.IDR_CHANGE_PRIORITY_EVENT %>"/>
--%>
                              <uix:spacer width="5"/>
                              <uix:submitButton
                                  shortDescBinding="IDR_CHANGE_PRIORITY_HIGH_BUTTON@IdrMsgs"
                                  textBinding="IDR_CHANGE_PRIORITY_HIGH_BUTTON@IdrMsgs"
                                  name="event" value="<%= IdrConstants.IDR_CHANGE_PRIORITY_HIGH_EVENT %>"/>
                              <uix:spacer width="2"/>
                              <uix:submitButton
                                  shortDescBinding="IDR_CHANGE_PRIORITY_LOW_BUTTON@IdrMsgs"
                                  textBinding="IDR_CHANGE_PRIORITY_LOW_BUTTON@IdrMsgs"
                                  name="event" value="<%= IdrConstants.IDR_CHANGE_PRIORITY_LOW_EVENT %>"/>
                            </uix:cellFormat>
                          </uix:contents>
                        </uix:rowLayout>
                      </uix:multipleSelection>
                    </uix:tableSelection>
                  </uix:hGrid>

                  <uix:spacer height="15"/>

                  <uix:tip>
                    <uix:styledText
                      textBinding="IDR_FAILURES_TABLE_TIP@IdrMsgs"
                      styleClass="OraInstructionText"/>
                  </uix:tip>

                </uix:contents>
              </uix:stackLayout>
            <%-- /uix:header --%>

            <uix:switcher childNameBinding="displayRecoveryCatalog@idrUIBean@servletRequest">
              <uix:case name="true">
                <uix:tableLayout cellSpacing="5" width="80%" summary="tl">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:messageCheckBox name="fromRC" value="true"
                           selectedValueBinding="fromRC@defaultBean@servletRequest"
                           textBinding="FROM_RC@recoveryBundle@servletRequest"
                           styleClass="OraInstructionText" />
                    </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:labeledFieldLayout labelWidth="50%">
                      <uix:contents>
                        <uix:messagePrompt promptBinding="RC_DB@commonBundle@servletRequest" />
                        <uix:switcher childNameBinding="useRC@defaultBean@servletRequest">
                          <uix:case name="true">
                            <uix:styledText styleClass="OraInstructionTextStrong"
                                 textBinding="rcDatabase@defaultBean@servletRequest"/>
                          </uix:case>
                          <uix:case name="false">
                            <uix:styledText styleClass="OraInstructionTextStrong"
                                 textBinding="NOT_SPECIFIED@commonBundle@servletRequest"/>
                          </uix:case>
                        </uix:switcher>
                      </uix:contents>
                    </uix:labeledFieldLayout>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:cellFormat hAlign="center" headers="">
                        <uix:submitButton textBinding="EDIT_RC@commonBundle@servletRequest" name="event" value="editRC" shortDescBinding="EDIT_RC@commonBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:case>
            </uix:switcher>

            <uix:switcher childNameBinding="displayBackup@idrUIBean@servletRequest">
              <uix:case name="true">
                <uix:stackLayout>
                  <uix:contents>
                    <uix:spacer height="10"/>
                    <uix:rowLayout>
                      <uix:labeledFieldLayout labelWidth="50%">
                        <uix:contents>
                          <uix:messagePrompt labeledNodeId="dbid" promptBinding="DBID@recoveryBundle@servletRequest" />
                          <uix:textInput name="dbid" id="dbid" textBinding="dbid@defaultBean@servletRequest" columns="20" readOnlyBinding="dbidDisabled@defaultBean@servletRequest"/>
                          <uix:messagePrompt labeledNodeId="autoBackupLocation" promptBinding="AUTOBACKUP_LOCATION@recoveryBundle@servletRequest" />
                          <uix:textInput name="autoBackupLocation" id="autoBackupLocation" textBinding="autoBackupLocation@defaultBean@servletRequest" columns="80" />
                       </uix:contents>
                      </uix:labeledFieldLayout>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:stackLayout>
              </uix:case>
            </uix:switcher>

            <uix:header textBinding="RELATED_LINKS@DBMsgs" size="1">
              <uix:contents>
                <uix:stackLayout>
                  <uix:contents>
                    <uix:switcher childNameBinding="callingSource@idrUIBean@servletRequest">
                      <uix:case name="<%= IdrConstants.IDR_RESTORE_CONTROLFILE %>">
                        <uix:link
                            destinationBinding="callingSourceDest@idrUIBean@servletRequest"
                            textBinding="RESTORE_CONTROLFILE@RecoveryMsgs"/>
                      </uix:case>
                    </uix:switcher>
                    <uix:link
                        destinationBinding="checkerCentralDest@idrUIBean@servletRequest"
                        textBinding="TAB_CHECKER_CENTRAL@HMMsg"/>
                  </uix:contents>
                </uix:stackLayout>
              </uix:contents>
            </uix:header>

            <uix:switcher childNameBinding="useHostCredentials@idrUIBean@servletRequest">
              <uix:case name="true">
                <uix:header textBinding="HOST_CREDENTIALS@IdrMsgs" size="1">
                  <uix:contents>
                    <uix:stackLayout>
                      <uix:contents>
                        <%@ include file="/credentials.jspf"%>
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:contents>
                </uix:header>
              </uix:case>
            </uix:switcher>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:contents>
                  <uix:button
                      textBinding="CANCEL@DBObjectMsgs"
                      renderedBinding="noShowFailures@idrUIBean@servletRequest"
                      shortDescBinding="CANCEL@DBObjectMsgs"
                      destinationBinding="cancelURL@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>       
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
