<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.rec.idr.IdrConstants" %>
<%@ page import="oracle.sysman.db.rsc.rec.IdrMsgID" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 

  <uix:bundle name="DBObjectMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="RecoveryMsgs" class="oracle.sysman.db.rsc.rec.RecoveryMsg"/>
  <uix:bundle name="IdrMsgs" class="oracle.sysman.db.rsc.rec.IdrMsg"/>

  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>
        <db:form name="idrForm" destination="/console/database/rec/idr/idr" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/rec/idr/idrJobResults"/>    

          <uix:pageLayout titleBinding="IDR_JOB_RESULTS_TITLE@IdrMsgs">
            <%@ include file="/database/global.jspf" %>

            <uix:messages>
              <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                   errorTableBinding="errors@servletRequest"
                                   titleTextKey="<%= IdrConstants.IDR_TITLE_TEXT %>"
                                   mainTextKey="<%= IdrConstants.IDR_MAIN_TEXT %>"/>
            </uix:messages>

            <uix:switcher childNameBinding="showJob@idrUIBean@servletRequest">
              <uix:case name="true">
                <uix:header textBinding="IDR_REPAIR_RESULTS_TITLE@IdrMsgs" size="2">
                  <uix:stackLayout>
                    <uix:contents>
                      <uix:rawText id="rmanResults"
                          textBinding="rmanResults@idrUIBean@servletRequest"/>
                    </uix:contents>
                  </uix:stackLayout>
                </uix:header>
              </uix:case>
              <uix:case name="false">
                <uix:tableLayout cellSpacing="5" summary="tl">
                  <uix:rowLayout>
                    <uix:styledText styleClass="OraInstructionText" textBinding="DETAILS_OPEN_DB@RecoveryMsgs"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left" width="150" headers="">
                      <uix:textInput name="errMsg" id="errMsg" textBinding="errMsg@defaultBean@servletRequest" readOnly="true" columns="120" rows="15"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:case>
            </uix:switcher>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:contents>
                  <uix:switcher childNameBinding="showJob@idrUIBean@servletRequest">
                    <uix:case name="true">
                      <uix:switcher childNameBinding="dbStatus@defaultBean@servletRequest">
                        <uix:case name="MOUNTED">
                          <uix:switcher childNameBinding="openResetlogsRequired@defaultBean@servletRequest">
                            <uix:case name="true">
                              <uix:submitButton
                                  textBinding="OPEN_DB@RecoveryMsgs" 
                                  shortDescBinding="OPEN_DB@RecoveryMsgs" 
                                  formName="idrForm"
                                  name="event"
                                  value="<%= IdrConstants.IDR_JOB_RESULTS_OPENDB_RESETLOGS_EVENT %>"/>
                            </uix:case>
                            <uix:case name="false">
                              <uix:submitButton
                                  textBinding="OPEN_DB@RecoveryMsgs" 
                                  shortDescBinding="OPEN_DB@RecoveryMsgs" 
                                  formName="idrForm"
                                  name="event"
                                  value="<%= IdrConstants.IDR_JOB_RESULTS_OPENDB_EVENT %>"/>
                            </uix:case>
                          </uix:switcher>
                        </uix:case>
                      </uix:switcher>
                    </uix:case>
                  </uix:switcher>

                  <uix:switcher childNameBinding="showFailures@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:submitButton
                          textBinding="IDR_REASSESS_FAILURES_BUTTON@IdrMsgs"
                          shortDescBinding="IDR_REASSESS_FAILURES_BUTTON@IdrMsgs"
                          formName="idrForm"
                          name="event"
                          value="<%= IdrConstants.IDR_REINITIALIZE2_EVENT %>"/>
                    </uix:case>
                  </uix:switcher>

                  <uix:submitButton
                      textBinding="OK@DBObjectMsgs"
                      shortDescBinding="OK@DBObjectMsgs"
                      formName="idrForm"
                      name="event"
                      value="<%= IdrConstants.IDR_JOB_RESULTS_OK_EVENT %>"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>       
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
