<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.rec.idr.IdrConstants" %>
<%@ page import="oracle.sysman.db.rsc.rec.IdrMsgID" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 

  <uix:bundle name="DBObjectMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="DGMsgs" class="oracle.sysman.db.dg.rsc.DGMsg"/>
  <uix:bundle name="RecoveryMsgs" class="oracle.sysman.db.rsc.rec.RecoveryMsg"/>
  <uix:bundle name="IdrMsgs" class="oracle.sysman.db.rsc.rec.IdrMsg"/>

  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>
        <db:form name="idrForm" destination="/console/database/rec/idr/idr" method="post"
            copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/rec/idr/idrRepairOptions"/>    

          <uix:pageLayout titleBinding="IDR_REPAIR_OPTIONS@IdrMsgs">
            <%@ include file="/database/global.jspf" %>

            <uix:messages>
              <oem:messageBox messageTypeBinding="messageType@servletRequest"
                              errorTableBinding="errors@servletRequest"
                              destTableBinding="errorUrls@servletRequest"
                              titleTextKey="<%= IdrConstants.IDR_TITLE_TEXT %>"
                              mainTextKey="<%= IdrConstants.IDR_MAIN_TEXT %>"/>
            </uix:messages>

            <uix:switcher childNameBinding="yesRepairOptions@idrUIBean@servletRequest">
              <uix:case name="true">
                <uix:styledText styleClass="OraInstructionText" 
                    textBinding="repairStrategyDescription@idrUIBean@servletRequest"/>
              </uix:case>
            </uix:switcher>

            <uix:spacer height="10"/>
<%--
            <uix:switcher childNameBinding="yesRepairOptions@idrUIBean@servletRequest">
              <uix:case name="true">
                <uix:styledText styleClass="OraInstructionText" textBinding="IDR_RMAN_REPAIR_OPTIONS_TEXT@IdrMsgs"/>
              </uix:case>
            </uix:switcher>
            <uix:header 
                  textBinding="IDR_REPAIR_OPTIONS_HEADER@IdrMsgs" 
                  renderedBinding="yesRepairOptions@idrUIBean@servletRequest"
                  size="1">
              <uix:stackLayout>
                <uix:contents>

                  <uix:tableLayout>
                    <uix:rowLayout>
                      <oem:table name="repairOptionsTableUI"
                               beanKey="idrUIBean"
                               summaryBinding="IDR_REPAIR_OPTIONS_HEADER@IdrMsgs"
                               destination="/console/database/rec/idr/idr"
                               formSubmitted="true"
                               dataSourceProp="repairOptionsTableUI"
                               alternateTextBinding="NO_ITEMS_FOUND@DBObjectMsgs"
                               width="100%">
                        <uix:tableSelection>
                          <uix:singleSelection
                              shortDescBinding="SELECT@DBObjectMsgs"
                              onClick="submitForm(document.forms[0], true, {'event':'repairSelectRow', 'source':'repairOptions'})"
                              selectedIndexBinding="selectedIndex@repairOptionsTableDS@idrUIBean@servletRequest">
                            <uix:submitButton
                                shortDescBinding="IDR_REPAIR_BUTTON@IdrMsgs"
                                textBinding="IDR_REPAIR_BUTTON@IdrMsgs"
                                name="event" value="<%= IdrConstants.IDR_REPAIR_EVENT %>"/>
                          </uix:singleSelection>
                        </uix:tableSelection>
                      </oem:table>
                    </uix:rowLayout>
                  </uix:tableLayout>

                </uix:contents>
              </uix:stackLayout>
            </uix:header>
--%>

            <uix:switcher childNameBinding="yesRepairOptions@idrUIBean@servletRequest">
              <uix:case name="true">
                <uix:stackLayout>
                  <uix:contents>
                    <uix:spacer width="5"/>
                    <uix:styledText 
                        labeledNodeId="rmanScript"
                        styleClass="OraInstructionText"
                        textBinding="rmanScriptTitle@idrUIBean@servletRequest"/>
                    <uix:spacer width="2"/>
                    <uix:textInput name="rmanScript" id="rmanScript" rows="10"
                        textBinding="rmanScript@idrUIBean@servletRequest" columns="100"
                        readOnly="true"/>
                  </uix:contents>
                </uix:stackLayout>
              </uix:case>
            </uix:switcher>

            <uix:switcher childNameBinding="noRepairOptions@idrUIBean@servletRequest">
              <uix:case name="true">
                <uix:styledText styleClass="OraInstructionText" textBinding="IDR_RMAN_NO_REPAIR_OPTIONS_TEXT@IdrMsgs"/>
              </uix:case>
            </uix:switcher>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:contents>
                  <uix:button
                      textBinding="CANCEL@DBObjectMsgs"
                      renderedBinding="yesRepairOptions@idrUIBean@servletRequest"
                      shortDescBinding="CANCEL@DBObjectMsgs"
                      destinationBinding="cancelURL@servletRequest"/>

                  <uix:submitButton
                      renderedBinding="yesRepairOptions@idrUIBean@servletRequest"
                      textBinding="CONTINUE@DBObjectMsgs"
                      shortDescBinding="CONTINUE@DBObjectMsgs"
                      name="event" value="<%= IdrConstants.IDR_REPAIR_EVENT %>"/>
                  <uix:submitButton
                      renderedBinding="noRepairOptions@idrUIBean@servletRequest"
                      textBinding="PERFORM_RECOVERY_BUTTON@RecoveryMsgs"
                      shortDescBinding="PERFORM_RECOVERY_BUTTON@RecoveryMsgs"
                      name="event" value="<%= IdrConstants.IDR_PERFORM_RECOVERY_EVENT %>"/>
                  <uix:submitButton
                      renderedBinding="noRepairOptions@idrUIBean@servletRequest"
                      textBinding="OK@DBObjectMsgs"
                      shortDescBinding="OK@DBObjectMsgs"
                      name="event" value="<%= IdrConstants.IDR_REINITIALIZE_EVENT %>"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>       
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
