<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.rec.idr.IdrConstants" %>
<%@ page import="oracle.sysman.db.rsc.rec.IdrMsgID" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 

  <uix:bundle name="DBObjectMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="IdrMsgs" class="oracle.sysman.db.rsc.rec.IdrMsg"/>

  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>
        <db:form name="idrForm" destination="/console/database/rec/idr/idr" method="post"
            copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/rec/idr/idrReview"/>    

          <uix:pageLayout titleBinding="IDR_REVIEW_TITLE@IdrMsgs">
            <%@ include file="/database/global.jspf" %>

            <uix:messages>
              <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                   errorTableBinding="errors@servletRequest"
                                   titleTextKey="<%= IdrConstants.IDR_TITLE_TEXT %>"
                                   mainTextKey="<%= IdrConstants.IDR_MAIN_TEXT %>"/>
            </uix:messages>

            <uix:styledText styleClass="OraInstructionText" 
                textBinding="repairStrategyDescription@idrUIBean@servletRequest"/>

            <uix:spacer height="5"/>

            <uix:switcher childNameBinding="useRC@defaultBean@servletRequest">
              <uix:case name="true">
                <uix:labeledFieldLayout labelWidth="40%">
                  <uix:contents>
<%-- don't show Estimated columns for now
                    <uix:messagePrompt promptBinding="ESTIMATED_REPAIR_TIME@IdrMsgs"/>
                    <uix:styledText
                        styleClass="OraDataText"
                        textBinding="repairEstimatedRepairTime@idrUIBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="ESTIMATED_DATA_LOSS@IdrMsgs"/>
                    <uix:styledText
                        styleClass="OraDataText"
                        textBinding="repairEstimatedDataLoss@idrUIBean@servletRequest"/>
--%>
                    <uix:messagePrompt promptBinding="RC_DB@commonBundle@servletRequest" />
                    <uix:styledText styleClass="OraInstructionTextStrong"
                         textBinding="rcDatabase@defaultBean@servletRequest"/>
                  </uix:contents>
                </uix:labeledFieldLayout>
              </uix:case>
              <uix:case name="false">
                <uix:labeledFieldLayout labelWidth="30%">
                  <uix:contents>
<%-- don't show Estimated columns for now
                    <uix:messagePrompt promptBinding="ESTIMATED_REPAIR_TIME@IdrMsgs"/>
                    <uix:styledText
                        styleClass="OraDataText"
                        textBinding="repairEstimatedRepairTime@idrUIBean@servletRequest"/>
                    <uix:messagePrompt promptBinding="ESTIMATED_DATA_LOSS@IdrMsgs"/>
                    <uix:styledText
                        styleClass="OraDataText"
                        textBinding="repairEstimatedDataLoss@idrUIBean@servletRequest"/>
--%>
                    <uix:messagePrompt 
                         renderedBinding="displayBackup@idrUIBean@servletRequest"
                         promptBinding="DBID@recoveryBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong"
                         renderedBinding="displayBackup@idrUIBean@servletRequest"
                         textBinding="dbid@defaultBean@servletRequest"/>
                    <uix:messagePrompt 
                         renderedBinding="displayBackup@idrUIBean@servletRequest"
                         promptBinding="AUTOBACKUP_LOCATION@recoveryBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong"
                         renderedBinding="displayBackup@idrUIBean@servletRequest"
                         textBinding="autoBackupLocation@defaultBean@servletRequest"/>
                  </uix:contents>
                </uix:labeledFieldLayout>
              </uix:case>
            </uix:switcher>

            <uix:switcher childNameBinding="showDBOpenOnRepair@idrUIBean@servletRequest">
              <uix:case name="true">
                <uix:spacer height="10"/>
                <uix:rowLayout>
                  <uix:spacer width="15"/>
                  <uix:stackLayout>
                    <uix:contents>
                      <uix:checkBox
                            textBinding="IDR_OPEN_DB_ON_REPAIR@IdrMsgs"
                            name="<%= IdrConstants.IDR_OPEN_DB_ON_REPAIR_NAME %>"
                            checkedBinding="openDatabaseOnRepair@idrUIBean@servletRequest"/>
                      <uix:rowLayout>
                        <uix:spacer width="20"/>
                          <uix:styledText
                                styleClass="OraInstructionText"
                                textBinding="IDR_OPEN_DB_ON_REPAIR_INSTRUCTION@IdrMsgs"/>
                      </uix:rowLayout>
                    </uix:contents>
                  </uix:stackLayout>
                </uix:rowLayout>
              </uix:case>
            </uix:switcher>

            <uix:spacer height="10"/>

            <uix:header textBinding="IDR_FAILURES_RESOLVED_HEADER@IdrMsgs" size="1">
              <uix:stackLayout>
                <uix:contents>

                  <uix:hGrid id="<%= IdrConstants.IDR_TREE_FAILURES_FIXED %>"
                       width="100%"
                       alternateTextBinding="IDR_NO_FAILURES_FOUND@IdrMsgs"
                       summaryBinding="IDR_FAILURES_RESOLVED_TABLE@IdrMsgs"
                       columnFormatsBinding="fixedColumnFormats@hgrid@idrUIBean@servletRequest"
                       columnHeaderDataBinding="fixedColumnHeaderData@hgrid@idrUIBean@servletRequest"
                       treeDataBinding="fixedTreeData@hgrid@idrUIBean@servletRequest"
                       formSubmitted="true"
                       proxyBinding="idrProxyFixed@servletRequest">
  
                    <uix:nodeStamp>
                      <uix:column>
                        <uix:columnHeader>
                          <uix:styledText textBinding="IDR_FAILURE_DESCRIPTION@IdrMsgs"/>
                        </uix:columnHeader>

                        <uix:styledText textBinding="<%= IdrMsgID.IDR_FAILURE_DESCRIPTION %>"
                                        destinationBinding="destination"/>
                      </uix:column>
                    </uix:nodeStamp>

                    <uix:columnHeaderStamp>
                      <uix:text textBinding="text"/>
                    </uix:columnHeaderStamp>

                    <uix:styledText textBinding="<%= IdrMsgID.IDR_IMPACT %>"/>
                    <uix:styledText textBinding="<%= IdrMsgID.IDR_PRIORITY %>"/>

                  </uix:hGrid>

                </uix:contents>
              </uix:stackLayout>
            </uix:header>

            <uix:rowLayout>
              <uix:contents>
                <uix:spacer width="20"/>
                <uix:stackLayout>
                  <uix:contents>
                    <uix:spacer height="10"/>
                    <uix:styledText
                        labeledNodeId="rmanScript"
                        styleClass="OraInstructionText"
                        textBinding="rmanScriptTitle@idrUIBean@servletRequest"/>
<%-- get entire RMAN script
                  <uix:switcher childNameBinding="partialRmanScript@idrUIBean@servletRequest">
                    <uix:case name="true">
                      <uix:submitButton
                          shortDescBinding="IDR_FULL_RMAN_SCRIPT_BUTTON@IdrMsgs"
                          textBinding="IDR_FULL_RMAN_SCRIPT_BUTTON@IdrMsgs"
                          name="event" value="<%= IdrConstants.IDR_FULL_RMAN_SCRIPT_EVENT %>"/>
                    </uix:case>
                  </uix:switcher>
--%>
                    <uix:spacer height="2"/>
                    <uix:textInput name="rmanScript" id="rmanScript" rows="10"
                        textBinding="rmanScript@idrUIBean@servletRequest" columns="100"
                        readOnly="true"/>
                  </uix:contents>
                </uix:stackLayout>
              </uix:contents>
            </uix:rowLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:contents>
                  <uix:button
                      textBinding="CANCEL@DBObjectMsgs"
                      shortDescBinding="CANCEL@DBObjectMsgs"
                      destinationBinding="cancelURL@servletRequest"/>
                  <uix:submitButton
                      textBinding="submitButtonLabel@idrUIBean@servletRequest"
                      shortDescBinding="submitButtonLabel@idrUIBean@servletRequest"
                      name="event"
                      value="<%= IdrConstants.IDR_SUBMIT_REPAIR_EVENT %>"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>       
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
