<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<%@ include file="/oemNoscript.jspf" %>

<%-- Imports --%>
<%@ page import="oracle.sysman.db.util.rec.idr.IdrConstants" %>
<%@ page import="oracle.sysman.db.rsc.rec.IdrMsgID" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 

  <uix:bundle name="DBObjectMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="IdrMsgs" class="oracle.sysman.db.rsc.rec.IdrMsg"/>

  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:contents>
        <db:form name="idrForm" destination="/console/database/rec/idr/idr" method="post" copyParams="target,type,cancelURL">
          <uix:formValue name="pageName" value="/database/rec/idr/idrSelectedFailures"/>    

          <uix:pageLayout titleBinding="IDR_SELECTED_FAILURES@IdrMsgs">
            <%@ include file="/database/global.jspf" %>

            <uix:messages>
              <oem:messageBox messageTypeBinding="messageType@servletRequest"
                                   errorTableBinding="errors@servletRequest"
                                   titleTextKey="<%= IdrConstants.IDR_TITLE_TEXT %>"
                                   mainTextKey="<%= IdrConstants.IDR_MAIN_TEXT %>"/>
            </uix:messages>

<uix:switcher childNameBinding="displayFixed@hgrid@idrUIBean@servletRequest">
  <uix:case name="true">

<uix:header textBinding="IDR_FAILURES_RESOLVED_HEADER@IdrMsgs" size="1">
  <uix:stackLayout>
    <uix:contents>

            <uix:hGrid id="<%= IdrConstants.IDR_TREE_FAILURES_FIXED %>" 
                       width="100%"
                       alternateTextBinding="IDR_NO_FAILURES_FOUND@IdrMsgs"
                       summaryBinding="IDR_FAILURES_RESOLVED_TABLE@IdrMsgs"
                       columnFormatsBinding="fixedColumnFormats@hgrid@idrUIBean@servletRequest"
                       columnHeaderDataBinding="fixedColumnHeaderData@hgrid@idrUIBean@servletRequest"
                       treeDataBinding="fixedTreeData@hgrid@idrUIBean@servletRequest"
                       formSubmitted="true"
                       proxyBinding="idrProxyFixed@servletRequest">
   
              <uix:nodeStamp>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="IDR_FAILURE_DESCRIPTION@IdrMsgs"/>
                  </uix:columnHeader>

                  <uix:styledText textBinding="<%= IdrMsgID.IDR_FAILURE_DESCRIPTION %>"
                                  destinationBinding="destination"/>
                </uix:column>
              </uix:nodeStamp>

              <uix:columnHeaderStamp>
                <uix:text textBinding="text"/>
              </uix:columnHeaderStamp>

              <uix:styledText textBinding="<%= IdrMsgID.IDR_IMPACT %>"/>
              <uix:styledText textBinding="<%= IdrMsgID.IDR_PRIORITY %>"/>

            </uix:hGrid>

    </uix:contents>
  </uix:stackLayout>
</uix:header>

  </uix:case>
</uix:switcher>

<uix:switcher childNameBinding="displayNotFixed@hgrid@idrUIBean@servletRequest">
  <uix:case name="true">

<uix:header textBinding="IDR_FAILURES_NOT_RESOLVED_HEADER@IdrMsgs" size="1">
  <uix:stackLayout>
    <uix:contents>

            <uix:hGrid id="<%= IdrConstants.IDR_TREE_FAILURES_NOT_FIXED %>" 
                       width="100%"
                       alternateTextBinding="IDR_NO_FAILURES_FOUND@IdrMsgs"
                       summaryBinding="IDR_FAILURES_NOT_RESOLVED_TABLE@IdrMsgs"
                       columnFormatsBinding="fixedColumnFormats@hgrid@idrUIBean@servletRequest"
                       columnHeaderDataBinding="fixedColumnHeaderData@hgrid@idrUIBean@servletRequest"
                       treeDataBinding="notFixedTreeData@hgrid@idrUIBean@servletRequest"
                       formSubmitted="true"
                       proxyBinding="idrProxyNotFixed@servletRequest">
   
              <uix:nodeStamp>
                <uix:column>
                  <uix:columnHeader>
                    <uix:styledText textBinding="IDR_FAILURE_DESCRIPTION@IdrMsgs"/>
                  </uix:columnHeader>

                  <uix:styledText textBinding="<%= IdrMsgID.IDR_FAILURE_DESCRIPTION %>"
                                  destinationBinding="destination"/>
                </uix:column>
              </uix:nodeStamp>

              <uix:columnHeaderStamp>
                <uix:text textBinding="text"/>
              </uix:columnHeaderStamp>

              <uix:styledText textBinding="<%= IdrMsgID.IDR_IMPACT %>"/>
              <uix:styledText textBinding="<%= IdrMsgID.IDR_PRIORITY %>"/>

            </uix:hGrid>
    </uix:contents>
  </uix:stackLayout>
</uix:header>

  </uix:case>
</uix:switcher>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:contents>
                  <uix:submitButton
                      textBinding="IDR_RE_SELECT_FAILURES_BUTTON@IdrMsgs"
                      shortDescBinding="IDR_RE_SELECT_FAILURES_BUTTON@IdrMsgs"
                      formName="idrForm"
                      name="event"
                      value="<%= IdrConstants.IDR_RE_SELECT_FAILURES_EVENT %>"/>
                  <uix:submitButton
                      textBinding="CONTINUE@DBObjectMsgs"
                      shortDescBinding="CONTINUE@DBObjectMsgs"
                      formName="idrForm"
                      name="event"
                      value="<%= IdrConstants.IDR_SELECT_FAILURES_CONTINUE_EVENT %>"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

          </uix:pageLayout>       
        </db:form>
      </uix:contents>
    </uix:body>

  </uix:document> 
</uix:renderingContext> 
