<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" 
        method="post" copyParams="target,type,ignoreRelogin">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>
        <uix:formValue name="pageName" value="database/rec/mnt/mntBackupMgt.jsp"/>
        <uix:formParameter name="selectedBackupSetIndex"/>
        <uix:formValue name="beanType" valueBinding="beanType@servletRequest"/>
        <uix:formValue name="newBeanType"/>
    
     <uix:switcher childNameBinding="showPage@servletRequest">
      <uix:case name="false">
      <uix:pageLayout>
         <%@ include file="/database/global.jspf" %>
             <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                             errorTableBinding="msgBox@servletRequest"
                             destTableBinding="msgUrls@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
      </uix:pageLayout>   
      </uix:case>
      
      <uix:default>
      <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">
        <%@ include file="/database/global.jspf" %>
             <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                             errorTableBinding="msgBox@servletRequest"
                             destTableBinding="msgUrls@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>

            <uix:tableLayout width="100%" summary="tl">
              <uix:switcher childNameBinding="useRCView@dataSourceBean@servletRequest">
              <uix:case name="false">
              <uix:rowLayout>
                <uix:styledText styleClass="OraInstructionText"
                    textBinding="BACKUP_MGT_INST_MSG@mntBundle@servletRequest"  />
              </uix:rowLayout>
              </uix:case>
              
              <uix:case name="true">
              <uix:rowLayout>
              <uix:flowLayout>
                <uix:styledText styleClass="OraInstructionText"
                    textBinding="BACKUP_MGT_CATA_MSG@mntBundle@servletRequest"/>
              </uix:flowLayout>
              </uix:rowLayout>
              </uix:case>
             </uix:switcher>                       
             </uix:tableLayout>  

             <uix:subTabLayout>      
              <uix:subTabs>
                 <uix:switcher childNameBinding="beanType@servletRequest">
                  <uix:case name="copy_bean">
                     <uix:subTabBar selectedIndex="1">
                         <uix:link textBinding="BACKUP_SET@mntBundle@servletRequest" 
                            destinationBinding="backupsetDest@servletRequest"/>
                         <uix:link textBinding="COPY@mntBundle@servletRequest"/>   
                    </uix:subTabBar>
                   </uix:case>
                   <uix:default>
                      <uix:subTabBar selectedIndex="0">
                         <uix:link textBinding="BACKUP_SET@mntBundle@servletRequest"/>
                         <uix:link textBinding="COPY@mntBundle@servletRequest"
                            destinationBinding="copyDest@servletRequest"/> 
                      </uix:subTabBar>
                   </uix:default>
                   </uix:switcher>
              </uix:subTabs>   

            <uix:header textBinding="SEARCH@mntBundle@servletRequest">
             <uix:tableLayout summary="tl">
                  <uix:rowLayout>
                    <uix:spacer height="5"/>
                  </uix:rowLayout>

                 <uix:rowLayout>
                   <uix:cellFormat hAlign="right" headers="">
                    <uix:styledText labeledNodeId="filterStatus" styleClass="OraFieldText" textBinding="STATUS@mntBundle@servletRequest"/>
                   </uix:cellFormat>
                   
                   <uix:cellFormat columnSpan="2" headers="">
                      <uix:spacer width="5"/>  
                          <uix:choice name="filterStatus" 
                               id="filterStatus"
                               selectedValueBinding="filterStatus@defaultBean@servletRequest">
                               <uix:option textBinding="ALL@mntBundle@servletRequest" value="all"/>
                               <uix:option textBinding="AVAILABLE@mntBundle@servletRequest" value="AVAILABLE"/>
                               <uix:option textBinding="EXPIRED@mntBundle@servletRequest" value="EXPIRED"/>
                               <uix:option textBinding="UNAVAILABLE@mntBundle@servletRequest" value="UNAVAILABLE"/>
                               <uix:option textBinding="OTHER@mntBundle@servletRequest" value="OTHER"/>
                          </uix:choice>
                  </uix:cellFormat>
                  </uix:rowLayout>

                   <uix:rowLayout>
                      <uix:spacer height="5"/>
                   </uix:rowLayout>

                  <uix:rowLayout>
                  <uix:cellFormat hAlign="right" headers="">
                      <uix:styledText styleClass="OraInstructionText" textBinding="CONTENTS@mntBundle@servletRequest"/>
                  </uix:cellFormat>
                  
                   <uix:cellFormat columnSpan="2" headers="">
                     <uix:spacer width="5"/>  
                     <uix:checkBox name="datafileSelected" value="true" styleClass="oraFieldText" 
                        textBinding="DATAFILE@mntBundle@servletRequest" 
                        checkedBinding="datafileSelected@defaultBean@servletRequest"/>
                     <uix:checkBox name="redoLogSelected" value="true" styleClass="oraFieldText" 
                        textBinding="REDO_LOG@mntBundle@servletRequest" 
                        checkedBinding="redoLogSelected@defaultBean@servletRequest"/>
                     <uix:checkBox name="spfileSelected" value="true" styleClass="oraFieldText" 
                        textBinding="SPFILE@mntBundle@servletRequest" checkedBinding="spfileSelected@defaultBean@servletRequest"
                        renderedBinding="backupTypeSelected@defaultBean@servletRequest"/>
                     <uix:checkBox name="controlFileSelected" value="true" styleClass="oraFieldText" 
                        textBinding="CONTROL_FILE@mntBundle@servletRequest" 
                        checkedBinding="controlFileSelected@defaultBean@servletRequest"/>
                  </uix:cellFormat>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:spacer height="5"/>
                  </uix:rowLayout>

                  <uix:rowLayout renderedBinding="timeSelectionApplicable@defaultBean@servletRequest">
                    <uix:cellFormat hAlign="right" headers="">
                      <uix:styledText labeledNodeId="filterTime" styleClass="OraInstructionText" textBinding="START_TIME@mntBundle@servletRequest"/>
                    </uix:cellFormat>
                    
                   <uix:cellFormat headers="">
                           <uix:spacer width="5"/>  
                           <uix:choice name="filterTime" 
                               id="filterTime"
                               selectedValueBinding="filterTime@defaultBean@servletRequest">
                               <uix:option textBinding="ALL@mntBundle@servletRequest" value="all"/>
                               <uix:option textBinding="WITHIN_8_HOURS@mntBundle@servletRequest" value="eightHours"/>
                               <uix:option textBinding="WITHIN_ONE_DAY@mntBundle@servletRequest" value="oneDay"/>
                               <uix:option textBinding="WITHIN_2_DAYS@mntBundle@servletRequest" value="twoDays"/>
                               <uix:option textBinding="WITHIN_A_WEEK@mntBundle@servletRequest" value="oneWeek"/>
                               <uix:option textBinding="WITHIN_A_MONTH@mntBundle@servletRequest" value="oneMonth"/>
                          </uix:choice>
                    </uix:cellFormat>
                    
                    <uix:cellFormat headers="">
                        <uix:submitButton textBinding="GO@mntBundle@servletRequest" name="event" value="filter" shortDescBinding="GO@mntBundle@servletRequest" />
                    </uix:cellFormat>
                  </uix:rowLayout>
               </uix:tableLayout>
            </uix:header>

        <%-- SQL DEBUG
                  <uix:rowLayout>
                        <uix:styledText styleClass="OraInlineInfoText" textBinding="populateSql@rmanDataSource@defaultBean@servletRequest"/>
                  </uix:rowLayout>
        --%>
            <uix:header textBinding="RESULTS@mntBundle@servletRequest">
            <uix:stackLayout>
              <uix:contents>
              <uix:tableLayout width="100%" cellSpacing="2" summary="tl">
              
                   <uix:rowLayout>
                    <oem:table name="rmanTwoDUIDataSource"
                         summaryBinding="RESULTS@mntBundle@servletRequest"
                         width="100%" blockSize="25"
                         dataSourceProp="rmanTwoDUIDataSource"
                         beanKey="dataSourceBean"
                         destinationBinding="destination@defaultBean@servletRequest"
                         alternateTextBinding="NO_ITEMS_FOUND@mntBundle@servletRequest"
                         formSubmitted="true">
                         <uix:tableSelection>
                            <uix:multipleSelection shortDesc="Select" selectionBinding="SelectionDataObjectList@servletRequest" selectedBinding="isSelected">
                                <uix:submitButton textBinding="CROSSCHECK_BUT@mntBundle@servletRequest" name="event" value="crosscheck"
                                    renderedBinding="crosscheckApplicable@defaultBean@servletRequest"  shortDescBinding="CROSSCHECK_BUT@mntBundle@servletRequest" />
                                <uix:submitButton textBinding="CHANGE_TO_AVAILABLE@mntBundle@servletRequest" name="event" value="changeToAvail"
                                    renderedBinding="changeToAvailableApplicable@defaultBean@servletRequest"  shortDescBinding="CHANGE_TO_AVAILABLE@mntBundle@servletRequest" />
                                <uix:submitButton textBinding="CHANGE_TO_UNAVAILABLE@mntBundle@servletRequest" name="event" value="changeToUnavail"
                                    renderedBinding="changeToUnavailableApplicable@defaultBean@servletRequest"  shortDescBinding="CHANGE_TO_UNAVAILABLE@mntBundle@servletRequest" />
                                <uix:submitButton textBinding="DELETE@mntBundle@servletRequest" name="event" value="delete"
                                    renderedBinding="deleteApplicable@defaultBean@servletRequest"  shortDescBinding="DELETE@mntBundle@servletRequest" />
                                <uix:submitButton textBinding="VALIDATE@mntBundle@servletRequest" name="event" value="validate"
                                    renderedBinding="validateApplicable@defaultBean@servletRequest"  shortDescBinding="VALIDATE@mntBundle@servletRequest" />
                           </uix:multipleSelection>
                        </uix:tableSelection>
                    </oem:table>
                   </uix:rowLayout>
                 </uix:tableLayout> 
              </uix:contents>
            </uix:stackLayout>
           </uix:header> 
           
           <uix:header textBinding="HOST_CREDENTIALS@mntBundle@servletRequest">
            <uix:styledText styleClass="OraInstructionText" textBinding="OS_CREDENTIALS@mntBundle@servletRequest" />
                <uix:contents>
                  <%@ include file="/credentials.jspf"%>
                </uix:contents>
           </uix:header>   
           </uix:subTabLayout>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CATALOG_FILE@mntBundle@servletRequest" name="event" value="catalogFile"
                    renderedBinding="DB10orHigher@defaultBean@@servletRequest" shortDescBinding="CATALOG_FILE@mntBundle@servletRequest" />
                <uix:submitButton textBinding="CROSSCHECK_ALL@mntBundle@servletRequest" name="event" value="crosscheckAll" shortDescBinding="CROSSCHECK_ALL@mntBundle@servletRequest" />
                <uix:submitButton textBinding="DELETE_ALL_OBSOLETE@mntBundle@servletRequest" name="event" value="deleteAllObsolete" shortDescBinding="DELETE_ALL_OBSOLETE@mntBundle@servletRequest" />
                <uix:submitButton textBinding="DELETE_ALL_EXPIRED@mntBundle@servletRequest" name="event" value="deleteAllExpired" shortDescBinding="DELETE_ALL_EXPIRED@mntBundle@servletRequest" />
              </uix:pageButtonBar>
            </uix:pageButtons>
        </uix:pageLayout>
       </uix:default>
       </uix:switcher>
       
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

