<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" 
            method="post" copyParams="target,type,beanType,ignoreRelogin">

      <uix:pageLayout titleBinding="CATALOG_FILE@mntBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>

         <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                         errorTableBinding="msgBox@servletRequest"
                         destTableBinding="msgUrls@servletRequest"
                         titleTextKey="titleText" mainTextKey="mainText"/>

            <uix:styledText styleClass="OraInstructionText"
                text=""  />

            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                    <oem:radioButton name="catalogType" value="recovery_area"
                                     selectedValueBinding="catalogType@defaultBean@servletRequest"
                                     styleClass="OraInstructionText"
                                     textBinding="CATALOG_RA@mntBundle@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                    <oem:radioButton name="catalogType" value="dir"
                                     selectedValueBinding="catalogType@defaultBean@servletRequest"
                                     styleClass="OraInstructionText"
                                     textBinding="CATALOG_DIR@mntBundle@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="center" headers="">
                  <uix:messageTextInput name="fileName" 
                       textBinding="fileName@defaultBean@servletRequest" 
                       promptBinding="FILE_NAME@mntBundle@servletRequest" 
                       tipBinding="FILE_NAME_TIP@mntBundle@servletRequest" 
                       columns="30" />
                </uix:cellFormat>
              </uix:rowLayout>

            </uix:tableLayout>

          <uix:styledText text="" />

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@mntBundle@servletRequest" name="event" value="redisplay" shortDescBinding="CANCEL@mntBundle@servletRequest"/>
                <uix:submitButton textBinding="OK@mntBundle@servletRequest" name="event" value="applyCatalogFile" shortDescBinding="OK@mntBundle@servletRequest"/>
              </uix:pageButtonBar>
            </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

