<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db" %> 

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/> 
  <uix:document> 

    <%@ include file="/oemTitle.jspf" %>    
    <uix:body>
    <db:form name="foo" method="POST" copyParams="target,type,beanType,ignoreRelogin"
        destinationBinding="destination@defaultBean@servletRequest">

     <uix:pageLayout titleBinding="pageHeader@defaultBean@servletRequest">
      <%@ include file="/database/global.jspf" %> 
      
      <uix:formValue name="confirmAction" valueBinding="confirmAction@servletRequest"/>
      <uix:formValue name="pageName" value="/database/rec/mnt/mntSchedule.jsp"/>
      
      <uix:pageButtons>
        <uix:pageButtonBar>
          <uix:contents>
              <uix:submitButton textBinding="CANCEL@mntBundle@servletRequest" 
                            name="event" value="redisplay" shortDescBinding="CANCEL@mntBundle@servletRequest"/>
              <uix:submitButton textBinding="SHOW_RMAN_SCRIPT@mntBundle@servletRequest"  
                            name="event" value="showRmanScript" shortDescBinding="SHOW_RMAN_SCRIPT@mntBundle@servletRequest"/>
              <uix:submitButton textBinding="SUBMIT_JOB@mntBundle@servletRequest"  
                            name="event" value="submitJob" shortDescBinding="SUBMIT_JOB@mntBundle@servletRequest"/>

	    </uix:contents>
        </uix:pageButtonBar>
      </uix:pageButtons>

             <oem:messageBox messageTypeBinding="messageType@servletRequest" 
                             errorTableBinding="msgBox@servletRequest"
                             destTableBinding="msgUrls@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>

                <uix:tableLayout width="100%" summary="tl">
                
                <uix:rowLayout>    
                <uix:stackLayout>
                  <uix:styledText styleClass="OraInstructionText" textBinding="JOB_MSG@mntBundle@servletRequest"/>
                  <uix:tableLayout cellSpacing="5" summary="tl" >
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" headers="">
                        <uix:messagePrompt required="yes"
                              labeledNodeId="jobName"
                             promptBinding="JOB_NAME@mntBundle@servletRequest"/>
                    </uix:cellFormat>
                    
                    <uix:cellFormat hAlign="left" headers="">         
                        <uix:textInput name="jobName"
                            id="jobName"
                            styleClass="OraInstructionText"
                            textBinding="jobName@defaultBean@servletRequest"
                            required="yes"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  
                  <uix:rowLayout>  
                    <uix:cellFormat hAlign="right" headers="">
                        <uix:messagePrompt required="yes"
                             labeledNodeId="jobDescription"
                             promptBinding="JOB_DESC@mntBundle@servletRequest"/>
                    </uix:cellFormat>
                    
                    <uix:cellFormat hAlign="left" headers="">
                        <uix:textInput name="jobDescription"
                             id="jobDescription"
                             styleClass="OraInstructionText"
                             textBinding="jobDescription@defaultBean@servletRequest"
                             columns="60"
                             required="yes"/>
                    </uix:cellFormat>
                  </uix:rowLayout>                          
                  
                  <uix:rowLayout>
                  <uix:cellFormat columnSpan="2" headers="">
                      <uix:switcher childNameBinding="confirmAction@servletRequest">
                      <uix:case name="deleteAllExpired">
                      <uix:stackLayout>
                         <uix:checkBox name="crschkBeforeDelAllExp" value="true" styleClass="oraFieldText" 
                            textBinding="CRSCHK_DEL_MSG@mntBundle@servletRequest" 
                            checkedBinding="crschkBeforeDelAllExpSelected@defaultBean@servletRequest"/>
                         <uix:styledText styleClass="OraInlineInfoText" 
                            textBinding="CRSCHK_DEL_MSG_HINT@mntBundle@servletRequest"/>
                            
                      </uix:stackLayout>      
                      </uix:case>
                      </uix:switcher>        
                  </uix:cellFormat>
                  </uix:rowLayout>
                  </uix:tableLayout>
                  <uix:header textBinding="SCHEDULE@mntBundle@servletRequest">
                      <uix:ref refID="SCHEDULE_SEGMENT" />
                  </uix:header>
                 </uix:stackLayout>
                 </uix:rowLayout>
                 </uix:tableLayout>

        </uix:pageLayout>
     </db:form>
    </uix:body>
  </uix:document> 
</uix:renderingContext>
