<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    <uix:metaContainer>
      <uix:head titleBinding="RECOVERY_CREDENTIALS@recoveryBundle@servletRequest"/>
    </uix:metaContainer>

    <uix:body>
    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="ignoreRelogin" value="true"/>
        <uix:formValue name="pageName" value="database/rec/recovery/dbDown.jsp"/>

      <uix:pageLayout titleBinding="RECOVERY_CREDENTIALS@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>

        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        destTableBinding="msgUrls@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>

        <uix:header textBinding="HOST_CREDENTIALS@commonBundle@servletRequest">
          <uix:contents>
            <%@ include file="/credentials.jspf"%>
          </uix:contents>
        </uix:header>

          <uix:pageButtons>
            <uix:switcher childNameBinding="showCredsOpError@defaultBean@servletRequest">
              <uix:case name="true">
                  <uix:pageButtonBar>
                    <uix:submitButton textBinding="CONTINUE@commonBundle@servletRequest" formName="foo" name="event" value="cancel" shortDesc="image"/>
                  </uix:pageButtonBar>
              </uix:case>
              <uix:case name="false">
                  <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="cancel" shortDesc="image"/>
                    <uix:submitButton textBinding="CONTINUE@commonBundle@servletRequest" formName="foo" name="event" value="initDbStatus" shortDesc="image"/>
                  </uix:pageButtonBar>
              </uix:case>
            </uix:switcher>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

