<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<db:script src="/database/LOV.js"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="ignoreRelogin" valueBinding="ignoreRelogin@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="backupPageTitle@defaultBean@servletRequest">
        <%@ include file="/database/global.jspf" %>
        <%@ include file="/database/rec/trainMessages.jspf" %>

	  <uix:spacer height="10" />

          <uix:header textBinding="BACKUP_SELECTION@recoveryBundle@servletRequest">
            <uix:styledText styleClass="OraInstructionText" textBinding="BACKUP_INTRO@recoveryBundle@servletRequest" />
            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                    <oem:radioButton name="pitrType" value="recent"
                                     selectedValueBinding="pitrType@defaultBean@servletRequest"
                                     shortDescBinding="MOST_RECENT_BACKUP@recoveryBundle@servletRequest"
                                     textBinding="MOST_RECENT_BACKUP@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" onClick="submitForm('foo', true, {'event':'switchDisablePitr'})" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                    <oem:radioButton name="pitrType" value="point_in_time"
                                     selectedValueBinding="pitrType@defaultBean@servletRequest"
                                     shortDescBinding="PITR_BACKUP@recoveryBundle@servletRequest"
                                     textBinding="PITR_BACKUP@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" onClick="submitForm('foo', true, {'event':'switchEnablePitr'})" />
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <%----    point in time option: hide/show ---------------%>
            <uix:switcher childNameBinding="PITRDisabled@defaultBean@servletRequest">
            <uix:case name="false">
            <uix:tableLayout cellSpacing="10" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" vAlign="top" headers="">
                  <uix:spacer width="10"/>
                    <oem:radioButton name="rangeType" value="time"
                                     shortDescBinding="DATE_LABEL@recoveryBundle@servletRequest"
                                     selectedValueBinding="rangeType@defaultBean@servletRequest"
                                     styleClass="OraInstructionText" disabledBinding="PITRDisabled@defaultBean@servletRequest" />
                  <uix:messagePrompt promptBinding="DATE_LABEL@recoveryBundle@servletRequest" />
                </uix:cellFormat>

                <uix:cellFormat hAlign="left" vAlign="top" headers="">
                  <uix:messageDateField name="untilDate" shortDescBinding="dateTip@scheduleBean@servletRequest" columns="10" valueBinding="untilDate@defaultBean@servletRequest" tipBinding="dateTip@scheduleBean@servletRequest">
                    <uix:onSubmitValidater>
                      <uix:date dateStyle="medium"/>
                    </uix:onSubmitValidater>
                  </uix:messageDateField>
                </uix:cellFormat>

                <uix:cellFormat hAlign="left" vAlign="top" headers="">
		  <uix:spacer width="10"/>
                  <uix:messagePrompt promptBinding="TIME_LABEL@recoveryBundle@servletRequest" />

		  <oem:choice
                     shortDescBinding="TIME_LABEL@recoveryBundle@servletRequest"
		     name="untilTimeHour"
		     optionsBinding="hoursListSource@defaultBean@servletRequest" 
		     selectedValueBinding="untilTimeHour@defaultBean@servletRequest" />
		  <oem:choice
                     shortDescBinding="TIME_LABEL@recoveryBundle@servletRequest"
		     name="untilTimeMinute"
		     optionsBinding="minutesListSource@defaultBean@servletRequest" 
		     selectedValueBinding="untilTimeMinute@defaultBean@servletRequest" />
                  <oem:radioButton name="untilTimeAmPm" value="am"
                                     selectedValueBinding="untilTimeAmPm@defaultBean@servletRequest"
                                     textBinding="AM_LABEL@recoveryBundle@servletRequest" 
                                     styleClass="OraInstructionText" />
                  <oem:radioButton name="untilTimeAmPm" value="pm"
                                     selectedValueBinding="untilTimeAmPm@defaultBean@servletRequest"
                                     textBinding="PM_LABEL@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />
                </uix:cellFormat>

              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:spacer width="10"/>
                    <oem:radioButton name="rangeType" value="scn"
                                     shortDescBinding="SCN_LABEL@recoveryBundle@servletRequest"
                                     selectedValueBinding="rangeType@defaultBean@servletRequest"
                                     styleClass="OraInstructionText" disabledBinding="PITRDisabled@defaultBean@servletRequest" />
                  <uix:messagePrompt labeledNodeId="untilSCN" promptBinding="SCN_LABEL@recoveryBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:textInput name="untilSCN" id="untilSCN" textBinding="untilSCN@defaultBean@servletRequest" columns="10" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:spacer width="10"/>
                    <oem:radioButton name="rangeType" value="logseq"
                                     shortDescBinding="LOGSEQ_LABEL@recoveryBundle@servletRequest"
                                     selectedValueBinding="rangeType@defaultBean@servletRequest"
                                     styleClass="OraInstructionText" disabledBinding="PITRDisabled@defaultBean@servletRequest" />
                  <uix:messagePrompt labeledNodeId="untilLogSeq" promptBinding="LOGSEQ_LABEL@recoveryBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:textInput name="untilLogSeq" id="untilLogSeq" textBinding="untilLogSeq@defaultBean@servletRequest" columns="10" />
                </uix:cellFormat>

                <uix:switcher childNameBinding="racTarget@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:messagePrompt labeledNodeId="thread" promptBinding="THREAD_LABEL@recoveryBundle@servletRequest" />
                    </uix:cellFormat>
                  </uix:case>
                </uix:switcher>
                <uix:switcher childNameBinding="racTarget@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:textInput name="thread" id="thread" textBinding="thread@defaultBean@servletRequest" columns="2" />
                    </uix:cellFormat>
                  </uix:case>
                </uix:switcher>

              </uix:rowLayout>
            </uix:tableLayout>
            </uix:case>
            </uix:switcher>
            <%------- end point in time --------------------------------------%>

            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <oem:radioButton name="pitrType" value="tag" 
                                   selectedValueBinding="pitrType@defaultBean@servletRequest"
                                   shortDescBinding="BACKUP_TAG@recoveryBundle@servletRequest"
                                   styleClass="OraInstructionText" onClick="submitForm('foo', true, {'event':'switchDisablePitr'})" />
                </uix:cellFormat>
                <uix:cellFormat headers="">
                   <uix:styledText labeledNodeId="backuptagid"
                   textBinding="BACKUP_TAG@recoveryBundle@servletRequest"
                   styleClass="OraInstructionText" />
                </uix:cellFormat>

		<uix:cellFormat hAlign="left" headers="">
		  <uix:switcher childNameBinding="DB10orHigher@defaultBean@servletRequest">
		    <uix:case name="true">
                      <uix:messageLovField name="backupTag" textBinding="backupTag@defaultBean@servletRequest" onClick="startLov('backupTag', 'ListTag')" searchDescBinding="BACKUP_TAG@recoveryBundle@servletRequest" id="backuptagid"/>	               
		    </uix:case>
  		    <uix:case name="false">
                      <uix:messageLovField name="backupTag" textBinding="backupTag@defaultBean@servletRequest" onClick="startLov('backupTag', 'ListTagPre10i')" searchDescBinding="BACKUP_TAG@recoveryBundle@servletRequest" id="backuptagid"/>
		    </uix:case>
                  </uix:switcher>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

          </uix:header>
          <uix:header textBinding="BACKUP_VALIDATION@recoveryBundle@servletRequest">
            <uix:tableLayout summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:messageCheckBox name="restoreValidate"
                       textBinding="VALIDATE_BACKUP@recoveryBundle@servletRequest"
                       tipBinding="VALIDATE_BACKUP_TIP@recoveryBundle@servletRequest"
                       shortDescBinding="VALIDATE_BACKUP_TIP@recoveryBundle@servletRequest"
                       checkedBinding="restoreValidate@defaultBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@commonBundle@servletRequest"/>
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

