<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="prevURL" valueBinding="prevURL@servletRequest"/>

      <uix:pageLayout titleBinding="RECOVERY_BLOCK_RECOVERY@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>
        <%@ include file="/database/rec/trainMessages.jspf" %>

            <uix:styledText styleClass="OraInstructionText" textBinding="BLOCK_RECOVERY_INTRO@recoveryBundle@servletRequest" />
            <uix:tableLayout cellSpacing="5" width="100%" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" columnSpan="2" headers="">
                  <uix:messageRadioButton name="bmrType" value="corruption_list"
                                     selectedValueBinding="bmrType@defaultBean@servletRequest"
                                     textBinding="CORRUPTION_LIST@recoveryBundle@servletRequest"
                                     tipBinding="CORRUPTION_LIST_TEXT@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />

                </uix:cellFormat>
              </uix:rowLayout>
          <uix:switcher childNameBinding="DB111orHigher@defaultBean@servletRequest">
          <uix:case name="false">
          <uix:switcher childNameBinding="showValidateDatabase@defaultBean@servletRequest">
            <uix:case name="true">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:spacer width="20"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:messageCheckBox name="validateDatabase" 
                       textBinding="VALIDATE_DATABASE@recoveryBundle@servletRequest" 
                       checkedBinding="validateDatabase@defaultBean@servletRequest" 
                       shortDescBinding="VALIDATE_DATABASE_TIP@recoveryBundle@servletRequest"
                       tipBinding="VALIDATE_DATABASE_TIP@recoveryBundle@servletRequest" />
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:case>
          </uix:switcher>
         </uix:case>
         </uix:switcher>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" columnSpan="2" headers="">
                  <uix:messageRadioButton name="bmrType" value="block_id"
                                     selectedValueBinding="bmrType@defaultBean@servletRequest"
                                     textBinding="DATAFILES@recoveryBundle@servletRequest"
                                     tipBinding="BMR_DF_TEXT@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />

                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" columnSpan="2" headers="">
                  <uix:messageRadioButton name="bmrType" value="block_address"
                                     selectedValueBinding="bmrType@defaultBean@servletRequest"
                                     textBinding="TABLESPACES@recoveryBundle@servletRequest"
                                     tipBinding="BMR_TS_TEXT@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />

                </uix:cellFormat>
              </uix:rowLayout>

            </uix:tableLayout>


            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@recoveryBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@recoveryBundle@servletRequest"/>
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

