<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>

      <uix:pageLayout titleBinding="RECOVERY_CORRUPTED_BLOCKS@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>
        <%@ include file="/database/rec/trainMessages.jspf" %>

            <uix:styledText styleClass="OraInstructionText" textBinding="BLOCK_ADDRESS_INTRO@recoveryBundle@servletRequest" />

            <oem:table width="100%" name="bmrTwoDUIDataSource"
                         blockSize="10"
                         dataSourceProp="bmrTwoDUIDataSource"
                         beanKey="bmrTablespacesDataSource"
                         copyParams="target,type"
                         destination="/console/database/rec/recovery"
                         formSubmitted="true">

             </oem:table>

            <uix:spacer height="10"/>
            <uix:switcher childNameBinding="DB92orHigher@defaultBean@servletRequest">
              <uix:case name="true">
                <uix:switcher childNameBinding="DB111orHigher@defaultBean@servletRequest">
                <uix:case name="false">
                <uix:messageCheckBox name="validateBMR" 
                     textBinding="UPDATE_LIST@recoveryBundle@servletRequest" 
                     checkedBinding="validateBMR@defaultBean@servletRequest" />
                </uix:case>
                </uix:switcher>
              </uix:case>
            </uix:switcher>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@recoveryBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@recoveryBundle@servletRequest"/>

                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

