<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<db:script src="/database/LOV.js"/>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="ignoreRelogin" valueBinding="ignoreRelogin@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="PITRPageTitle@defaultBean@servletRequest">
        <%@ include file="/database/global.jspf" %>
        <%@ include file="/database/rec/trainMessages.jspf" %>

          <uix:header textBinding="PITR@recoveryBundle@servletRequest">
            <uix:styledText styleClass="OraInstructionText" textBinding="DB_PITR_INTRO@recoveryBundle@servletRequest" />
            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                    <oem:radioButton name="pitrType" value="recent"
                                     selectedValueBinding="pitrType@defaultBean@servletRequest"
                                     textBinding="PITR_CURRENT@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" onClick="submitForm('foo', true, {'event':'switchDisablePitr'})" />

                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                    <oem:radioButton name="pitrType" value="point_in_time"
                                     selectedValueBinding="pitrType@defaultBean@servletRequest"
                                     textBinding="PITR_PAST@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" onClick="submitForm('foo', true, {'event':'switchEnablePitr'})" />
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
            <uix:switcher childNameBinding="flashbackUsable@defaultBean@servletRequest">
              <uix:case name="true">
                <uix:tableLayout cellSpacing="5" summary="tl">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:spacer width="10"/>
                      <uix:tip textBinding="PITR_FLASHBACK_TIP@recoveryBundle@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:case>
            </uix:switcher>

            <uix:switcher childNameBinding="flashbackUsable@defaultBean@servletRequest">
              <uix:case name="true">
                <uix:labeledFieldLayout width="75%">
                  <uix:contents>
                    <uix:styledText styleClass="OraInstructionText"
                         textBinding="OLDEST_FLASHBACK_TIME@recoveryBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong"
                         textBinding="oldestFlashbackTime@defaultBean@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionText"
                         textBinding="OLDEST_FLASHBACK_SCN@recoveryBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionTextStrong"
                         textBinding="oldestFlashbackSCN@defaultBean@servletRequest"/>
                  </uix:contents>
                </uix:labeledFieldLayout>
              </uix:case>
            </uix:switcher>

            <%----    point in time ------------------------%>
            <uix:switcher childNameBinding="PITRDisabled@defaultBean@servletRequest">
            <uix:case name="false">
            <uix:tableLayout cellSpacing="10" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" vAlign="top" headers="">
                  <uix:spacer width="10"/>
                    <oem:radioButton name="rangeType" value="time"
                                     shortDescBinding="DATE_LABEL@recoveryBundle@servletRequest"
                                     selectedValueBinding="rangeType@defaultBean@servletRequest"
                                     styleClass="OraInstructionText" disabledBinding="PITRDisabled@defaultBean@servletRequest" />
                  <uix:messagePrompt promptBinding="DATE_LABEL@recoveryBundle@servletRequest" />
                </uix:cellFormat>

                <uix:cellFormat hAlign="left" vAlign="top" columnSpan="2" headers="">
                  <uix:messageDateField name="untilDate" shortDescBinding="dateTip@scheduleBean@servletRequest" columns="10" valueBinding="untilDate@defaultBean@servletRequest" tipBinding="dateTip@scheduleBean@servletRequest">
                    <uix:onSubmitValidater>
                      <uix:date dateStyle="medium"/>
                    </uix:onSubmitValidater>
                  </uix:messageDateField>
                </uix:cellFormat>

                <uix:cellFormat hAlign="left" vAlign="top" headers="">

                  <uix:messagePrompt promptBinding="TIME_LABEL@recoveryBundle@servletRequest" />

  		  <oem:choice
                     shortDescBinding="TIME_LABEL@recoveryBundle@servletRequest"
		     name="untilTimeHour"
		     optionsBinding="hoursListSource@defaultBean@servletRequest" 
		     selectedValueBinding="untilTimeHour@defaultBean@servletRequest" />
		  <oem:choice
                     shortDescBinding="TIME_LABEL@recoveryBundle@servletRequest"
		     name="untilTimeMinute"
		     optionsBinding="minutesListSource@defaultBean@servletRequest" 
		     selectedValueBinding="untilTimeMinute@defaultBean@servletRequest" />
                  <oem:radioButton name="untilTimeAmPm" value="am"
                                     selectedValueBinding="untilTimeAmPm@defaultBean@servletRequest"
                                     shortDescBinding="AM"
                                     textBinding="AM_LABEL@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />
                  <oem:radioButton name="untilTimeAmPm" value="pm"
                                     selectedValueBinding="untilTimeAmPm@defaultBean@servletRequest"
                                     shortDescBinding="PM"
                                     textBinding="PM_LABEL@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />
                </uix:cellFormat>

              </uix:rowLayout>
              <uix:switcher childNameBinding="DB102orHigher@defaultBean@servletRequest">
                <uix:case name="true">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:spacer width="10"/>
                        <oem:radioButton name="rangeType" value="restore_point"
                                       shortDescBinding="RESTORE_POINT@recoveryBundle@servletRequest"
                                       selectedValueBinding="rangeType@defaultBean@servletRequest"
                                       styleClass="OraInstructionText" disabledBinding="PITRDisabled@defaultBean@servletRequest" />
                      <uix:messagePrompt labeledNodeId="untilRestorePoint" promptBinding="RESTORE_POINT@recoveryBundle@servletRequest" />
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:messageLovField name="restorePointName"
                                    textBinding="restorePointName@defaultBean@servletRequest"
                                    onClick="preserveCase();startLov('restorePointName', 'ListRestorePoint')" searchDescBinding="RESTORE_POINT@recoveryBundle@servletRequest" id="untilRestorePoint"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher>

              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:spacer width="10"/>
                    <oem:radioButton name="rangeType" value="scn"
                                     shortDescBinding="SCN_LABEL@recoveryBundle@servletRequest"
                                     selectedValueBinding="rangeType@defaultBean@servletRequest"
                                     styleClass="OraInstructionText" disabledBinding="PITRDisabled@defaultBean@servletRequest" />
				  <uix:messagePrompt labeledNodeId="untilSCN" promptBinding="SCN_LABEL@recoveryBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:textInput name="untilSCN" id="untilSCN" textBinding="untilSCN@defaultBean@servletRequest" columns="10" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:spacer width="10"/>
                    <oem:radioButton name="rangeType" value="logseq"
                                     shortDescBinding="LOGSEQ_LABEL@recoveryBundle@servletRequest"
                                     selectedValueBinding="rangeType@defaultBean@servletRequest"
                                     styleClass="OraInstructionText" disabledBinding="PITRDisabled@defaultBean@servletRequest" />
                  <uix:messagePrompt labeledNodeId="untilLogSeq" promptBinding="LOGSEQ_LABEL@recoveryBundle@servletRequest" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:textInput name="untilLogSeq" id="untilLogSeq" textBinding="untilLogSeq@defaultBean@servletRequest" columns="10" />
                </uix:cellFormat>

                <uix:switcher childNameBinding="racTarget@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:messagePrompt labeledNodeId="thread" promptBinding="THREAD_LABEL@recoveryBundle@servletRequest" />
                    </uix:cellFormat>
                  </uix:case>
                </uix:switcher>

                <uix:switcher childNameBinding="racTarget@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:textInput name="thread" id="thread" textBinding="thread@defaultBean@servletRequest" columns="2" />
                    </uix:cellFormat>
                  </uix:case>
                </uix:switcher>

              </uix:rowLayout>

              <uix:switcher childNameBinding="embeddedDBConsoleMode@defaultBean@servletRequest">
                <uix:case name="false">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left" columnSpan="4" headers="">
                    <uix:spacer width="15"/>
                    <uix:messageCheckBox name="openReadOnly"
                         textBinding="OPEN_READONLY@recoveryBundle@servletRequest"
                         tipBinding="OPEN_READONLY_TIP@recoveryBundle@servletRequest"
                         shortDescBinding="OPEN_READONLY_TIP@recoveryBundle@servletRequest"
                         checkedBinding="openReadOnly@defaultBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:case>
              </uix:switcher>
            </uix:tableLayout>
          </uix:case>
          </uix:switcher>
          <%------- end point in time --------------------------------------%>
          
          <uix:styledText text="" />

          </uix:header>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@commonBundle@servletRequest"/>
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

