<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="RECOVERY_FLASHBACK@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>
        <%@ include file="/database/rec/trainMessages.jspf" %>

        <uix:styledText styleClass="OraInstructionText" textBinding="RECOVERY_FLASHBACK_DB_INTRO@recoveryBundle@servletRequest" />

            <uix:tableLayout cellSpacing="5" width="90%" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:messageRadioButton name="useFlashback"
                       textBinding="RECOVERY_FLASHBACK_DB_YES@recoveryBundle@servletRequest"
                       tipBinding="RECOVERY_FLASHBACK_DB_YES_TIP@recoveryBundle@servletRequest"
                       selectedValueBinding="useFlashback@defaultBean@servletRequest"
                       value="true" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:messageRadioButton name="useFlashback"
                       textBinding="RECOVERY_FLASHBACK_DB_NO@recoveryBundle@servletRequest"
                       tipBinding="RECOVERY_FLASHBACK_DB_NO_TIP@recoveryBundle@servletRequest"
                       selectedValueBinding="useFlashback@defaultBean@servletRequest"
                       value="false" />
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
       
            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@commonBundle@servletRequest"/>
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

