<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="ignoreRelogin" valueBinding="ignoreRelogin@defaultBean@servletRequest"/>


      <uix:pageLayout titleBinding="RECOVERY_TYPE@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>

        <uix:messages>
          <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        destTableBinding="msgUrls@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        </uix:messages>

        <uix:switcher childNameBinding="showDatabaseRecovery@defaultBean@servletRequest">
          <uix:case name="true">

            <uix:tableLayout summary="tl">
              <uix:contents>
                <uix:rowLayout>
                  <uix:contents>

                    <uix:cellFormat vAlign="top" width="60%" headers="">
                      <uix:contents>

        <!-- RG 7/31/2006: use renderedBinding instead of switcher to maintain formatting -->
        <uix:switcher childNameBinding="showDatabaseRepairAdvisor@defaultBean@servletRequest">
          <uix:case name="true">
            <uix:switcher childNameBinding="sysdba@defaultBean@servletRequest">
              <uix:case name="true">
                <uix:header textBinding="DATABASE_REPAIR_ADVISOR_HEADER@recoveryBundle@servletRequest">
                  <uix:tableLayout cellSpacing="5" width="100%" summary="tl">
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="left" headers="">
                        <uix:styledText
                            textBinding="DATABASE_REPAIR_ADVISOR_INTRO@recoveryBundle@servletRequest"
                            renderedBinding="failuresDetected@defaultBean@servletRequest"
                            styleClass="OraInstructionText" />
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="left" headers="">
                        <uix:styledText
                            textBinding="NO_FAILURES_DETECTED@recoveryBundle@servletRequest"
                            renderedBinding="noFailuresDetected@defaultBean@servletRequest"
                            styleClass="OraInstructionText"/>
                      </uix:cellFormat>
                      <uix:cellFormat hAlign="right" headers="">
                        <uix:submitButton
                            textBinding="DATABASE_REPAIR_BUTTON@recoveryBundle@servletRequest"
                            disabledBinding="noFailuresDetected@defaultBean@servletRequest"
                            formName="foo" name="event" value="databaseRepair" shortDescBinding="DATABASE_REPAIR_BUTTON@recoveryBundle@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
<%--
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="left">
                        <uix:spacer width="10"/>
                        <uix:styledText
                            textBinding="DATABASE_REPAIR_ADVISOR_CONTENT@recoveryBundle@servletRequest"
                            renderedBinding="failuresDetected@defaultBean@servletRequest"
                            styleClass="OraInstructionText" />
                      </uix:cellFormat>
                    </uix:rowLayout>
--%>
                  </uix:tableLayout>

                  <uix:switcher childNameBinding="failuresDetected@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:tableLayout cellSpacing="5" width="100%" summary="tl">
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="left" wrappingDisabled="true" headers="">
                            <uix:labeledFieldLayout labelWidth="25%">
                              <uix:contents>
                                <uix:messagePrompt promptBinding="IDR_FAILURES_DETECTED@recoveryBundle@servletRequest"/>
                                <uix:rowLayout>
                                  <uix:styledText
                                      styleClass="OraDataText"
                                      textBinding="IDR_FAILURE_SUMMARY_CRITICAL@recoveryBundle@servletRequest"/>
                                  <uix:spacer width="5"/>
                                  <uix:link
                                      styleClass="OraDataText"
                                      destinationBinding="failureSummaryCriticalDest@defaultBean@servletRequest"
                                      textBinding="failureSummaryCritical@defaultBean@servletRequest"/>
                                  <uix:spacer width="10"/>
                                  <uix:styledText
                                      styleClass="OraDataText"
                                      textBinding="IDR_FAILURE_SUMMARY_HIGH@recoveryBundle@servletRequest"/>
                                  <uix:spacer width="5"/>
                                  <uix:link
                                      styleClass="OraDataText"
                                      destinationBinding="failureSummaryHighDest@defaultBean@servletRequest"
                                      textBinding="failureSummaryHigh@defaultBean@servletRequest"/>
                                  <uix:spacer width="10"/>
                                  <uix:styledText
                                      styleClass="OraDataText"
                                      textBinding="IDR_FAILURE_SUMMARY_LOW@recoveryBundle@servletRequest"/>
                                  <uix:spacer width="5"/>
                                  <uix:link
                                      styleClass="OraDataText"
                                      destinationBinding="failureSummaryLowDest@defaultBean@servletRequest"
                                      textBinding="failureSummaryLow@defaultBean@servletRequest"/>
                                </uix:rowLayout>
                                <uix:messagePrompt
                                    renderedBinding="showFailureDescription@defaultBean@servletRequest"
                                    promptBinding="IDR_CRITICAL_FAILURE_DESCRIPTION@recoveryBundle@servletRequest"/>
                                <uix:styledText
                                    styleClass="OraDataText"
                                    renderedBinding="showFailureDescription@defaultBean@servletRequest"
                                    textBinding="failureDescription@defaultBean@servletRequest"/>
                              </uix:contents>
                            </uix:labeledFieldLayout>
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:tableLayout>
                    </uix:case>
                  </uix:switcher>

                </uix:header>
              </uix:case>
              <uix:case name="false">
                <uix:header textBinding="DATABASE_REPAIR_ADVISOR_HEADER@recoveryBundle@servletRequest">
                  <uix:styledText
                      textBinding="DATABASE_REPAIR_ADVISOR_OVERVIEW@recoveryBundle@servletRequest"
                      styleClass="OraInstructionText"/>
                </uix:header>
              </uix:case>
            </uix:switcher>
          </uix:case>
        </uix:switcher> <!-- end of showDatabaseRepairAdvisor -->

            <uix:header textBinding="CUSTOMIZED_REPAIR@recoveryBundle@servletRequest">
            <uix:tableLayout cellSpacing="5" width="100%" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" wrappingDisabled="true" headers="">
                  <uix:styledText
                      textBinding="OBJECT_TYPE@recoveryBundle@servletRequest"
                      styleClass="OraInstructionText"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:choice name="objectType"
                              onChange="submitForm('foo', true, {'event':'switchObject'})"
                              shortDescBinding="OBJECT_TYPE@recoveryBundle@servletRequest"
                              selectedValueBinding="objectType@defaultBean@servletRequest">
                    <uix:contents childDataBinding="allObjectTypes@defaultBean@servletRequest">
                      <uix:option textBinding="text" valueBinding="value"/>
                    </uix:contents>
                  </uix:choice>
                </uix:cellFormat>
                <uix:cellFormat hAlign="right" headers="">
                  <uix:submitButton
                      textBinding="PERFORM_RECOVERY_BUTTON@recoveryBundle@servletRequest"
                      formName="foo" name="event" value="recoverObject" shortDescBinding="PERFORM_RECOVERY_BUTTON@recoveryBundle@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

        <uix:switcher childNameBinding="objectType@defaultBean@servletRequest"
                      defaultCase="non-archivelogs">
          <uix:case name="database">
            <uix:switcher childNameBinding="alMode@defaultBean@servletRequest">
              <uix:case name="ARCHIVELOG">
                <uix:tableLayout cellSpacing="5" width="100%" summary="tl">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" vAlign="top" rowSpan="5" wrappingDisabled="true" headers="">
                      <uix:messagePrompt promptBinding="OPERATION_TYPE@recoveryBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left" vAlign="top" rowSpan="5" headers="">
                      <uix:stackLayout>
                        <uix:messageRadioButton name="DBOperationType"
                             shortDescBinding="OPERATION_TYPE@recoveryBundle@servletRequest"
                             textBinding="RECOVER_WDB_OP1@recoveryBundle@servletRequest"
                             selectedValueBinding="DBOperationType@defaultBean@servletRequest" 
                             tipBinding="wholeDBOp1Tip@defaultBean@servletRequest"      
                             value="restore_recover"/>
                        <uix:messageRadioButton name="DBOperationType"
                             shortDescBinding="OPERATION_TYPE@recoveryBundle@servletRequest"
                             textBinding="RECOVER_WDB_OP2@recoveryBundle@servletRequest"
                             selectedValueBinding="DBOperationType@defaultBean@servletRequest" 
                             tipBinding="RECOVER_WDB_OP2_TIP@recoveryBundle@servletRequest"      
                             value="restore_only"/>
                        <uix:messageRadioButton name="DBOperationType"
                             shortDescBinding="OPERATION_TYPE@recoveryBundle@servletRequest"
                             textBinding="RECOVER_WDB_OP3@recoveryBundle@servletRequest"
                             selectedValueBinding="DBOperationType@defaultBean@servletRequest" 
                             value="recover_only"/>
                      </uix:stackLayout>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:case>
              <uix:case name="NOARCHIVELOG">
                <uix:tableLayout cellSpacing="5" width="100%" summary="tl">
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" vAlign="top" rowSpan="5" wrappingDisabled="true" headers="">
                      <uix:messagePrompt promptBinding="OPERATION_TYPE@recoveryBundle@servletRequest"/>
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:messageRadioButton name="DBOperationType"
                           shortDescBinding="OPERATION_TYPE@recoveryBundle@servletRequest"
                           textBinding="RECOVER_WDB_OP2@recoveryBundle@servletRequest"
                           selectedValueBinding="DBOperationType@defaultBean@servletRequest" 
                           tipBinding="RECOVER_WDB_OP2_TIP@recoveryBundle@servletRequest"      
                           value="restore_only"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:case>
            </uix:switcher>
          </uix:case>
          <uix:case name="archivelogs">
            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" wrappingDisabled="true" headers="">
                  <uix:messagePrompt promptBinding="OPERATION_TYPE@recoveryBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:styledText textBinding="RECOVER_LOG_OP2@recoveryBundle@servletRequest" styleClass="OraDataText"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
              <uix:cellFormat/>
                <uix:cellFormat headers="">
                  <uix:styledText textBinding="RECOVER_LOG_OP2_TIP@recoveryBundle@servletRequest" styleClass="OraInlineInfoText"/>
                </uix:cellFormat>
              </uix:rowLayout>  
            </uix:tableLayout>
          </uix:case>
          <uix:case name="transactions">
            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" wrappingDisabled="true" headers="">
                  <uix:messagePrompt promptBinding="OPERATION_TYPE@recoveryBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:styledText textBinding="FLASHBACK_TRANSACTION@recoveryBundle@servletRequest" styleClass="OraDataText"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
              <uix:cellFormat/>
                <uix:cellFormat headers="">
                  <uix:styledText textBinding="FLASHBACK_TRANSACTION_TIP@recoveryBundle@servletRequest" styleClass="OraInlineInfoText"/>
                </uix:cellFormat>
              </uix:rowLayout>  
            </uix:tableLayout>
          </uix:case>
          

          <uix:case name="non-archivelogs">
            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" rowSpan="5" wrappingDisabled="true" headers="">
                  <uix:messagePrompt promptBinding="OPERATION_TYPE@recoveryBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" vAlign="top" rowSpan="5" headers="">
                  <uix:stackLayout>
                      <uix:contents childDataBinding="allOperationTypes@defaultBean@servletRequest">
                        <uix:messageRadioButton name="operationType"
                             shortDescBinding="OPERATION_TYPE@recoveryBundle@servletRequest"
                             textBinding="text"
                             valueBinding="value"
                             tipBinding="tip"
                                selectedValueBinding="operationType@defaultBean@servletRequest" />
                      </uix:contents>
                  </uix:stackLayout>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:case>
        </uix:switcher>

          </uix:header>

      <!-- Encryption -->
      <%@ include file="recoveryEncrypt.jspf" %>
      
          <uix:header textBinding="HOST_CREDENTIALS@commonBundle@servletRequest">
            <uix:rawText>
              <a name="HOSTCRED" id="HOSTCRED"/>
            </uix:rawText>
            <uix:styledText styleClass="OraInstructionText" textBinding="OS_CREDENTIALS_RECOVERY@commonBundle@servletRequest" />
                <uix:contents>
                  <%@ include file="/credentials.jspf"%>
                </uix:contents>
          </uix:header>
        </uix:contents>
     </uix:cellFormat>

     <uix:cellFormat vAlign="top" headers="">
        <uix:contents>
        <uix:spacer height="40"/>
          <uix:contentContainer textBinding="WIZARD_OVERVIEW_TITLE@recoveryBundle@servletRequest" width="100%" icon="/em/images/infoicon_active.gif">
            <uix:contents>
              <uix:switcher childNameBinding="DB11orHigher@defaultBean@servletRequest">
                <uix:case name="true">
                  <uix:bulletedList>
                    <uix:styledText styleClass="OraInstructionText"
                         textBinding="WIZARD_OVERVIEW_B0@recoveryBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionText"
                         textBinding="WIZARD_OVERVIEW_B1@recoveryBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionText"
                         textBinding="WIZARD_OVERVIEW_B2@recoveryBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionText"
                         textBinding="WIZARD_OVERVIEW_B3@recoveryBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionText"
                         textBinding="WIZARD_OVERVIEW_B4@recoveryBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionText"
                         textBinding="WIZARD_OVERVIEW_B5@recoveryBundle@servletRequest"/>
                  </uix:bulletedList>
                </uix:case>
                <uix:case name="false">
                  <uix:bulletedList>
                    <uix:styledText styleClass="OraInstructionText"
                         textBinding="WIZARD_OVERVIEW_B1@recoveryBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionText"
                         textBinding="WIZARD_OVERVIEW_B2@recoveryBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionText"
                         textBinding="WIZARD_OVERVIEW_B3@recoveryBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionText"
                         textBinding="WIZARD_OVERVIEW_B4@recoveryBundle@servletRequest"/>
                    <uix:styledText styleClass="OraInstructionText"
                         textBinding="WIZARD_OVERVIEW_B5@recoveryBundle@servletRequest"/>
                  </uix:bulletedList>
                </uix:case>
              </uix:switcher>
            </uix:contents>
          </uix:contentContainer>
        </uix:contents>
     </uix:cellFormat>

          </uix:contents>
         </uix:rowLayout>
        </uix:contents>
      </uix:tableLayout>

        </uix:case>
        <uix:case name="false">
          <uix:tableLayout cellSpacing="10"  summary="tl">
            <uix:rowLayout>
              <uix:styledText textBinding="UNABLE_CONNECT_DB_OPEN@recoveryBundle@servletRequest" styleClass="OraInstructionText" />
            </uix:rowLayout>
            <uix:rowLayout>
              <uix:cellFormat hAlign="right" headers="">
                <uix:submitButton textBinding="OK@commonBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="OK@commonBundle@servletRequest"/>
              </uix:cellFormat>
            </uix:rowLayout>
          </uix:tableLayout>
        </uix:case>
      </uix:switcher>


      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

