<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="RECOVERY_RANGE@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>
        <%@ include file="/database/rec/trainMessages.jspf" %>

      <uix:stackLayout>

	    <uix:spacer height="10" />
            <uix:styledText styleClass="OraInstructionText" textBinding="RANGE_INTRO@recoveryBundle@servletRequest" />

            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:spacer width="10"/>
                  <oem:radioButton name="rangeType" value="time"
                                     selectedValueBinding="rangeType@defaultBean@servletRequest"
                                     textBinding="BY_TIME@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />
                  <uix:spacer width="10"/>
                </uix:cellFormat>
	      </uix:rowLayout>
	    </uix:tableLayout>

            <uix:tableLayout cellSpacing="5" summary="tl">
	      <uix:rowLayout>

	        <uix:cellFormat hAlign="left" headers="">
		  <uix:spacer width="40"/>
		</uix:cellFormat>

		<uix:cellFormat headers="">
		<uix:tableLayout cellSpacing="5" summary="tl">
		<uix:rowLayout>
                <uix:cellFormat hAlign="right" vAlign="top" headers="">
                    <uix:messagePrompt promptBinding="FROM_DATE_LABEL@recoveryBundle@servletRequest" />
		</uix:cellFormat>

		<uix:cellFormat hAlign="left" vAlign="top" headers="">
                  <uix:messageDateField shortDescBinding="dateTip@scheduleBean@servletRequest" name="fromDate" columns="10" valueBinding="fromDate@defaultBean@servletRequest" tipBinding="dateTip@scheduleBean@servletRequest">
                    <uix:onSubmitValidater>
                      <uix:date dateStyle="medium"/>
                    </uix:onSubmitValidater>
                  </uix:messageDateField>
		</uix:cellFormat>

		<uix:cellFormat headers=""> <uix:spacer width="10"/> </uix:cellFormat>

		<uix:cellFormat hAlign="left" vAlign="top" columnSpan="5" headers="">
                  <uix:messagePrompt promptBinding="TIME_LABEL@recoveryBundle@servletRequest" />

		<oem:choice
		     name="fromTimeHour"
		     optionsBinding="hoursListSource@defaultBean@servletRequest" 
                     shortDescBinding="TIME_LABEL@recoveryBundle@servletRequest"
		     selectedValueBinding="fromTimeHour@defaultBean@servletRequest" />
		<oem:choice
		     name="fromTimeMinute"
                     shortDescBinding="TIME_LABEL@recoveryBundle@servletRequest"
		     optionsBinding="minutesListSource@defaultBean@servletRequest" 
		     selectedValueBinding="fromTimeMinute@defaultBean@servletRequest" />
                <oem:radioButton name="fromTimeAmPm" value="am"
                                     selectedValueBinding="fromTimeAmPm@defaultBean@servletRequest"
                                     textBinding="AM_LABEL@recoveryBundle@servletRequest" 
                                     styleClass="OraInstructionText" />
                <oem:radioButton name="fromTimeAmPm" value="pm"
                                     selectedValueBinding="fromTimeAmPm@defaultBean@servletRequest"
                                     textBinding="PM_LABEL@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />

                </uix:cellFormat>
              </uix:rowLayout>
	      </uix:tableLayout>

	     </uix:cellFormat>
	    </uix:rowLayout>
	   </uix:tableLayout>

            <uix:tableLayout cellSpacing="5" summary="tl">
	      <uix:rowLayout>

	        <uix:cellFormat hAlign="left" headers="">
		  <uix:spacer width="40"/>
		</uix:cellFormat>

		<uix:cellFormat headers="">
		<uix:tableLayout cellSpacing="5" summary="tl">
                <uix:rowLayout>

                <uix:cellFormat hAlign="right" headers="">
		  <uix:messagePrompt promptBinding="UNTIL_LABEL@recoveryBundle@servletRequest" />
                </uix:cellFormat>

		<uix:cellFormat hAlign="left" headers="">
                <oem:radioButton name="useUntilTimeRadio" value="false"
                                     selectedValueBinding="useUntilTimeRadio@defaultBean@servletRequest"
                                     textBinding="CURRENT_TIME@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />
		</uix:cellFormat>
	       </uix:rowLayout>

	       <uix:rowLayout>

	        <uix:cellFormat headers=""> <uix:spacer width="5"/> </uix:cellFormat>

		<uix:cellFormat hAlign="left" columnSpan="2" headers="">
                <oem:radioButton name="useUntilTimeRadio" value="true"
                                     selectedValueBinding="useUntilTimeRadio@defaultBean@servletRequest"
                                     textBinding="SPECIFIED_DATE@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />
		</uix:cellFormat>
	       </uix:rowLayout>

               <uix:rowLayout>

		<uix:cellFormat headers=""> <uix:spacer width="5"/> </uix:cellFormat>

                <uix:cellFormat hAlign="right" vAlign="top" headers="">
                    <uix:messagePrompt promptBinding="DATE_LABEL@recoveryBundle@servletRequest" />
		</uix:cellFormat>

                <uix:cellFormat hAlign="left" vAlign="top" headers="">
                  <uix:messageDateField name="untilDate" shortDescBinding="dateTip@scheduleBean@servletRequest" columns="10" valueBinding="untilDate@defaultBean@servletRequest" tipBinding="dateTip@scheduleBean@servletRequest">
                    <uix:onSubmitValidater>
                      <uix:date dateStyle="medium"/>
                    </uix:onSubmitValidater>
                  </uix:messageDateField>
                  <uix:spacer width="10"/>
                </uix:cellFormat>

		<uix:cellFormat headers=""> <uix:spacer width="10"/> </uix:cellFormat>

		<uix:cellFormat hAlign="right" vAlign="top" headers="">
                  <uix:messagePrompt promptBinding="TIME_LABEL@recoveryBundle@servletRequest" />


		<oem:choice
		     name="untilTimeHour"
                     shortDescBinding="TIME_LABEL@recoveryBundle@servletRequest"
		     optionsBinding="hoursListSource@defaultBean@servletRequest" 
		     selectedValueBinding="untilTimeHour@defaultBean@servletRequest" />
		<oem:choice
		     name="untilTimeMinute"
                     shortDescBinding="TIME_LABEL@recoveryBundle@servletRequest"
		     optionsBinding="minutesListSource@defaultBean@servletRequest" 
		     selectedValueBinding="untilTimeMinute@defaultBean@servletRequest" />
                <oem:radioButton name="untilTimeAmPm" value="am"
                                     selectedValueBinding="untilTimeAmPm@defaultBean@servletRequest"
                                     textBinding="AM_LABEL@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />
                <oem:radioButton name="untilTimeAmPm" value="pm"
                                     selectedValueBinding="untilTimeAmPm@defaultBean@servletRequest"
                                     textBinding="PM_LABEL@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />
                </uix:cellFormat>
	     </uix:rowLayout>


             </uix:tableLayout>
	     </uix:cellFormat>
	    </uix:rowLayout>
	   </uix:tableLayout>

	   <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:spacer width="10"/>
                  <oem:radioButton name="rangeType" value="scn"
                                     selectedValueBinding="rangeType@defaultBean@servletRequest"
                                     textBinding="BY_SCN@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />
                  <uix:spacer width="10"/>
                </uix:cellFormat>
	      </uix:rowLayout>
           </uix:tableLayout>

	   <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>

	        <uix:cellFormat hAlign="left" headers="">
		  <uix:spacer width="40"/>
		</uix:cellFormat>

		<uix:cellFormat headers="">
		<uix:tableLayout cellSpacing="5" summary="tl">
		<uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:messagePrompt labeledNodeId="fromSCN" promptBinding="FROM_LABEL@recoveryBundle@servletRequest" />
                </uix:cellFormat>

                <uix:cellFormat hAlign="left" headers="">
                  <uix:textInput id="fromSCN" name="fromSCN" textBinding="fromSCN@defaultBean@servletRequest" columns="10" />
                </uix:cellFormat>
              </uix:rowLayout>

              <uix:rowLayout>


                <uix:cellFormat hAlign="left" headers="">
                    <uix:messagePrompt labeledNodeId="untilSCN" promptBinding="UNTIL_LABEL@recoveryBundle@servletRequest" />
                </uix:cellFormat>

		<uix:cellFormat hAlign="left" headers="">
                <oem:radioButton name="useUntilScnRadio" value="false"
                                     selectedValueBinding="useUntilScnRadio@defaultBean@servletRequest"
                                     textBinding="CURRENT_SCN@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />
		</uix:cellFormat>
		</uix:rowLayout>

		<uix:rowLayout>
	        <uix:cellFormat headers=""> <uix:spacer width="5"/> </uix:cellFormat>
		<uix:cellFormat hAlign="left" headers="">
                  <oem:radioButton name="useUntilScnRadio" value="true"
                                     selectedValueBinding="useUntilScnRadio@defaultBean@servletRequest"
                                     textBinding="SPECIFIED_SCN@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />
		</uix:cellFormat>
		</uix:rowLayout>

		<uix:rowLayout>
	        <uix:cellFormat headers=""> <uix:spacer width="40"/> </uix:cellFormat>

                <uix:cellFormat hAlign="left" headers="">
		  <uix:spacer width="20"/>
                  <uix:textInput name="untilSCN" id="untilSCN" textBinding="untilSCN@defaultBean@servletRequest" columns="10" />
                </uix:cellFormat>
              </uix:rowLayout>
	    </uix:tableLayout>

	     </uix:cellFormat>
	    </uix:rowLayout>
	   </uix:tableLayout>

	    <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:spacer width="10"/>
                  <oem:radioButton name="rangeType" value="logseq"
                                     selectedValueBinding="rangeType@defaultBean@servletRequest"
                                     textBinding="BY_LOGSEQ@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />
                  <uix:spacer width="10"/>
                </uix:cellFormat>
	      </uix:rowLayout>
           </uix:tableLayout>

	   <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>

	        <uix:cellFormat hAlign="left" headers="">
		  <uix:spacer width="40"/>
		</uix:cellFormat>

		<uix:cellFormat headers="">
		<uix:tableLayout cellSpacing="5" summary="tl">
		<uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:messagePrompt labeledNodeId="fromLogSeq" promptBinding="FROM_LABEL@recoveryBundle@servletRequest" />
                </uix:cellFormat>

                <uix:cellFormat hAlign="left" headers="">
                  <uix:textInput id="fromLogSeq" name="fromLogSeq" textBinding="fromLogSeq@defaultBean@servletRequest" columns="10" />
                </uix:cellFormat>
              </uix:rowLayout>

                <uix:switcher childNameBinding="racTarget@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:cellFormat hAlign="right" headers="">
                      <uix:messagePrompt labeledNodeId="thread" promptBinding="THREAD_LABEL@recoveryBundle@servletRequest" />
                    </uix:cellFormat>
                  </uix:case>
                </uix:switcher>
                <uix:switcher childNameBinding="racTarget@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:cellFormat hAlign="left" headers="">
                      <uix:textInput name="thread" id="thread" textBinding="thread@defaultBean@servletRequest" columns="2" />
                    </uix:cellFormat>
                  </uix:case>
                </uix:switcher>

              <uix:rowLayout>


                <uix:cellFormat hAlign="left" headers="">
                    <uix:messagePrompt labeledNodeId="untilLogSeq" promptBinding="UNTIL_LABEL@recoveryBundle@servletRequest" />
                </uix:cellFormat>

		<uix:cellFormat hAlign="left" headers="">
                <oem:radioButton name="useUntilSeqRadio" value="false"
                                     selectedValueBinding="useUntilSeqRadio@defaultBean@servletRequest"
                                     textBinding="CURRENT_SEQ@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />
		</uix:cellFormat>
		</uix:rowLayout>

		<uix:rowLayout>
	        <uix:cellFormat headers=""> <uix:spacer width="5"/> </uix:cellFormat>
		<uix:cellFormat hAlign="left" headers="">
                  <oem:radioButton name="useUntilSeqRadio" value="true"
                                     selectedValueBinding="useUntilSeqRadio@defaultBean@servletRequest"
                                     textBinding="SPECIFIED_SEQ@recoveryBundle@servletRequest"
                                     styleClass="OraInstructionText" />
		</uix:cellFormat>
		</uix:rowLayout>

		<uix:rowLayout>
	        <uix:cellFormat headers=""> <uix:spacer width="40"/> </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
		  <uix:spacer width="20"/>
                  <uix:textInput id="untilLogSeq" name="untilLogSeq" textBinding="untilLogSeq@defaultBean@servletRequest" columns="10" />
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

	     </uix:cellFormat>
	    </uix:rowLayout>
	   </uix:tableLayout>


	</uix:stackLayout>


            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@commonBundle@servletRequest"/>
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

