<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="ignoreRelogin" valueBinding="ignoreRelogin@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="renamePageTitle@defaultBean@servletRequest">
    
        <%@ include file="/database/global.jspf" %>
        <%@ include file="/database/rec/trainMessages.jspf" %>

	   <uix:spacer height="10"/>
            <uix:switcher childNameBinding="operationType@defaultBean@servletRequest">
              <uix:case name="restore_recover">
	       <uix:tableLayout summary="tl"> <uix:rowLayout> <uix:cellFormat hAlign="left" headers="">
                <uix:styledText styleClass="OraInstructionText" textBinding="RECOVERY_RENAME_INTRO@recoveryBundle@servletRequest" />
	       </uix:cellFormat> </uix:rowLayout> </uix:tableLayout>
              </uix:case>
              <uix:case name="restore_only">
	       <uix:tableLayout summary="tl"> <uix:rowLayout> <uix:cellFormat hAlign="left" headers="">
                <uix:styledText styleClass="OraInstructionText" textBinding="RESTORE_RENAME_INTRO@recoveryBundle@servletRequest" />
	       </uix:cellFormat> </uix:rowLayout> </uix:tableLayout>
              </uix:case>
            </uix:switcher>

            <uix:tableLayout cellSpacing="5" width="90%" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" columnSpan="2" headers="">
                    <uix:messageRadioButton name="renameType" value="NO"
                         selectedValueBinding="renameType@defaultBean@servletRequest"
                         textBinding="RENAME_NO@recoveryBundle@servletRequest"
                         onClick="submitForm('foo', true, {'event':'changeRenameType'})"
                         styleClass="OraInstructionText" />
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" columnSpan="2" headers="">
                    <uix:messageRadioButton name="renameType" value="COMMON"
                         selectedValueBinding="renameType@defaultBean@servletRequest"
                         textBinding="RENAME_YES_COMMON@recoveryBundle@servletRequest"
                         tipBinding="RENAME_TIP@recoveryBundle@servletRequest"
                         onClick="submitForm('foo', true, {'event':'changeRenameType'})"
                         styleClass="OraInstructionText" />
                </uix:cellFormat>
              </uix:rowLayout>
              
              <%----  show/hide of the option fileds ---------------%>
              <uix:switcher childNameBinding="renameType@defaultBean@servletRequest">
              <uix:case name="COMMON">
              <uix:rowLayout>
              <uix:tableLayout cellSpacing="10" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right"  headers="">
                  <uix:messagePrompt labeledNodeId="commonDir" promptBinding="RENAME_COMMON_DIR@recoveryBundle@servletRequest"/>
                </uix:cellFormat>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:stackLayout>
                  <uix:textInput name="commonDir" id="commonDir" columns="60"
                       textBinding="commonDir@defaultBean@servletRequest" />
                <uix:messageText messageType="error" messageBinding="(RENAME_COMMON_DIR@recoveryBundle@servletRequest)@errors@servletRequest"/>
                  </uix:stackLayout>
                </uix:cellFormat>
              </uix:rowLayout>
              </uix:tableLayout>
              </uix:rowLayout>
              </uix:case>
              </uix:switcher>
              <%--- end of show/hide ---%>

              <uix:switcher childNameBinding="DB10orHigher@defaultBean@servletRequest">
                <uix:case name="true">
                  <uix:switcher childNameBinding="useOmf@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left" columnSpan="2" headers="">
                            <oem:radioButton name="renameType" value="OMF"
                                 selectedValueBinding="renameType@defaultBean@servletRequest"
                                 textBinding="RENAME_YES_OMF@recoveryBundle@servletRequest"
                                 styleClass="OraInstructionText" />
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>
                </uix:case>
              </uix:switcher>
              <uix:switcher childNameBinding="DB10orHigher@defaultBean@servletRequest">
                <uix:case name="true">
                  <uix:switcher childNameBinding="useOmf@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right"  headers="">
                          <uix:messagePrompt labeledNodeId="omfLocation" promptBinding="RENAME_OMF_LOC@recoveryBundle@servletRequest"/>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" headers="">
                          <uix:textInput name="omfLocation" 
                               id="omfLocation"
                               textBinding="omfLocation@defaultBean@servletRequest" />
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>
                </uix:case>
              </uix:switcher>

              <uix:rowLayout>
              </uix:rowLayout>

            </uix:tableLayout>

            <uix:switcher childNameBinding="operationType@defaultBean@servletRequest">
              <uix:case name="restore_only">
	       <uix:tableLayout summary="tl"> <uix:rowLayout> <uix:cellFormat hAlign="left" headers="">
                <uix:messageCheckBox name="updateControlfile"
                     textBinding="UPDATE_CONTROLFILE@recoveryBundle@servletRequest"
                     shortDescBinding="UPDATE_CONTROLFILE_TIP@recoveryBundle@servletRequest"
                     tipBinding="UPDATE_CONTROLFILE_TIP@recoveryBundle@servletRequest"
                     checkedBinding="updateControlfile@defaultBean@servletRequest" />
	       </uix:cellFormat> </uix:rowLayout> </uix:tableLayout>
              </uix:case>
            </uix:switcher>


            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@commonBundle@servletRequest"/>
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
            </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

