<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="ignoreRelogin" valueBinding="ignoreRelogin@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="schedulePageTitle@defaultBean@servletRequest">
        <%@ include file="/database/global.jspf" %>
        <%@ include file="/database/rec/trainMessages.jspf" %>

          <uix:spacer height="10"/>
          <uix:styledText textBinding="IMMEDIATE_INTRO@recoveryBundle@servletRequest" styleClass="OraInstructionText"/>
          <uix:spacer height="10"/>
          <uix:labeledFieldLayout width="75%">
            <uix:messagePrompt required="yes"
                 labeledNodeId="jobName"
                 promptBinding="JOB_NAME@commonBundle@servletRequest"/>
            <uix:textInput name="jobName"
                 id="jobName"
                 styleClass="OraInstructionText"
                 textBinding="jobName@defaultBean@servletRequest" />
            <uix:messagePrompt 
                 labeledNodeId="jobDescription"
                 promptBinding="JOB_DESC@commonBundle@servletRequest"/>
            <uix:textInput name="jobDescription"
                 id="jobDescription"
                 styleClass="OraInstructionText"
                 textBinding="jobDescription@defaultBean@servletRequest" />
          </uix:labeledFieldLayout>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@commonBundle@servletRequest"/>
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

