<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

    <%@ include file="/oemTitle.jspf" %>
    <uix:body>
    <uix:pageLayout titleBinding="RECOVERY_RESTORE_RESULT@recoveryBundle@servletRequest">
      <%@ include file="/database/global.jspf" %>
      
      <uix:messages>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
      </uix:messages>


      <uix:contents>

          <uix:switcher childNameBinding="showJob@defaultBean@servletRequest">
            <uix:case name="true">
              <uix:stackLayout>
                <uix:contents>
                  <uix:styledText styleClass="OraInstructionText" labeledNodeId="errMsg" textBinding="JOB_SUBMISSION_FAILED@recoveryBundle@servletRequest"/>
                </uix:contents>
              </uix:stackLayout>
            </uix:case>
            <uix:case name="false">
              <uix:tableLayout cellSpacing="10" summary="tl">
                <uix:rowLayout>
                <uix:styledText styleClass="OraInstructionText" textBinding="pageIntro@servletRequest"/>
                </uix:rowLayout>
                <uix:rowLayout>
                  <uix:cellFormat hAlign="left" width="150" headers="">
                    <uix:textInput name="errMsg" id="errMsg" textBinding="errMsg@defaultBean@servletRequest" readOnly="true" columns="120" rows="15"/>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:case>
          </uix:switcher>


        <uix:contentFooter>
          <uix:contents>
            <uix:pageButtonBar>
              <uix:button textBinding="OK@recoveryBundle@servletRequest" destinationBinding="cancelURL@servletRequest" shortDescBinding="OK@recoveryBundle@servletRequest"/>
            </uix:pageButtonBar>
          </uix:contents>
        </uix:contentFooter>

      </uix:contents>
    </uix:pageLayout>
    </uix:body>
</uix:document> 
</uix:renderingContext> 
