<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/> 
<uix:document> 

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="ignoreRelogin" valueBinding="ignoreRelogin@defaultBean@servletRequest"/>

    <uix:pageLayout titleBinding="RECOVERY_RESTORE_RESULT@recoveryBundle@servletRequest">
      <%@ include file="/database/global.jspf" %>

      <uix:messages>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
      </uix:messages>
      <uix:contents>


          <uix:switcher childNameBinding="showJob@defaultBean@servletRequest">
            <uix:case name="true">
              <uix:stackLayout>
                <uix:contents>
                  <uix:styledText styleClass="OraInstructionText" textBinding="JOB_SUCCESS@recoveryBundle@servletRequest"/>
                  <uix:styledText styleClass="OraInstructionText" textBinding="VIEW_JOB@recoveryBundle@servletRequest"/>
                </uix:contents>
              </uix:stackLayout>
            </uix:case>
            <uix:case name="false">
                <uix:tableLayout cellSpacing="5" summary="tl">
                  <uix:rowLayout>
                    <uix:styledText styleClass="OraInstructionText" textBinding="pageIntro@servletRequest"/>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="left" width="150" headers="">
                      <uix:textInput name="errMsg" id="errMsg" textBinding="errMsg@defaultBean@servletRequest" readOnly="true" columns="120" rows="15"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
            </uix:case>
          </uix:switcher>

        <uix:contentFooter>
          <uix:contents>
            <uix:pageButtonBar>
              <uix:switcher childNameBinding="showJob@defaultBean@servletRequest">
                <uix:case name="true">
                  <!-- Bug 6021348 fix - start -->
                  <!-- uix:button textBinding="JOBS@recoveryBundle@servletRequest" destinationBinding="jobSummary@defaultBean@servletRequest"/ -->
		          <uix:submitButton textBinding="JOBS@recoveryBundle@servletRequest" formName="foo" name="event" value="viewJob"  shortDescBinding="JOBS@recoveryBundle@servletRequest"/>
		        <!-- Bug 6021348 fix - end -->
                </uix:case>

                <uix:case name="false">
                  <uix:switcher childNameBinding="dbStatus@defaultBean@servletRequest">
                    <uix:case name="MOUNTED">
                      <uix:switcher childNameBinding="openResetlogsRequired@defaultBean@servletRequest">
                        <uix:case name="true">
                          <uix:submitButton textBinding="OPEN_DB@recoveryBundle@servletRequest"  name="event" value="openDbResetlogs" shortDescBinding="OPEN_DB@recoveryBundle@servletRequest"/>
                        </uix:case>
                        <uix:case name="false">
                          <uix:submitButton textBinding="OPEN_DB@recoveryBundle@servletRequest"  name="event" value="openDb" shortDescBinding="OPEN_DB@recoveryBundle@servletRequest"/>
                        </uix:case>
                      </uix:switcher>
                    </uix:case>
                  </uix:switcher>
                </uix:case>
              </uix:switcher>
            <uix:button textBinding="OK@recoveryBundle@servletRequest" destinationBinding="cancelURL@servletRequest" shortDescBinding="OK@recoveryBundle@servletRequest"/>
          </uix:pageButtonBar>
        </uix:contents>
      </uix:contentFooter>

      </uix:contents>
    </uix:pageLayout>

    </db:form>
    </uix:body>
</uix:document> 
</uix:renderingContext> 
