<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="ignoreRelogin" valueBinding="ignoreRelogin@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="reviewPageTitle@defaultBean@servletRequest">
        <%@ include file="/database/global.jspf" %>
        <%@ include file="/database/rec/trainMessages.jspf" %>

        <uix:switcher childNameBinding="objectType@defaultBean@pageContext">
          <uix:case name="spfile">
            <uix:formValue name="recoverSpfile" value="true"/>
          </uix:case>
        </uix:switcher>

        <uix:spacer height="10"/>
        <uix:styledText textBinding="SUMMARY_INTRO@recoveryBundle@servletRequest" styleClass="OraInstructionText"/>
        <uix:spacer height="10"/>

        <uix:header textBinding="OPTIONS@recoveryBundle@servletRequest">
          <uix:labeledFieldLayout width="75%">
            <uix:contents childDataBinding="summary@defaultBean@servletRequest">
              <uix:messageStyledText styleClass="OraInstructionTextStrong"
                   vAlign="top"
                   promptBinding="name"
                   textBinding="value"/>
            </uix:contents>
          </uix:labeledFieldLayout>
        </uix:header>

        <uix:switcher childNameBinding="objectType@defaultBean@servletRequest">
          <uix:case name="tablespaces">
            <uix:header textBinding="TABLESPACES@recoveryBundle@servletRequest">
              <uix:tableLayout cellSpacing="5" summary="tl">
                  <uix:cellFormat hAlign="left" width="150">
                  <uix:textInput name="tablespacesSummary"
                       shortDescBinding="TABLESPACES@recoveryBundle@servletRequest"                       textBinding="tablespacesSummary@defaultBean@servletRequest" 
                       columns="100" rows="5" wrap="hard" readOnly="true"/>
                  </uix:cellFormat>

              </uix:tableLayout>
            </uix:header>
          </uix:case>

          <uix:case name="datafiles">
            <uix:switcher childNameBinding="operationType@defaultBean@servletRequest" defaultCase="non-bmr">
              <uix:case name="bmr">
                <uix:spacer height="10"/>
              </uix:case>
              <uix:case name="non-bmr">
                <uix:header textBinding="DATAFILES@recoveryBundle@servletRequest">
                  <uix:tableLayout cellSpacing="5" summary="tl">
                      <uix:cellFormat hAlign="left" width="150">
                      <uix:textInput name="datafilesSummary"
                           shortDescBinding="DATAFILES@recoveryBundle@servletRequest"
                           textBinding="datafilesSummary@defaultBean@servletRequest" 
                           columns="100" rows="5" wrap="hard" readOnly="true"/>
                      </uix:cellFormat>

                  </uix:tableLayout>
                </uix:header>
              </uix:case>
            </uix:switcher>

          </uix:case>
        </uix:switcher>

        <uix:switcher childNameBinding="renameType@defaultBean@servletRequest">
          <uix:case name="COMMON">
            <uix:header textBinding="RENAMED_FILES@recoveryBundle@servletRequest">
              <uix:tableLayout cellSpacing="5" summary="tl">
                  <uix:cellFormat hAlign="left" width="150">
                  <uix:textInput name="renameSummary"
                       shortDescBinding="RENAMED_FILES@recoveryBundle@servletRequest"
                       textBinding="renameSummary@defaultBean@servletRequest" 
                       columns="100" rows="5" wrap="hard" readOnly="true"/>
                  </uix:cellFormat>

              </uix:tableLayout>
            </uix:header>
          </uix:case>
        </uix:switcher>

            <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@commonBundle@servletRequest"/>
                <uix:submitButton formName="foo" textBinding="EDIT_RMAN_SCRIPT@commonBundle@servletRequest" name="event" value="showScript" shortDescBinding="EDIT_RMAN_SCRIPT@commonBundle@servletRequest"/>

                <uix:contents>

                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@pageContext"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>

               </uix:contents>
          <uix:switcher childNameBinding="showJob@defaultBean@servletRequest">
            <uix:case name="true">
               <uix:submitButton formName="foo" textBinding="SUBMIT_JOB@commonBundle@servletRequest" name="event" value="submitJob" shortDescBinding="SUBMIT_JOB@commonBundle@servletRequest"/>
            </uix:case>
            <uix:case name="false">
               <uix:submitButton formName="foo" textBinding="SUBMIT@recoveryBundle@servletRequest" name="event" value="submitJob" shortDescBinding="SUBMIT@recoveryBundle@servletRequest"/>
            </uix:case>
          </uix:switcher>

              </uix:pageButtonBar>
            </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>



