<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="RECOVERY_TABLESPACES@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>
        <%@ include file="/database/rec/trainMessages.jspf" %>

        <uix:styledText styleClass="OraInstructionText" textBinding="AUXILIARY_INTRO@recoveryBundle@servletRequest" />
            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" headers="">
                  <uix:messageTextInput name="auxLocation" id="auxLocation"
                       columns="80"
                       promptBinding="AUXILIARY_LOCATION@recoveryBundle@servletRequest"
                       tipBinding="AUXILIARY_LOCATION_TIP@recoveryBundle@servletRequest"
                       textBinding="auxLocation@defaultBean@servletRequest" />

                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:tableLayout summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="left" headers="">
                  <uix:messageCheckBox name="backupTSPITR"
                       textBinding="BACKUP_TSPITR@recoveryBundle@servletRequest"
                       tipBinding="BACKUP_TSPITR_TIP@recoveryBundle@servletRequest"
                       shortDescBinding="BACKUP_TSPITR_TIP@recoveryBundle@servletRequest"
                       checkedBinding="backupTSPITR@defaultBean@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

        <uix:styledText styleClass="OraInstructionText" textBinding="PITR_TABLESPACES_INTRO@recoveryBundle@servletRequest" />
            <uix:tableLayout cellSpacing="5" width="80%" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" headers="">
                  <uix:contents>
                    <uix:submitButton
                         textBinding="ADD@commonBundle@servletRequest"
                         name="event"
                         value="addTablespaces"
                         formName="foo" shortDescBinding="ADD@commonBundle@servletRequest" 
                    />
                    <uix:submitButton textBinding="CHECK_DEPENDENCY@recoveryBundle@servletRequest" name="event" value="checkDependency"  shortDescBinding="CHECK_DEPENDENCY@recoveryBundle@servletRequest" />
                  </uix:contents>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

              <oem:table
                width="80%"
                blockSize="10"
                formSubmitted="true"
                name="tablespacesUI"
                dataSourceProp="tablespacesUI"
                beanKey="tablespacesDataSourceBean"
                copyParams="target,type"
                alternateTextBinding="NO_ITEMS_SELECTED@commonBundle@servletRequest"
                summaryBinding="RECOVERY_TABLESPACES@recoveryBundle@servletRequest">
                <uix:tableSelection>
                  <uix:multipleSelection 
                       shortDescBinding="SELECT@commonBundle@servletRequest"
                       selectedBinding="selected"
                       selectionBinding="selection@tablespacesDataSourceBean@servletRequest">
                    <uix:submitButton
                         textBinding="REMOVE@commonBundle@servletRequest"
                         name="event"
                         value="removeTablespaces"
                         formName="foo"  shortDescBinding="REMOVE@commonBundle@servletRequest" />
                  </uix:multipleSelection>
                </uix:tableSelection>
              </oem:table>


          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@commonBundle@servletRequest" />
                <uix:contents>
                  <uix:navigationBar
                    name="tableNav"
                    blockSize="-1"
                    formSubmitted="true"
                    formName="foo"
                    maxValueBinding="maxPageSequence@defaultBean@servletRequest"
                    minValue="1"
                    valueBinding="pageSequence@defaultBean@servletRequest"/>
                </uix:contents>
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

