<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
<script>
function lovCallBack(data)
{
  destField = callBackLovField();
  if ((i=data.lastIndexOf('"')) > 0)
  {
    if(destField == "remoteHost")
    {
      document.forms[0].remoteHost.value=data.substring(1,i);
    }
  }
}
</script>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <db:script src="/database/LOV.js"/>
  <db:script src="/database/utils.js"/>

  <uix:bundle name="DBObjectMsgs" class="oracle.sysman.db.rsc.DBObjectMsg"/>
  <uix:bundle name="DBConfigMsgs" class="oracle.sysman.db.rsc.conf.DBConfigMsg"/>

  <uix:document>

    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="ignoreRelogin" value="true"/>

        <uix:formValue name="originalHost" valueBinding="originalHost@defaultBean@servletRequest"/>

      <uix:pageLayout titleBinding="filePageHeader@defaultBean@servletRequest">
        <%@ include file="/database/global.jspf" %>

        <uix:messages>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        destTableBinding="msgUrls@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        </uix:messages>


        <uix:styledText styleClass="OraInstructionText" textBinding="filePageIntro@defaultBean@servletRequest" />
        <uix:spacer height="5"/>
        <uix:switcher childNameBinding="DB10orHigher@defaultBean@servletRequest">
          <uix:case name="true">
            <uix:stackLayout>
              <uix:contents>

                <uix:tableLayout cellSpacing="5" width="80%" summary="t1" >
                  <uix:switcher childNameBinding="showOracleHome@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right" vAlign="top"  headers="" >
                          <uix:switcher childNameBinding="newHomeRequired@defaultBean@servletRequest">
                            <uix:case name="true">
                              <uix:messagePrompt labeledNodeId="OH" promptBinding="ORACLE_HOME@recoveryBundle@servletRequest" required="yes"/>
                            </uix:case>
                            <uix:case name="false">
                              <uix:messagePrompt labeledNodeId="OH" promptBinding="ORACLE_HOME@recoveryBundle@servletRequest" required="no"/>
                            </uix:case>
                          </uix:switcher>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left"  headers="" >
                          <uix:messageTextInput name="OH" id="OH" 
                               textBinding="OH@defaultBean@servletRequest"
                               tipBinding="oracleHomeTip@defaultBean@servletRequest"
                               shortDescBinding="oracleHomeTip@defaultBean@servletRequest"
                               columns="80" />
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:case>
                  </uix:switcher>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right"  headers="" >
                      <uix:messagePrompt labeledNodeId="dbid" promptBinding="DBID@recoveryBundle@servletRequest" />
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left"  headers="" >
                      <uix:textInput name="dbid" id="dbid" textBinding="dbid@defaultBean@servletRequest" columns="20" readOnlyBinding="dbidDisabled@defaultBean@servletRequest"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right"  headers="" >
                      <uix:messagePrompt labeledNodeId="dbUniqueName" promptBinding="DATABASE_NAME@recoveryBundle@servletRequest" />
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left"  headers="" >
                      <uix:textInput name="dbUniqueName" id="dbUniqueName" textBinding="dbUniqueName@defaultBean@servletRequest" columns="20" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                  
                  <uix:switcher childNameBinding="showRacInstSid@defaultBean@servletRequest">
                    <uix:case name="true">
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="right" vAlign="top"  headers="" >
                          <uix:messagePrompt labeledNodeId="racInstSid" promptBinding="RAC_INST_SID@recoveryBundle@servletRequest" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left"  headers="" >
                          <uix:messageTextInput name="racInstSid" id="racInstSid" textBinding="racInstSid@defaultBean@servletRequest"
                            tipBinding="RAC_INST_SID_TIP@recoveryBundle@servletRequest"
                            shortDescBinding="RAC_INST_SID_TIP@recoveryBundle@servletRequest"
                            columns="80" />
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:case>              
                  </uix:switcher>
              
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right" vAlign="top"  headers="" >
                      <uix:messagePrompt labeledNodeId="recoveryArea" promptBinding="RECOVERY_AREA@recoveryBundle@servletRequest" />
                    </uix:cellFormat>
                    <uix:cellFormat hAlign="left"  headers="" >
                      <uix:messageTextInput name="recoveryArea" id="recoveryArea" textBinding="recoveryArea@defaultBean@servletRequest"
                           tipBinding="RECOVERY_AREA_TIP@recoveryBundle@servletRequest"
                           shortDescBinding="RECOVERY_AREA_TIP@recoveryBundle@servletRequest"
                           columns="80" />
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>

                <uix:switcher childNameBinding="showRemoteRecovery@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:messageRadioButton
                                  name="recoveryType"
                                  styleClass="OraInstructionText"
                                  selectedValueBinding="recoveryType@defaultBean@servletRequest"
                                  textBinding="CURRENT_HOST_RECOVERY_RADIO@recoveryBundle@servletRequest"
                                  shortDescBinding="CURRENT_HOST_RECOVERY_RADIO@recoveryBundle@servletRequest"
                                  tipBinding="CURRENT_HOST_RECOVERY_RADIO_TIP@recoveryBundle@servletRequest"
                                  disabledBinding="remoteRecoveryNoSelect@defaultBean@servletRequest"
                                  onClick="submitForm('foo', true, {'event':'currentHostRecovery'})"
                                  value="currentHostRecovery"/>

                        <uix:messageRadioButton
                                  name="recoveryType"
                                  styleClass="OraInstructionText"
                                  selectedValueBinding="recoveryType@defaultBean@servletRequest"
                                  textBinding="REMOTE_HOST_RECOVERY_RADIO@recoveryBundle@servletRequest"
                                  shortDescBinding="REMOTE_HOST_RECOVERY_RADIO@recoveryBundle@servletRequest"
                                  tipBinding="REMOTE_HOST_RECOVERY_RADIO_TIP@recoveryBundle@servletRequest"
                                  disabledBinding="remoteRecoveryNoSelect@defaultBean@servletRequest"
                                  onClick="submitForm('foo', true, {'event':'remoteHostRecovery'})"
                                  value="remoteHostRecovery"/>
                        <uix:labeledFieldLayout>
                          <uix:contents>
                            <uix:messageLovField columns="30"
                                searchDescBinding="REMOTE_HOST@recoveryBundle@servletRequest"
                                name="remoteHost" id="remoteHost"
                                promptBinding="REMOTE_HOST@recoveryBundle@servletRequest" 
                                shortDescBinding="REMOTE_HOST@recoveryBundle@servletRequest"
                                textBinding="remoteHost@defaultBean@servletRequest" required="uiOnly"
                                tipBinding="REMOTE_HOST_TIP@recoveryBundle@servletRequest"
                                disabledBinding="remoteRecoveryReadOnly@defaultBean@servletRequest"
                                onClick = "setWindowSize(800,700); useCallBack(); setBindSqlParm('originalHost');
                                startLov('remoteHost', 'ListManagedHostOnly')"/>
                              <uix:messagePrompt labeledNodeId="remoteHostUsername"
                                      required="yes"
                                      promptBinding="REMOTE_HOST_USERNAME@recoveryBundle@servletRequest" />
                              <uix:textInput name="remoteHostUsername" id="remoteHostUsername" 
                                      disabledBinding="remoteRecoveryReadOnly@defaultBean@servletRequest"
                                      textBinding="remoteHostUsername@defaultBean@servletRequest" columns="20" 
    				  noAutoComplete="true"/>
                              <uix:messagePrompt labeledNodeId="remoteHostPassword"
                                      required="yes"
                                      promptBinding="REMOTE_HOST_PASSWORD@recoveryBundle@servletRequest" />
                              <uix:textInput name="remoteHostPassword" id="remoteHostPassword" secret="true" 
                                      disabledBinding="remoteRecoveryReadOnly@defaultBean@servletRequest"
                                      textBinding="remoteHostPassword@defaultBean@servletRequest" columns="20"
    				  noAutoComplete="true"/>
                          </uix:contents>
                        </uix:labeledFieldLayout>

<%--
                        <uix:tableLayout cellSpacing="5" width="50%">
                          <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                              <uix:messagePrompt labeledNodeId="remoteHost" 
                                      required="yes"
                                      promptBinding="REMOTE_HOST@recoveryBundle@servletRequest" />
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:choice name="remoteHost" id="remoteHost"
                                      styleClass="OraInstructionText"
                                      disabledBinding="remoteRecoveryReadOnly@defaultBean@servletRequest"
                                      selectedValueBinding="remoteHost@defaultBean@servletRequest">
                                <uix:contents childDataBinding="allRemoteHosts@defaultBean@servletRequest">
                                  <uix:option textBinding="."/>
                                </uix:contents>
                              </uix:choice>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                              <uix:messagePrompt labeledNodeId="remoteHostUsername"
                                      required="yes"
                                      promptBinding="REMOTE_HOST_USERNAME@recoveryBundle@servletRequest" />
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:textInput name="remoteHostUsername" id="remoteHostUsername" 
                                      disabledBinding="remoteRecoveryReadOnly@defaultBean@servletRequest"
                                      textBinding="remoteHostUsername@defaultBean@servletRequest" columns="20" 
    				  noAutoComplete="true"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                              <uix:messagePrompt labeledNodeId="remoteHostPassword"
                                      required="yes"
                                      promptBinding="REMOTE_HOST_PASSWORD@recoveryBundle@servletRequest" />
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:textInput name="remoteHostPassword" id="remoteHostPassword" secret="true" 
                                      disabledBinding="remoteRecoveryReadOnly@defaultBean@servletRequest"
                                      textBinding="remoteHostPassword@defaultBean@servletRequest" columns="20"
    				  noAutoComplete="true"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout>
                            <uix:cellFormat hAlign="right">
                              <uix:messagePrompt labeledNodeId="remoteHostOracleSid" 
                              promptBinding="REMOTE_HOST_ORACLE_SID@recoveryBundle@servletRequest" />
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:textInput name="remoteHostOracleSid" id="remoteHostOracleSid" textBinding="remoteHostOracleSid@defaultBean@servletRequest" columns="20"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:tableLayout>
--%>

                      </uix:contents>
                    </uix:stackLayout>
                  </uix:case>
                </uix:switcher>

              </uix:contents>
            </uix:stackLayout>

          </uix:case>
          <uix:case name="false">
            <uix:labeledFieldLayout labelWidth="30%">
              <uix:contents>
                <uix:messagePrompt labeledNodeId="dbid" promptBinding="DBID@recoveryBundle@servletRequest" />
                <uix:textInput name="dbid" id="dbid" textBinding="dbid@defaultBean@servletRequest" columns="20" readOnlyBinding="dbidDisabled@defaultBean@servletRequest"/>
              </uix:contents>
            </uix:labeledFieldLayout>
          </uix:case>
        </uix:switcher>

      <uix:header textBinding="BACKUP_INFO@recoveryBundle@servletRequest">
        <uix:styledText styleClass="OraInstructionText"
                         textBinding="BACKUP_INFO_INTRO@recoveryBundle@servletRequest"/>

        <uix:tableLayout cellSpacing="5" width="80%" summary="t1" >
          <uix:rowLayout>
            <uix:cellFormat hAlign="left"  headers="" >
              <uix:messageRadioButton name="fromRC" value="true"
                   selectedValueBinding="fromRC@defaultBean@servletRequest"
                   textBinding="FROM_RC@recoveryBundle@servletRequest"
                   styleClass="OraInstructionText" />
            </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:labeledFieldLayout labelWidth="50%">
              <uix:contents>
                <uix:messagePrompt promptBinding="RC_DB@commonBundle@servletRequest" />
                <uix:switcher childNameBinding="useRC@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:styledText styleClass="OraInstructionTextStrong"
                         textBinding="rcDatabase@defaultBean@servletRequest"/>
                  </uix:case>
                  <uix:case name="false">
                    <uix:styledText styleClass="OraInstructionTextStrong"
                         textBinding="NOT_SPECIFIED@commonBundle@servletRequest"/>
                  </uix:case>
                </uix:switcher>
              </uix:contents>
            </uix:labeledFieldLayout>
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:cellFormat hAlign="center"  headers="" >
                <uix:submitButton textBinding="EDIT_RC@commonBundle@servletRequest" name="event" value="editRC"  shortDescBinding="EDIT_RC@commonBundle@servletRequest" />
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left"  headers="" >
              <uix:messageRadioButton name="fromRC" value="false"
                   textBinding="FROM_NO_RC@recoveryBundle@servletRequest" 
                   selectedValueBinding="fromRC@defaultBean@servletRequest"
                   disabledBinding="restoreFromAutoBackupDisabled@defaultBean@servletRequest"
                   styleClass="OraInstructionText" />
            </uix:cellFormat>
          </uix:rowLayout>

          <uix:rowLayout> 
            <uix:cellFormat hAlign="left"  headers="" >
              <uix:rowLayout hAlign="left"> 
                <uix:spacer width="20"/>
                <uix:messageRadioButton name="fromAutoBackup" value="true"
                     textBinding="FROM_AUTOBACKUP@recoveryBundle@servletRequest" 
                     shortDescBinding="FROM_AUTOBACKUP_TIP@recoveryBundle@servletRequest" 
                     selectedValueBinding="fromAutoBackup@defaultBean@servletRequest" 
                     disabledBinding="restoreFromAutoBackupDisabled@defaultBean@servletRequest"
                     styleClass="OraInstructionText" />
              </uix:rowLayout>
            </uix:cellFormat>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:cellFormat hAlign="left"  headers="" >
              <uix:rowLayout hAlign="left">
                <uix:spacer width="20"/>
                <uix:messageRadioButton name="fromAutoBackup" value="false"
                     textBinding="FROM_BACKUP_NAME@recoveryBundle@servletRequest" 
                     shortDescBinding="FROM_BACKUP_NAME_TIP@recoveryBundle@servletRequest" 
                     selectedValueBinding="fromAutoBackup@defaultBean@servletRequest" 
                     disabledBinding="restoreFromAutoBackupDisabled@defaultBean@servletRequest"
                     styleClass="OraInstructionText" />
              </uix:rowLayout>
            </uix:cellFormat>
          </uix:rowLayout>

        </uix:tableLayout>
        </uix:header>

        <uix:header textBinding="TAPE_SETTINGS@recoveryBundle@servletRequest">
        <uix:tableLayout cellSpacing="5" summary="t1" >
          <uix:styledText styleClass="OraInstructionText" textBinding="TAPE_SETTINGS_INTRO@recoveryBundle@servletRequest" />

          <uix:rowLayout>
            <uix:labeledFieldLayout labelWidth="30%">
              <uix:contents>
                <uix:messagePrompt labeledNodeId="tapeParms" promptBinding="MMV_PARMS@recoveryBundle@servletRequest" />
                <uix:textInput name="tapeParms" id="tapeParms"
                     textBinding="tapeParms@defaultBean@servletRequest"
                     rows="4"
                     columns="80" />
              </uix:contents>
            </uix:labeledFieldLayout>
          </uix:rowLayout>
        </uix:tableLayout>
        </uix:header>

          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@commonBundle@servletRequest" />
                <uix:submitButton formName="foo" textBinding="CONTINUE@commonBundle@servletRequest" name="event" value="restoreControlfileOptions" shortDescBinding="CONTINUE@commonBundle@servletRequest" />
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>


