<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>

<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest" method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="pageSeq" valueBinding="pageSequence@defaultBean@servletRequest"/>
        <uix:formValue name="ignoreRelogin" value="true"/>
        <uix:formValue name="returnPage" value="options"/>

      <uix:pageLayout titleBinding="filePageHeader@defaultBean@servletRequest">
        <%@ include file="/database/global.jspf" %>
        <uix:messages>
        <oem:messageBox messageTypeBinding="messageType@servletRequest"
                        errorTableBinding="msgBox@servletRequest"
                        destTableBinding="msgUrls@servletRequest"
                        titleTextKey="titleText" mainTextKey="mainText"/>
        </uix:messages>
        <uix:switcher childNameBinding="DB10orHigher@defaultBean@servletRequest">
          <uix:case name="true">
            <uix:labeledFieldLayout labelWidth="30%">
              <uix:contents>
                <uix:switcher childNameBinding="showOracleHome@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:messagePrompt promptBinding="ORACLE_HOME@recoveryBundle@servletRequest" />
                  </uix:case>
                </uix:switcher>
                <uix:switcher childNameBinding="showOracleHome@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:styledText styleClass="OraInstructionTextStrong" textBinding="OH@defaultBean@servletRequest" />
                  </uix:case>
                </uix:switcher>
                <uix:messagePrompt promptBinding="DBID@recoveryBundle@servletRequest" />
                <uix:styledText styleClass="OraInstructionTextStrong" textBinding="dbidForDisplay@defaultBean@servletRequest" />
                <uix:messagePrompt promptBinding="DATABASE_NAME@recoveryBundle@servletRequest" />
                <uix:styledText styleClass="OraInstructionTextStrong" textBinding="dbUniqueNameForDisplay@defaultBean@servletRequest" />
                <uix:messagePrompt promptBinding="RECOVERY_AREA@recoveryBundle@servletRequest" />
                <uix:styledText styleClass="OraInstructionTextStrong" textBinding="recoveryAreaForDisplay@defaultBean@servletRequest" />
              </uix:contents>
            </uix:labeledFieldLayout>
          </uix:case>
          <uix:case name="false">
            <uix:labeledFieldLayout labelWidth="30%">
              <uix:contents>
                <uix:messagePrompt labeledNodeId="dbid" promptBinding="DBID@recoveryBundle@servletRequest" />
                <uix:styledText styleClass="OraInstructionTextStrong" textBinding="dbidForDisplay@defaultBean@servletRequest" />
              </uix:contents>
            </uix:labeledFieldLayout>
          </uix:case>
        </uix:switcher>

        <uix:switcher childNameBinding="showListenerLov@defaultBean@servletRequest">
          <uix:case name="true">
            <uix:header textBinding="LISTENER_CONF@testDBMsgs"
                renderedBinding="remoteRecovery@defaultBean@servletRequest">
              <uix:contents>
                <uix:messageStyledText styleClass="OraInstructionText"
                    textBinding="LISTENER_CONF_INSTR@testDBMsgs"/>
                <uix:spacer height="10" width="10"/>
                <%@ include file="listenersLov.jspf"%>
              </uix:contents>
            </uix:header>
          </uix:case>
        </uix:switcher>


      <uix:header textBinding="BACKUP_SELECTION@recoveryBundle@servletRequest">
        <uix:switcher childNameBinding="fromRC@defaultBean@servletRequest">
          <uix:case name="true">
            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:styledText styleClass="OraInstructionText" textBinding="RC_DEFAULT@recoveryBundle@servletRequest" />

              </uix:rowLayout>
              <uix:rowLayout>
                  <uix:hideShow disclosedBinding="showAdvBackupSelection@defaultBean@servletRequest"
                                formSubmitted="true" id="hideShowBS"
                                disclosedTextBinding="HIDE_ADVANCED_OPTIONS@commonBundle@servletRequest"
                                undisclosedTextBinding="SHOW_ADVANCED_OPTIONS@commonBundle@servletRequest">
                    <uix:contents>
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left" vAlign="top" headers="">
                          <uix:spacer width="10"/>
                          <oem:radioButton name="backupType" value="recent"
                                             shortDescBinding="MOST_RECENT_BACKUP@recoveryBundle@servletRequest"
                                             selectedValueBinding="backupType@defaultBean@servletRequest"
                                             textBinding="MOST_RECENT_BACKUP@recoveryBundle@servletRequest"
                                             styleClass="OraInstructionText" />
                        </uix:cellFormat>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left" vAlign="top" headers="">
                          <uix:spacer width="10"/>
                          <oem:radioButton name="backupType" value="time"
                                             shortDescBinding="PITR_BACKUP@recoveryBundle@servletRequest"
                                             selectedValueBinding="backupType@defaultBean@servletRequest"
                                             textBinding="PITR_BACKUP@recoveryBundle@servletRequest"
                                             styleClass="OraInstructionText" />
                        </uix:cellFormat>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left" vAlign="top" headers="">
                          <uix:spacer width="50"/>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left"  headers="">
                          <uix:messagePrompt promptBinding="DATE_LABEL@recoveryBundle@servletRequest" />
                          <uix:spacer width="5"/>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="center" vAlign="top" columnSpan="2" headers="">
                          <uix:messageDateField name="untilDate" shortDescBinding="dateTip@scheduleBean@servletRequest" columns="10" valueBinding="untilDate@defaultBean@servletRequest" tipBinding="dateTip@scheduleBean@servletRequest">
                            <uix:onSubmitValidater>
                              <uix:date dateStyle="medium"/>
                            </uix:onSubmitValidater>
                          </uix:messageDateField>
                        </uix:cellFormat>

                        <uix:cellFormat hAlign="left" vAlign="top" headers="">
                          <uix:spacer width="20"/>
                          <uix:messagePrompt promptBinding="TIME_LABEL@recoveryBundle@servletRequest" />
        
                          <oem:choice
                               shortDescBinding="TIME_LABEL@recoveryBundle@servletRequest"
                               name="untilTimeHour"
                               optionsBinding="hoursListSource@defaultBean@servletRequest"
                               selectedValueBinding="untilTimeHour@defaultBean@servletRequest" />
                          <oem:choice
                               shortDescBinding="TIME_LABEL@recoveryBundle@servletRequest"
                               name="untilTimeMinute"
                               optionsBinding="minutesListSource@defaultBean@servletRequest"
                               selectedValueBinding="untilTimeMinute@defaultBean@servletRequest" />
                          <oem:radioButton name="untilTimeAmPm" value="am"
                               selectedValueBinding="untilTimeAmPm@defaultBean@servletRequest"
                               shortDescBinding="AM"
                               textBinding="AM_LABEL@recoveryBundle@servletRequest"
                               styleClass="OraInstructionText" />
                          <oem:radioButton name="untilTimeAmPm" value="pm"
                               selectedValueBinding="untilTimeAmPm@defaultBean@servletRequest"
                               shortDescBinding="PM"
                               textBinding="PM_LABEL@recoveryBundle@servletRequest"
                               styleClass="OraInstructionText" />
                        </uix:cellFormat>
                      </uix:rowLayout>

                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left" vAlign="top" headers="">
                          <uix:spacer width="10"/>
                          <oem:radioButton name="backupType" value="tag"
                               selectedValueBinding="backupType@defaultBean@servletRequest"
                               shortDescBinding="BACKUP_TAG@recoveryBundle@servletRequest"
                               textBinding="BACKUP_TAG@recoveryBundle@servletRequest"
                               styleClass="OraInstructionText" />
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" headers="">
                          <uix:choice name="backupTag"
                               shortDescBinding="BACKUP_TAG@recoveryBundle@servletRequest"
                               selectedValueBinding="backupTag@defaultBean@servletRequest">
                            <uix:contents
                                 childDataBinding="allBackupTags@defaultBean@servletRequest">
                              <uix:option textBinding="text" valueBinding="value"/>
                            </uix:contents>
                          </uix:choice>
                        </uix:cellFormat>
                      </uix:rowLayout>

                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left" vAlign="top" headers="">
                          <uix:spacer width="10"/>
                          <oem:radioButton name="backupType" value="handle"
                               selectedValueBinding="backupType@defaultBean@servletRequest"
                               shortDescBinding="FROM_BACKUP_NAME@recoveryBundle@servletRequest"
                               textBinding="FROM_BACKUP_NAME@recoveryBundle@servletRequest"
                               styleClass="OraInstructionText" />
                        </uix:cellFormat>
                      </uix:rowLayout>

                      <uix:rowLayout>
                      <uix:spacer width="50"/>
                        <uix:labeledFieldLayout labelWidth="50%">
                          <uix:contents>
                            <uix:messagePrompt labeledNodeId="backupHandle" promptBinding="BACKUP_NAME@recoveryBundle@servletRequest" />
                            <uix:textInput name="backupHandle" id="backupHandle" textBinding="backupHandle@defaultBean@servletRequest" columns="60" />
                          </uix:contents>
                        </uix:labeledFieldLayout>
                      </uix:rowLayout>
                    </uix:contents>
                  </uix:hideShow>

              </uix:rowLayout>
            </uix:tableLayout>
          </uix:case>
          <uix:case name="false">
            <uix:switcher childNameBinding="fromAutoBackup@defaultBean@servletRequest">
              <uix:case name="true">
                <uix:tableLayout cellSpacing="5" summary="tl">
                  <uix:rowLayout>
                    <uix:switcher childNameBinding="useRecoveryArea@defaultBean@servletRequest">
                      <uix:case name="true">
                        <uix:styledText styleClass="OraInstructionText" textBinding="AUTOBACKUP_LOC_RA@recoveryBundle@servletRequest" />
                      </uix:case>
                      <uix:case name="false">
                        <uix:styledText styleClass="OraInstructionText" textBinding="AUTOBACKUP_LOC_NORA@recoveryBundle@servletRequest" />
                      </uix:case>
                    </uix:switcher>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:labeledFieldLayout labelWidth="30%">
                      <uix:contents>
                        <uix:messagePrompt labeledNodeId="autoBackupLocation" promptBinding="AUTOBACKUP_LOCATION@recoveryBundle@servletRequest" />
                        <uix:textInput name="autoBackupLocation" id="autoBackupLocation" textBinding="autoBackupLocation@defaultBean@servletRequest" columns="80" />
                      </uix:contents>
                    </uix:labeledFieldLayout>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:spacer width="10"/>
                  </uix:rowLayout>

                  <uix:rowLayout>
                    <uix:styledText styleClass="OraInstructionText" textBinding="AUTOBACKUP_DEFAULT@recoveryBundle@servletRequest" />
                  </uix:rowLayout>

                  <uix:rowLayout>
                  <uix:hideShow disclosedBinding="showAdvBackupSelection@defaultBean@servletRequest"
                                formSubmitted="true" id="hideShowBS"
                                disclosedTextBinding="HIDE_ADVANCED_OPTIONS@commonBundle@servletRequest"
                                undisclosedTextBinding="SHOW_ADVANCED_OPTIONS@commonBundle@servletRequest">
                    <uix:contents>
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left" vAlign="top" headers="">
                          <uix:spacer width="10"/>
                          <oem:radioButton name="backupType" value="recent"
                                             shortDescBinding="MOST_RECENT_BACKUP@recoveryBundle@servletRequest"
                                             selectedValueBinding="backupType@defaultBean@servletRequest"
                                             textBinding="MOST_RECENT_BACKUP@recoveryBundle@servletRequest"
                                             styleClass="OraInstructionText" />
                        </uix:cellFormat>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:cellFormat hAlign="left" vAlign="top" headers="">
                          <uix:spacer width="10"/>
                          <oem:radioButton name="backupType" value="time"
                                             shortDescBinding="AUTOBACKUP_DATE@recoveryBundle@servletRequest"
                                             selectedValueBinding="backupType@defaultBean@servletRequest"
                                             textBinding="AUTOBACKUP_DATE@recoveryBundle@servletRequest"
                                             styleClass="OraInstructionText" />
                          <uix:spacer width="20"/>
                          <uix:messagePrompt promptBinding="DATE_LABEL@recoveryBundle@servletRequest" />
                          <uix:spacer width="5"/>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="center" vAlign="top" columnSpan="2" headers="">
                          <uix:messageDateField name="untilDate" shortDescBinding="dateTip@scheduleBean@servletRequest" columns="10" valueBinding="untilDate@defaultBean@servletRequest" tipBinding="dateTip@scheduleBean@servletRequest">
                            <uix:onSubmitValidater>
                              <uix:date dateStyle="medium"/>
                            </uix:onSubmitValidater>
                          </uix:messageDateField>
                        </uix:cellFormat>
                      </uix:rowLayout>

                    </uix:contents>
                  </uix:hideShow>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:case>
              <uix:case name="false">
                <uix:tableLayout cellSpacing="5" summary="tl">
                  <uix:rowLayout>
                    <uix:labeledFieldLayout labelWidth="50%">
                      <uix:contents>
                        <uix:messagePrompt labeledNodeId="backupHandle" promptBinding="BACKUP_NAME@recoveryBundle@servletRequest" />
                        <uix:textInput name="backupHandle" id="backupHandle" textBinding="backupHandle@defaultBean@servletRequest" columns="60" />
                      </uix:contents>
                    </uix:labeledFieldLayout>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:case>
            </uix:switcher>
          </uix:case>
        </uix:switcher>
      </uix:header>

      <uix:header textBinding="RENAME_COMMON_DIR@recoveryBundle@servletRequest">
        <uix:switcher childNameBinding="spfileRestore@defaultBean@servletRequest">
          <uix:case name="true">
            <uix:switcher childNameBinding="remoteRecovery@defaultBean@servletRequest">
              <uix:case name="true">
                <uix:stackLayout>
                  <uix:contents>
                    <uix:styledText styleClass="OraInstructionText" textBinding="REMOTE_STORAGE_OPTIONS_TEXT@recoveryBundle@servletRequest" />
                     <uix:submitButton formName="foo"
                         shortDescBinding="REMOTE_STORAGE_OPTIONS_BUTTON@recoveryBundle@servletRequest"
                         textBinding="REMOTE_STORAGE_OPTIONS_BUTTON@recoveryBundle@servletRequest"
                         name="event" value="storageOptionsEvent"/>
                  </uix:contents>
                </uix:stackLayout>
              </uix:case>
            </uix:switcher>
          </uix:case>
        </uix:switcher>
        <uix:tableLayout cellSpacing="5" summary="tl">
          <uix:rowLayout>
            <uix:switcher childNameBinding="dbStatus@defaultBean@servletRequest">
              <uix:case name="CLOSED">
                <uix:styledText styleClass="OraInstructionText" textBinding="spfileLocIntro@defaultBean@servletRequest" />
              </uix:case>
              <uix:case name="STARTED">
                <uix:tableLayout cellSpacing="5" summary="tl">
                  <uix:rowLayout>
                    <uix:styledText styleClass="OraInstructionText" textBinding="RENAME_CONTROLFILE@recoveryBundle@servletRequest" />
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:stackLayout>
                      <uix:contents childDataBinding="origControlfiles@defaultBean@servletRequest">
                        <uix:styledText styleClass="OraInstructionTextStrong" textBinding="value"/>
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:rowLayout>
                </uix:tableLayout>
              </uix:case>
            </uix:switcher>
          </uix:rowLayout>
          <uix:rowLayout>
            <uix:switcher childNameBinding="dbStatus@defaultBean@servletRequest">
              <uix:case name="CLOSED">
                <uix:switcher childNameBinding="SYSPasswordRequired@defaultBean@servletRequest">
                  <uix:case name="true">
                    <uix:labeledFieldLayout labelWidth="30%">
                      <uix:contents>
                        <uix:messagePrompt labeledNodeId="sysPasword" promptBinding="PROVIDE_SYS_PASSWORD@recoveryBundle@servletRequest" required="yes"/>
                        <uix:textInput name="sysSecretPassword" secret="true" id="sysSecretPassword" textBinding="sysSecretPassword@defaultBean@servletRequest" columns="80" noAutoComplete="true"/>
                        <uix:messagePrompt labeledNodeId="sysPassword2" promptBinding="CONFIRM_SYS_PASSWORD@recoveryBundle@servletRequest" required="yes"/>
                        <uix:textInput name="sysSecretPassword2" secret="true" id="sysSecretPassword2" textBinding="sysSecretPassword2@defaultBean@servletRequest" columns="80" noAutoComplete="true"/>
                      </uix:contents>
                    </uix:labeledFieldLayout>
                  </uix:case>
                </uix:switcher>
              </uix:case>
            </uix:switcher>
          </uix:rowLayout>

          <uix:rowLayout>
            <uix:hideShow disclosedBinding="showAdvAltName@defaultBean@servletRequest"
                          formSubmitted="true" id="hideShowAN"
                          disclosedTextBinding="HIDE_ADVANCED_SETTINGS@commonBundle@servletRequest"
                          undisclosedTextBinding="SHOW_ADVANCED_SETTINGS@commonBundle@servletRequest">
              <uix:contents>
<%--
                <uix:switcher childNameBinding="dbStatus@defaultBean@servletRequest">
                  <uix:case name="CLOSED">
                    <uix:styledText styleClass="OraInstructionText" textBinding="RENAME_SPFILE@recoveryBundle@servletRequest" />
                  </uix:case>
                  <uix:case name="STARTED">
                    <uix:styledText styleClass="OraInstructionText" textBinding="RENAME_CONTROLFILE@recoveryBundle@servletRequest" />
                  </uix:case>
                </uix:switcher>
--%>

                <uix:switcher childNameBinding="dbStatus@defaultBean@servletRequest">
                  <uix:case name="CLOSED">
                    <uix:labeledFieldLayout labelWidth="30%">
                      <uix:contents>
                        <uix:messagePrompt labeledNodeId="spfileName" promptBinding="SPFILE_NAME@recoveryBundle@servletRequest" />
                        <uix:textInput name="spfileName" id="spfileName" textBinding="spfileName@defaultBean@servletRequest" columns="80" />
                      </uix:contents>
                    </uix:labeledFieldLayout>
                  </uix:case>
                  <uix:case name="STARTED">
                    <uix:labeledFieldLayout labelWidth="30%">
                      <uix:contents childDataBinding="newControlfiles@defaultBean@servletRequest">
                        <uix:messagePrompt labeledNodeId="controlfiles" promptBinding="CONTROLFILE_NAME@recoveryBundle@servletRequest" />
                        <uix:textInput nameBinding="text" id="controlfiles" textBinding="value" columns="80" />
                      </uix:contents>
                    </uix:labeledFieldLayout>
                  </uix:case>
                </uix:switcher>
              </uix:contents>
            </uix:hideShow>
          </uix:rowLayout>

        </uix:tableLayout>
      </uix:header>

      <!-- Encryption -->
      <%@ include file="recoveryEncrypt.jspf" %>


          <uix:pageButtons>
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonBundle@servletRequest" formName="foo" name="event" value="cancel" shortDescBinding="CANCEL@commonBundle@servletRequest" />
                <uix:submitButton textBinding="BACK@commonBundle@servletRequest" formName="foo" name="event" value="backToFilePage" shortDescBinding="BACK@commonBundle@servletRequest" />
                <uix:submitButton formName="foo" textBinding="EDIT_RMAN_SCRIPT@commonBundle@servletRequest" name="event" value="showScript" shortDescBinding="EDIT_RMAN_SCRIPT@commonBundle@servletRequest" />
                <uix:submitButton formName="foo" textBinding="RESTORE@recoveryBundle@servletRequest" name="event" value="restoreConfirm" shortDescBinding="RESTORE@recoveryBundle@servletRequest" />
              </uix:pageButtonBar>
          </uix:pageButtons>

      </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>


