<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag/db" prefix="db"%>
                                                                                                   
<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
                                                                                                   
  <uix:document>
                                                                                                   
    <%@ include file="/oemTitle.jspf" %>
                                                                                                   
    <uix:body>
                                                                                                   
    <db:form name="foo" destinationBinding="destination@defaultBean@servletRequest"
        method="post" copyParams="target,type">
        <uix:formValue name="source"/>
        <uix:formValue name="value"/>

      <uix:pageLayout titleBinding="MANAGE_RESTORE_POINTS@recoveryBundle@servletRequest">
        <%@ include file="/database/global.jspf" %>
             <oem:messageBox messageTypeBinding="messageType@servletRequest"
                             errorTableBinding="msgBox@servletRequest"
                             titleTextKey="titleText" mainTextKey="mainText"/>
          <uix:styledText styleClass="OraInstructionText" textBinding="introText@defaultBean@servletRequest" />

          <uix:header textBinding="SEARCH@commonBundle@servletRequest">
            <uix:tableLayout cellSpacing="5" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right" columnSpan="3">
                  <uix:styledText
                       styleClass="OraInstructionText"
                       textBinding="CRITERIA@commonBundle@servletRequest"/>
                </uix:cellFormat>
              </uix:rowLayout>
              <uix:rowLayout>
                  <uix:contents>
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:flowLayout>
                          <uix:styledText
                            labeledNodeId="searchFilter"
                            styleClass="OraPromptText"
                            textBinding="RESTORE_POINT_NAME@recoveryBundle@servletRequest"/>
                          <uix:textInput name="searchFilter"
                            id="searchFilter"
                            textBinding="searchFilter@defaultBean@servletRequest"/>
                          <uix:submitButton
                            textBinding="GO@commonBundle@servletRequest"
                            onFocus="true"
                            selected="true" name="event" value="cancel" shortDescBinding="GO@commonBundle@servletRequest"/>
                        </uix:flowLayout>
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:contents>
              </uix:rowLayout>
            </uix:tableLayout>
          </uix:header>

            <uix:tableLayout cellSpacing="5" width="80%" summary="tl">
              <uix:rowLayout>
                <uix:cellFormat hAlign="right">
                  <uix:contents>
                    <uix:submitButton textBinding="CREATE@recoveryBundle@servletRequest" name="event" value="create" formName="foo"  shortDescBinding="CREATE@recoveryBundle@servletRequest"/>
                  </uix:contents>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

          <oem:table
            width="80%"
            blockSize="10"
            formSubmitted="true"
            name="restorePointsUI"
            dataSourceProp="restorePointsUI"
            beanKey="restorePointsDataSourceBean"
            alternateTextBinding="NO_ROWS_FOUND@recoveryBundle@servletRequest"
            summaryBinding="MANAGE_RESTORE_POINTS@recoveryBundle@servletRequest">
            <uix:tableSelection>

              <uix:singleSelection 
                   shortDesc="select"
                   selectedIndex="0">
                <%--
		<uix:switcher childNameBinding="targetSYSDBA@defaultBean@servletRequest">
                  <uix:case name="true">
		 --%> 
                    <uix:submitButton textBinding="FLASHBACK_DB_TO@recoveryBundle@servletRequest" name="event" value="recoverDatabase" formName="foo"  shortDescBinding="FLASHBACK_DB_TO@recoveryBundle@servletRequest"/>
                <%--
		  </uix:case>
                </uix:switcher>
		--%>
                <uix:submitButton textBinding="DELETE@recoveryBundle@servletRequest" name="event" value="delete" formName="foo" shortDescBinding="DELETE@recoveryBundle@servletRequest" />
              </uix:singleSelection>
            </uix:tableSelection>
          </oem:table>
                <uix:stackLayout>
                    <uix:tip>
                      <uix:styledText textBinding="NRP_STORAGE_TIP@recoveryBundle@servletRequest" />
                    </uix:tip>
                </uix:stackLayout>


          <uix:switcher childNameBinding="targetSYSDBA@defaultBean@servletRequest">
            <uix:case name="true">
              <uix:header textBinding="RELATED_LINKS@recoveryBundle@servletRequest">
                <uix:stackLayout>
                  <db:link textBinding="RECOVERY_SETTINGS@recoveryBundle@servletRequest"
                           destination="/console/database/instance/recovery" copyParams="target,type"/>
                  <db:link textBinding="RECOVERY_TYPE@recoveryBundle@servletRequest"
                           destination="/console/database/rec/recovery?event=start" copyParams="target,type"/>
                </uix:stackLayout>
              </uix:header>
            </uix:case>
          </uix:switcher>
         </uix:pageLayout>
    </db:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

