<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
<uix:bundle name="commonBundle" class="oracle.sysman.db.rsc.rec.CommonMsg"/>
<uix:bundle name="catalogBundle" class="oracle.sysman.db.rsc.rec.CatalogMsg"/>
  <uix:document>

    <uix:metaContainer>
      <uix:head titleBinding="SELECT_USER_TITLE@catalogBundle"/>
    </uix:metaContainer>

    <uix:body>
      <uix:contents>
        <%-- Cannot use the form tag with the listOfValues tag (though
          -- it is ok to use the formValue tag).  The error encountered
          -- when using the form tag with the listOfValues tag is:
          -- "cannot nest form elements"
        <uix:form name="foo" method="post" destinationBinding="destination@selectSchemaBean@servletRequest">
        --%>
          <uix:listOfValues
              titleBinding="SELECT_USER_OBJECT@catalogBundle"
              shortDescBinding="SELECT_USER_OBJECT@catalogBundle"
              searchTextBinding="searchCriteria@defaultBean@servletRequest">
            <uix:formValue name="pageName"
                           value="/database/rec/vpc/selectUser"/>
            <uix:searchInstructions>
              <uix:styledText styleClass="OraInstructionText"
                  textBinding="SELECT_USER_SEARCH_ITEM@catalogBundle"/>
            </uix:searchInstructions>
            <uix:contents>
              <oem:table
                  beanKey="defaultBean"
                  alternateTextBinding="MSG_NO_ITEMS_FOUND@catalogBundle"
                  name="dataSource"
                  dataSourceProp="dataSource"
                  width="100%"
                  blockSize="10"
                  formSubmitted="true"
                  proxied="true"
                  summaryBinding="ADD_USER_FUNC@catalogBundle">
                <uix:tableSelection>
                  <uix:singleSelection
                      selectedIndex="0" shortDescBinding="SELECT@commonBundle"/>
                </uix:tableSelection>
              </oem:table>
            </uix:contents>
          </uix:listOfValues>
        <%--</uix:form>--%>
      </uix:contents>
    </uix:body>
  </uix:document>
</uix:renderingContext>

